package jcircus;


import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.swing.JOptionPane;

import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.JCircusException;
import jcircus.exceptions.TranslationCancelledException;
import jcircus.parallelism.ParallelismVisitor;
import jcircus.translator.Translator2Java;
import jcircus.util.Constants;
import jcircus.util.Error;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnmarshalException;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.parser.circus.CircusParseError;
import net.sourceforge.czt.parser.circus.ParseUtils;
import net.sourceforge.czt.parser.util.ErrorType;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.session.FileSource;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.circus.WarningManager;
import net.sourceforge.czt.typecheck.z.ErrorAnn;
import net.sourceforge.czt.z.ast.Spec;
//import net.sourceforge.czt.circustools.ast.*;
//import circparser.CircusParser;

/**
 * JCircus.java
 *
 * Main class of JCircus, with access to all the modules of the tool.
 *
 * @author Angela Freitas
 *
 */
public abstract class JCircusController {

    static private final String NEWLINE = "\n";

    /* Translator */
    protected Translator2Java _translator;
    Spec spec = null;
    //ParallelismVisitor parallelismVisitor = new ParallelismVisitor();
    /**
     * Performs parser, type checking and translates the given input file.
     */
    public void translate (String path, String projectDir, String projectName
    		, String compl, boolean useBarriers, boolean parallelism/*, int minComm, int maxComm*/)
            throws Exception {
        try {
            spec = parse(path);
            typeCheck(spec);
            translate2Java(projectDir, projectName, spec, compl, useBarriers, parallelism);
            reportTranslationOK(projectDir, projectName);

        } catch (FailParsingException e) {
            reportParsingErrors(e.getErrors());
            
        } catch (FailTypeCheckingException e) {
            reportTypeCheckingErrors(e.getErrors());
            
        } catch (FailTranslationException e) {
            reportTranslationErrors(e.getErrors());

        } catch (TranslationCancelledException e) {
            reportMessage("Translation cancelled by the user." + NEWLINE);
        }
    }

    /**
     * Performs parsing, and if there is no error, returns the syntax tree.
     * 
     * If the parsing fails, throws FailParsingException.
     */
    private Spec parse(String path) throws FailParsingException {
    	ParseException parseException = null;
    	Spec spec = null;
    	FileSource source = new FileSource (path);
    	//source.setName (path.toString().substring (""));
		try {
			//System.out.println ("Vai invocar ParseUtils.parse!");
			spec = (Spec) ParseUtils.parse(new FileSource (path), new SectionManager ("circus"));
			//System.out.println ("Parseou");
		} catch (ParseException e) {
			JOptionPane.showMessageDialog (null, e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println ("IOException");
			e.printStackTrace();

		} catch (UnmarshalException e) {
			e.printStackTrace();
			System.out.println ("UnmarshalException");
		}//CircusParser.parse(path);
        // TODO: Change this. The errors should be a simple list, as it is in the type
        // checker, and not a mapping.
    	//System.out.println ("Passou por acu�... Depois dos catch!");
    	//TODO: Mudar isso aqui!!!!!!!!!!!!!!!!!!!!!!!!
        /*Map<String, List<String>> errors = null;//CircusParser.getErrors();
        if (errors.isEmpty()) {
        	System.out.println ("errors � empty!");
            reportParsingOK();

        } else {
            // Parsing errors
        	System.out.println ("errors N�O � empty!");
            List<String> parseErrors = null;
            int i = 0;
            for (List<String> list : errors.values()) {
                parseErrors = list;
                i++;
                assert (i <= 1); // The mapping must have only one value
            }
            throw new FailParsingException (parseErrors);
        }*/
        return spec;
    }
    
    /**
     * Performs type checking on a syntax tree.
     *
     * If the type checking fails, throwns FailTypeChecking Exception.
     */
    /*M�todo abaixo implementado por Samuel, para ignorar os warnings no lan�amento da exce��o*/
    private boolean hasErrors (TypeChecker tcheck) {
    	int counterErrors = 0;
    	List </*net.sourceforge.czt.typecheck.circus.*/ErrorAnn> errorsOrWarnings = (List </*net.sourceforge.czt.typecheck.circus.*/ErrorAnn>) tcheck.errors();
    	for (int i = 0; i < errorsOrWarnings.size(); i++) {
    		if (errorsOrWarnings.get(i).getErrorType() == ErrorType.ERROR) {
    			counterErrors ++;
    		}
    	}
    	if (counterErrors > 0) {
    		System.out.println ("...|||___///...");
    		return true;
    	}
    	else return false;
    }
    /*M�todo acima implementado por Samuel, para ignorar os warnings no lan�amento da exce��o*/
    
    private void typeCheck (Spec spec) throws FailTypeCheckingException {
        @SuppressWarnings ({"unchecked", "fallthrough", "doWarn", "WarningManager"})
        SectionManager manager = new SectionManager("circus");

        net.sourceforge.czt.typecheck.circus.impl.Factory factory = new net.sourceforge.czt.typecheck.circus.impl.Factory();
        TypeChecker typeChecker = new TypeChecker (factory, manager);// = new TypeChecker(manager, Markup.LATEX);
        WarningManager wm = typeChecker.getWarningManager();
        System.out.println ("WarningManager_: " + wm + "\n");
        System.out.println (typeChecker.PROP_TYPECHECK_RAISE_WARNINGS + "\n");
        typeChecker.visitTerm(spec); //O respons�vel por disparar o tanto de warnings em T_FCSMod est� aqui!!!
		System.out.print("");
        List<ErrorAnn> typeErrors = (List<ErrorAnn>) typeChecker.errors();

		//JOptionPane.showMessageDialog (null, "Erros de typechecking :::: \n" + typeErrors);
		//System.out.println ("Erros de typechecking :::: \n" + typeErrors);

        if (!hasErrors(typeChecker)/*typeErrors.isEmpty()*/) {
            reportTypeCheckingOK();
            
        } else {
            throw new FailTypeCheckingException(typeErrors);
        }    
    }

    /**
     *
     */
    protected abstract void translate2Java (String projectDir, String projectName, Spec /*Term*/ spec, String compl, boolean useBarriers, boolean parallelism/*, int minComm, int maxComm*/) 
            throws FailTranslationException, TranslationCancelledException, JCircusException;

    /**
     *
     */
    protected abstract void reportMessage (String message);

    /**
     *
     */
    private void reportParsingOK() {
        String message = "No parsing errors!" + NEWLINE;
        reportMessage(message);
    }
    
    /**
     *
     */
    private void reportTypeCheckingOK() {
        String message = "No type checking errors!" + NEWLINE;
        reportMessage(message);
    }
        
    /**
     *
     */
    public void reportTranslationOK(String projectDir, String projectName) {
        String message = "Translation was successful! Files for project '" + projectName + 
                "' were created at " + getOutputDir(projectDir, projectName) + ".";
        reportMessage(message);
    }

    /**
     *
     */
    protected String parsingErrorMessage(List<String> errors) {

        StringBuilder message = new StringBuilder();
        
        message.append(errors.size() + " parsing error(s)!" + NEWLINE);
        for(String e : errors) {
            message.append(e.toString() + NEWLINE);
        }
        return message.toString();
    }
    
    /**
     *
     */
    protected String typeCheckingErrorMessage(List<ErrorAnn> errors) {

        StringBuilder message = new StringBuilder();
        
        message.append(errors.size() + " type error(s)!" + NEWLINE);

        for(ErrorAnn e : errors) {
            message.append(e.toString() + NEWLINE);
        }                
        return message.toString();
    }
    
    /**
     *
     */
    protected String translationErrorMessage(List<Error> errors) {
        
        StringBuilder message = new StringBuilder();

        message.append("Input file does not meet the requirements for translation." + NEWLINE);
        message.append(errors.size() + " error(s)!" + NEWLINE);

        for(Error e : errors) {
            message.append(e.toString() + NEWLINE);
        }   
        return message.toString();
    }
    
    /**
     *
     */
    protected abstract void reportParsingErrors(List<String> errors) 
            throws FailParsingException;
    
    /**
     *
     */
    protected abstract void reportTypeCheckingErrors(List<ErrorAnn> errors) 
            throws FailTypeCheckingException;
    
    /**
     *
     */
    protected abstract void reportTranslationErrors(List<Error> errors) 
            throws FailTranslationException;
    
    /**
     *
     */
    public String getOutputDir(String outputPath, String projectName) {
        return outputPath + "\\" + projectName + "\\" + Constants.DIR_SOURCE;
    }
    
}
