package jcircus.JCSPUnit;
import junit.framework.TestCase;
import jcsp.lang.*;
import fireControlSystem.processes.*;
import fireControlSystem.processes.ConcreteMain.CSP3;

import java.util.*;
import java.awt.*;
import javax.swing.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;
import java.awt.event.*;

public class TestFireControl extends JCSPTestCase {
	ConcreteMain cm;
	
	final int SECOND_STAGE = 2;
	
    final int DETECTION_0           = 0;
    final int DETECTION_1           = 1;
    final int DETECTION_2           = 2;
    final int DETECTION_3           = 3;
    final int DETECTION_4           = 4;
    final int DETECTION_5           = 5;
    final int ZONE_FAULT            = 6;
    final int EARTH_FAULT           = 7;
    final int SOUNDER_LINE_FAULT    = 8;
    final int POWER_FAULT           = 9;
    final int ISOLATE_REMOTE_SIGNAL = 10;
    final int ACTUATOR_LINE_FAULT   = 11;
    final int MANUAL_DISCHARGE_0    = 12;
    final int MANUAL_DISCHARGE_1    = 13;
    final int MANUAL_DISCHARGE_ALL  = 14;
    final int MODE_SWITCH_MANUAL    = 15;
    final int MODE_SWITCH_AUTOMATIC = 16;
    final int RESET                 = 17;
    final int SWITCH_ON             = 18;
    final int SILENCE_ALARM         = 19;
    final int ACTUATORS_REPLACED    = 20;
	
	public void setUp () 
	{	
		cm = new ConcreteMain ();
		prepareProcess (cm);
	}

	public void contentOfSynchronization() {
		
	}
	public void contentOfTest () {
		sleep (4);
		Any2OneChannel btnPressed = ((ConcreteMain)preparedProcess).extdevices.teclado.btnPressed;
		ChannelInput alarm = ((ConcreteMain)preparedProcess).extdevices.alarm;
		sleep(1);
		btnPressed.write(new Integer(SWITCH_ON));
		sleep(1);
		btnPressed.write(new Integer (MODE_SWITCH_AUTOMATIC));
		sleep(1);
		btnPressed.write(new Integer (DETECTION_1));
		sleep(1);
		btnPressed.write(new Integer (DETECTION_2));
		sleep(1);
		btnPressed.write(new Integer (DETECTION_3));
		sleep(1);
		assertWasReadOnChannel (alarm, new Integer (SECOND_STAGE));
	}
	
	/*public void contentOfTest () {
		sleep (4);
		init ();
		//requirement1 ();
		//requirement2 ();
		checkFireControlStateMachine ();
		System.exit(0);
	}*/
	public void checkPath1 () {
		JOptionPane.showMessageDialog (null, "This method tests the path from the FIRE_SYS state to " +
				"the RESET state");		
		//((ConcreteMain)preparedProcess).extdevices.teclado.jButtonSwitchOn.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS);

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_0.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.AUTO);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_2.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.AUTO);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_1.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.COUNTDOWN);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_3.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.COUNTDOWN);
		
		while (!((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.isEnabled()) {
			//espera at o boto "Actuators Replaced" ser habilitado
		}
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.RESET);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick();
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS_D);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonZoneFault.doClick();
		sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonEarthFault.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS_D);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_5.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.DISABLED);

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_4.doClick();
		sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonSounderLine.doClick();
		
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.DISABLED);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonSilenceAlarm.doClick();
		
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.RESET);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick();
		
		sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick();
		
		JOptionPane.showMessageDialog (null,"Path 1 checked");
	}
	
	public void checkPath2 () {
//Exercita as arestas modeswitch e fault do grafo, partindo de FIRE_SYS
		JOptionPane.showMessageDialog (null,"This method exercices the edges ModeSwitch and Fault of the " +
				"Fire Control state machine, starting from FIRE_SYS");
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonZoneFault.doClick();
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonEarthFault.doClick();
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonPowerFault.doClick();		
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorLineFault.doClick();		
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick();
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchManual.doClick();
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick();
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.RESET);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick();
		sleep (1);
		assertEquals ((((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue()), SystemState.FIRE_SYS);

		JOptionPane.showMessageDialog (null,"Path 2 checked");
	}

	public void checkPath3 () {
		JOptionPane.showMessageDialog (null,"This method exercises the \"manual\" mode path");

		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchManual.doClick();
		sleep(1);

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_5.doClick();
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.MANUAL);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonManualDischarge_0.doClick();
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.MANUAL);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_0.doClick();
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.MANUAL);		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonManualDischarge_0.doClick();
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.RESET);		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick();
		sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick();
		
		JOptionPane.showMessageDialog (null,"Path 3 checked");
	}
	
	public void checkPath4 () {
		JOptionPane.showMessageDialog (null,"This method exercises the edges silenceAlarm (between manual and reset states),\n" +
				" actuatorsReplaced, Detection and Fault (between reset and itself)\n" +
				"and actuatorsReplaced (between fireSysD and fireSys)");
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonSwitchOn.doClick(); //Apenas enquanto eu comentei o checkPath1 em contentOfTest
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchManual.doClick();
		sleep(1);

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_0.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.MANUAL);		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonSilenceAlarm.doClick();
		
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.RESET);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_1.doClick();
		sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonEarthFault.doClick();
		sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick();		
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.RESET);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick();
		sleep(1);
		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick();
		sleep(1);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_0.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.AUTO);

		//Abaixo, o acrscimo para a verificao da transio "reset", entre auto e firesys
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick();		
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick();
		sleep(1);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_0.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.AUTO);
		
		//Acima, o acrscimo...
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_1.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.COUNTDOWN);
		
		while (!((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.isEnabled()) {
			//Waits until the "Actuators Replaced" button is enabled. This is a possible way to wait the finish of the second stage alarm's countdown
		}
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick();

		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS_D);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick();
		sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS);
		
		JOptionPane.showMessageDialog(null,"Path 4 checked");
	}
	
	public void checkFireControlStateMachine () {
		checkPath1();
		checkPath2();
		checkPath3();
		checkPath4();
		JOptionPane.showMessageDialog (null,"The Fire Control State Machine is correct");
	}
	
	public void requirement1 () {
		JOptionPane.showMessageDialog (null,"Este requisito verifica se, " +
				"aps os botes Switch On, Automatic, Zone 0 e Zone 1 serem pressionados, " +
				"o sistema disparou o alarme de segundo estgio");

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick(); sleep(1);
		assertThereWasSynchronizationOnChannel (((ConcreteMain)preparedProcess).
				extdevices.teclado.btnPressed, new Integer (MODE_SWITCH_AUTOMATIC));

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_0.doClick(); sleep(1);
		assertThereWasSynchronizationOnChannel (((ConcreteMain)preparedProcess)
				.extdevices.teclado.btnPressed, new Integer (DETECTION_0));
		assertWasReadOnChannel (((ConcreteMain)preparedProcess).extdevices.teclado.
				systemState, new SystemState (SystemState.AUTO));		
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.AUTO);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_1.doClick(); sleep(1);
		assertThereWasSynchronizationOnChannel (((ConcreteMain)preparedProcess).
				extdevices.teclado.btnPressed, new Integer (DETECTION_1));
		assertWasReadOnChannel (((ConcreteMain)preparedProcess).
				extdevices.teclado.systemState, new SystemState (SystemState.COUNTDOWN));
		JOptionPane.showMessageDialog (null, "Requisito 1 procede");
		assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.COUNTDOWN);

		while (!((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.isEnabled()) {
			//espera at o boto "Actuators Replaced" ser habilitado
		}
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick(); sleep(1);
	}
	
	public void requirement2 () {
		JOptionPane.showMessageDialog (null,"Este requisito verifica se, " +
				"aps uma zona de uma rea pegar fogo, " +
				"o sistema disparou o alarme de primeiro estgio");

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_0.doClick(); sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.output.alarme.stage.getValue(), AlarmStage.FIRST_STAGE);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick(); sleep(1);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_1.doClick(); sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.output.alarme.stage.getValue(), AlarmStage.FIRST_STAGE);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick(); sleep(1);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_2.doClick(); sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.output.alarme.stage.getValue(), AlarmStage.FIRST_STAGE);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick(); sleep(1);
		
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_3.doClick(); sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.output.alarme.stage.getValue(), AlarmStage.FIRST_STAGE);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick(); sleep(1);

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_4.doClick(); sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.output.alarme.stage.getValue(), AlarmStage.FIRST_STAGE);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick(); sleep(1);

		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonModeSwitchAutomatic.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonDetection_5.doClick(); sleep(1);
		assertEquals (((ConcreteMain)preparedProcess).extdevices.output.alarme.stage.getValue(), AlarmStage.FIRST_STAGE);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonActuatorsReplaced.doClick(); sleep(1);
		((ConcreteMain)preparedProcess).extdevices.teclado.jButtonReset.doClick(); sleep(1);

		JOptionPane.showMessageDialog (null,"Requisito 2 procede");
	}
	
	public void init () {
		assertRunningInParallel (new CSProcess []{
		((ConcreteMain)preparedProcess).extdevices.teclado,
		((ConcreteMain)preparedProcess).ctfc});
	assertWasReadOnChannel (((ConcreteMain)preparedProcess).systemState, 
			new SystemState(SystemState.FIRE_SYS_START)); 
	//assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS_START);
	sleep(1);
	((ConcreteMain)preparedProcess).extdevices.teclado.jButtonSwitchOn.doClick(); 
	sleep(1);
	assertThereWasSynchronizationOnChannel (((ConcreteMain)preparedProcess).
			extdevices.teclado.btnPressed, new Integer (SWITCH_ON));
	assertWasReadOnChannel (((ConcreteMain)preparedProcess).
			systemState, new SystemState(SystemState.FIRE_SYS));
	assertEquals (((ConcreteMain)preparedProcess).extdevices.teclado.newState.getValue(), SystemState.FIRE_SYS);
	
	}
}
