package circusRefine.util.docgenerator;

import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.ast.AlphabetisedParallelProcessIte;
import net.sourceforge.czt.circus.ast.AssignmentPairs;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CallUsage;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.ExtChoiceProcessIdx;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.IndexedProcess;
import net.sourceforge.czt.circus.ast.IntChoiceProcessIdx;
import net.sourceforge.czt.circus.ast.InterleaveProcess;
import net.sourceforge.czt.circus.ast.InterleaveProcessIdx;
import net.sourceforge.czt.circus.ast.InterleaveProcessIte;
import net.sourceforge.czt.circus.ast.ParallelProcess;
import net.sourceforge.czt.circus.ast.ParallelProcessIte;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.ProcessIte;
import net.sourceforge.czt.circus.ast.RenameProcess;
import net.sourceforge.czt.circus.ast.SeqProcessIdx;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.util.ZString;
import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.idt.IdtAnn;
import circusRefine.core.print.ProcessPrint;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.util.Identificador;

public class ProcessPrintLatex extends ProcessPrint {

	public ProcessPrintLatex(DocGenerator printer) {
		super(printer);
	}

	public Object visitBasicProcess(BasicProcess term)
	{
		String[] result = null;
		getPercurso().append("BasicProcessLATEX\n");
		boolean isZParaList = true;

		//Isso deve-se ao fato de imprimirmos sempre a main action no final,
		//assim temos que certificar se eh realmente uma JJokerParalist que nao
		//contem Main Action;
		if (term.getParaList() instanceof JokerParaList) {
			isZParaList = false;
		}
		getPercurso().append("----->>>LOCALPARA\n");
		String[] strParas = (String[])term.getParaList().accept(paraLisPrint());

		//Caso em que nao ha a��o principal, apenas um nome de um JokerParaList
		if (!isZParaList) {
			int index =1;
			if (strParas != null ) {
				result = new String[strParas.length + 2];
				result[0] = "\\circbegin  \\\\ ";
				for (int i=0; i< strParas.length; i++) {
					result[index++] = BRANCO  + "\\t1 " + strParas[i];
				}
				result[index] = "\\circend  \\\\";
			}		  

		}
		//Caso ZParaList, contendo Main Action
		else {
			CircusAction main =  term.getMainAction();//term.getMainAction();

			//MainAction
			getPercurso().append("--->MAIN\n");

			this.addCounterRow(2);

			String[] strActMain = (String[])main.accept(actionPrint());
			String[] strMain = new String[strActMain.length + 3];
			strMain[0] = "";
			strMain[1] = BRANCO + "\\t1 " + "\\circspot" + Space + "\\\\	";
			int idx = 2;
			for(int i=0; i<strActMain.length; i++) {
				strMain[idx++] = BRANCO  + "\\t1"+ strActMain[i] + " \\\\";
			}
			strMain[idx] = "";

			int index =1;
			if (strParas != null ) {
				result = new String[strParas.length + strMain.length + 2];
				result[0] = "\\circbegin \\\\";
				for (int i=0; i< strParas.length; i++) {
					if (!strParas[i].endsWith("\\\\")) {
						result[index++] = BRANCO  + "\\t1 " + strParas[i] + "\\\\";
					}
					else {
						result[index++] = BRANCO  + "\\t1 " + strParas[i];
					}
				}
				for(int i=0; i<strMain.length; i++) {
					result[index++] = strMain[i];
				}
				result[index] = "\\circend \\\\";
			}
			else {
				result = new String[strMain.length + 2];
				result[0] = "\\circbegin \\\\";
				for(int i=0; i<strMain.length; i++) {
					if (!strParas[i].endsWith("\\\\")) {
						result[index++] = BRANCO  + "\\t1 " + strMain[i] + "\\\\";
					}
					else {
						result[index++] = BRANCO  + "\\t1 " + strMain[i];
					}
				}
				result[index] = "\\circend \\\\";
			}    
		}

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}
		return result;
	}


	public Object visitAlphabetisedParallelProcessIte(AlphabetisedParallelProcessIte term)
	{
		String[] result = null;

		getPercurso().append("AlphabetisedPArallelProcesseIte\n");
		int linhaInicial = this.getCounterRow();

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 1];
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		result[0] = "\\Parallel" + Space + strDecls + Space + "\\circspot" + Space + "\\lpar" + 
		Space + strCS + Space + "\\rpar";
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}


		return result;
	}


	public Object visitCallProcess(CallProcess term)
	{
		String[] result =null;
		getPercurso().append("CAllProcess\n");

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strExprs; 
		strExprs = ((String[])term.getCallExpr().accept(exprPrint()));
		List<Expr> actualParams = term.getZActuals();
		String actParams = "";
		int size = actualParams.size();
		int counter = 0;
		for(Expr expr : actualParams) {
			actParams = actParams + ((String[])expr.accept(exprPrint()))[0];
			if(counter < size-1) {
				actParams = actParams + ",";
			}
			counter++;
		}

		int index = 0;
		//Caso em que nao ha parametros
		if (size == 0) {
			result = new String[strExprs.length ];
			for (int i =0 ; i< strExprs.length ; i++) {
				result[index++] = strExprs[i];
			}
		}
		else {

			result = new String[strExprs.length + 1];
			result[index++] = "(" + strExprs[0];

			for (int i =1 ; i< strExprs.length ; i++) {
				result[index++] = strExprs[i];
			}
			result[index++] = ")";
			index--;
			if(term.getUsage().equals(CallUsage.Parameterised)) {
				result[index] = result[index] + "(" + actParams + ")";
			}
			else if(term.getUsage().equals(CallUsage.Indexed)) {
				result[index] = result[index] + Space + "\\circlinst" + Space 
				+ actParams + Space + "\\circrinst" + Space;
			}
		}

		int length = result.length;

		NoPrograma noProg = new NoPrograma(term);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	public Object visitExtChoiceProcessIdx(ExtChoiceProcessIdx term)
	{
		getPercurso().append("ExtChoiceProcessIdx");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";

		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}

		result = new String [1 + strPrc.length];
		result[0] = "\\Extchoice" + Space + strDecls + Space + "\\circindex";

		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}


	// Process ::= Process \ CSExpression
	//ok - verificado em 15/09/2005 �s 19:36
	public Object visitHideProcess(HideProcess term)
	{
		String[] result = null;
		
		getPercurso().append("HideProcess\n");

		int linhaInicial = this.getCounterRow();

		int index = 1;
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		String[] strCS = (String[])term.getChannelSet().accept(exprPrint());
		result = new String[strAct.length + strCS.length];

		result[0] = "(" + strAct[0];
		for(int i=1; i<strAct.length; i++) {
			result[index++] = strAct[i];
		}

		result[index] = ")" + Space  + "\\circhide" + Space + strCS[0];

		index++;
		for(int i=1; i<strCS.length; i++) {
			result[index++] = strCS[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term,isToInsertingRelAnn());
		addRelacionamento(rel);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}


		return result;
	}

//	ParamProcess ::= Declaration \odot Process
	//ok - verificado em 15/09/2005 �s 19:05
	public Object visitIndexedProcess(IndexedProcess term)
	{
		getPercurso().append("IndexedProcess\n");

		String[] result = null;
		int linhaInicial = this.getCounterRow();

		List<Decl> decsLaw = term.getZDeclList();
		String strDec = "";
		int size = decsLaw.size();
		int counter = 0;
		for(Decl vDec: decsLaw) {
			strDec = strDec + ((String[])vDec.accept(declPrint()))[0];
			if(counter < size-1) {
				strDec = strDec + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 2];
		result[0] = "(" + strDec + Space + "\\circindex" + Space;

		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		result[index] = ")";

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}

//	ParamProcess ::= Declaration @ Process
	//ok - verificado em 15/09/2005 �s 19:08
	public Object visitParamProcess(ParamProcess term)
	{
		String[] result = null;
		getPercurso().append("ParamProcess\n");
		int linhaInicial = this.getCounterRow();

		List<Decl> decsLaw = term.getZDeclList();
		String strDec = "";
		int size = decsLaw.size();
		int counter = 0;
		for(Decl vDec: decsLaw) {
			strDec = strDec + ((String[])vDec.accept(declPrint()))[0];
			if(counter < size-1) {
				strDec = strDec + ZString.SEMICOLON;
			}
			counter++;
		}

		this.addCounterRow(1);

		String[] strAct = (String[])term.getCircusProcess().accept(this);

		result = new String[strAct.length + 2];
		result[0] = "(" + strDec + " \\circspot ";

		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		result[index] = ")";

		int length = result.length;

		NoPrograma noProg = new NoPrograma(term);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}


	public Object visitIntChoiceProcessIdx(IntChoiceProcessIdx term)
	{
		getPercurso().append("InterleaveProcessIdx\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";
		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}
		result = new String [1 + strPrc.length];
		result[0] = "\\Intchoice" + Space + strDecls + Space + "\\circindex";

		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	//	 Process ::= Process |||| Process
	public Object visitInterleaveProcess(InterleaveProcess term)
	{
		getPercurso().append("InterleaveProcess\n");
		String[] result = null;

		int index = 0;
		int linhaInicial = this.getCounterRow();

		String[] strProcL = (String[])term.getLeftProcess().accept(this);
		this.addCounterRow(1);
		String[] strProcR = (String[])term.getRightProcess().accept(this);
		result = new String[strProcL.length + strProcR.length + 1];

		for(int i=0; i<strProcL.length; i++) {
			result[index++] = BRANCO + strProcL[i];
		}

		result[index] = BRANCO + "\\interleave";

		index++;
		for(int i=0; i<strProcR.length; i++) {
			result[index++] = BRANCO + strProcR[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	public Object visitInterleaveProcessIdx(InterleaveProcessIdx term)
	{
		getPercurso().append("InterleaveProcessIdx\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";
		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}
		result = new String [1 + strPrc.length];

		result[0] = "\\Interleave" + Space + strDecls + Space + "\\circindex";

		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;

	}

//	Process ::= \Interleave Declaration @ Process
	public Object visitInterleaveProcessIte(InterleaveProcessIte term)
	{
		String[] result = null;
		getPercurso().append("InterleaveProcessIte\n");
		int linhaInicial = this.getCounterRow();

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 1];

		result[0] = "\\Interleave" + Space + strDecls + Space + "\\circspot" + Space ;

		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}


		return result;
	}

//	Process ::= Process |[CSExpression]| Process
	public Object visitParallelProcess(ParallelProcess term)
	{
		getPercurso().append("ParallelProcess\n");
		int linhaInicial = this.getCounterRow();
		String[] result = null;

		int index = 0;

		String[] strProcL = (String[])term.getLeftProcess().accept(this);
		this.addCounterRow(1);
		String[] strProcR = (String[])term.getRightProcess().accept(this);
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		result = new String[strProcL.length + strProcR.length + 1];

		for(int i=0; i<strProcL.length; i++) {
			result[index++] = BRANCO + strProcL[i];
		}

		result[index++] = BRANCO + "\\lpar" + Space + strCS + Space + "\\rpar";

		for(int i=0; i<strProcR.length; i++) {
			result[index++] = BRANCO + strProcR[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);


		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}

//	Process ::= |[CSExpression]| Declaration @ Process
	public Object visitParallelProcessIte(ParallelProcessIte term)
	{
		String[] result = null;

		getPercurso().append("ParallelProcess\n");

		int linhaInicial = this.getCounterRow();
		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		result = new String[strAct.length + 1];

		result[0] = "\\lpar" + Space + strCS + Space + "\\rpar" + Space 
		+ strDecls + Space + "\\circspot" + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	public Object visitProcess2(Process2 term)
	{
		getPercurso().append("Process2\n");
		String[] result = null;

		int index = 0;
		int linhaInicial = this.getCounterRow();

		String[] strProcL = (String[])term.getLeftProcess().accept(this);

		this.addCounterRow(1); 
		//Como o "\\extchoice" encontra-se ao meio dos outros termos o incremento
		// o incremento so podera ser realizado apos o visit da primeira parte

		String[] strProcR = (String[])term.getRightProcess().accept(this);
		result = new String[strProcL.length + strProcR.length + 1];

		for(int i=0; i<strProcL.length; i++) {
			result[index++] = BRANCO + strProcL[i];
		}

		result[index] = BRANCO + ((String[])term.accept(processPrint2()))[0];

		index++;
		for(int i=0; i<strProcR.length; i++) {
			result[index++] = BRANCO + strProcR[i];
		}


		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;

	}


	public Object visitProcessIte(ProcessIte term)
	{
		String[] result = null;

		getPercurso().append("Processite\n");

		int linhaInicial = this.getCounterRow();
		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}
		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		String symbol = ((String[])term.getCircusProcess().accept(processItePrint()))[0];
		result = new String[strAct.length + 1];

		result[0] = symbol + Space + strDecls + Space + "@" + Space;

		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}

//	Process ::= Process[N+ := N+]
	public Object visitRenameProcess(RenameProcess term)
	{
		String[] result = null;

		getPercurso().append("RenameProcess\n");
		int linhaInicial = this.getCounterRow();
		int index = 1;
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 1];

		result[0] = "(" + strAct[0];
		for(int i=1; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		index--;
		result[index] = result[index] + ")";

		AssignmentPairs assignPairs = term.getAssignmentPairs();
		ZNameList namesLeft = assignPairs.getZLHS();
		ZExprList exprsRight = assignPairs.getZRHS();
		String str = "";
		int size = namesLeft.size();
		int counter = 0;
		for(Name name : namesLeft) {
			str = str + ((String[])name.accept(namePrint()))[0];

			if(counter < size-1) {
				str = str + Space + "," + Space;
			}
			counter++;
		}

		String strNew = "";
		size = exprsRight.size();
		counter = 0;
		for(Expr expr : exprsRight) {
			strNew = strNew + ((String[])expr.accept(exprPrint()))[0]; 
			if(counter < size-1) {
				strNew = strNew +  Space + "," + Space;
			}
			counter++;
		}

		index++;
		result[index] = "\\lcircrename" + Space + str + Space + ":=" + Space 
		+ strNew + Space + "\\rcircrename";


		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		addRelacionamento(rel);
		
		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}

		return result;
	}
	
	public Object visitSeqProcessIdx(SeqProcessIdx term)
	{
		getPercurso().append("SeqProcessIdx\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);
		
		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";
		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}
		result = new String [1 + strPrc.length];
		result[0] = "\\Semi" + Space + strDecls + Space + "\\circindex";
		
		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}
		
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);
		
		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			this.inserirComentario (result , identificadorComentario);
		}
		
		return result;
	}

}
