package circusRefine.util.docgenerator;

import java.util.LinkedList;
import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.z.ast.AndExpr;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.IffExpr;
import net.sourceforge.czt.z.ast.ImpliesExpr;
import net.sourceforge.czt.z.ast.OrExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchExpr2;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.util.ZString;
import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.idt.IdtAnn;
import circusRefine.core.print.ExprPrint;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.util.Identificador;

public class ExprPrintLatex extends ExprPrint{

	public ExprPrintLatex(DocGenerator printer) {
		super(printer);
	}
	
	/**
	 * Quebra de Declaraes
	 */
	public Object visitSchText(SchText term)
    {
		getPercurso().append("schTExt do Exper\n");
    	String[] result = null;

    	ZSchText schText = (ZSchText)term;

    	List<Decl> decls = schText.getZDeclList();
    	int size = decls.size();
    	int counter = 0;
    	String[] strDecl = null;
    	
    	String[] strPred = null;
    	
    	if (schText.getPred() != null) {
    		strPred = (String[])schText.getPred().accept(predPrint());
    		}
    	
    	if(isSchema()) {
    		strDecl = new String[decls.size()];
    		for(Decl decl : decls) {
    			String[] newDecl = (String[])decl.accept(declPrint());
    			strDecl[counter++] = newDecl[0];
    		}
    		if (strPred != null) {
    			result = new String[strDecl.length + strPred.length + 1];}
    		else{
    			result = new String[strDecl.length];
    		}
    		int index = 0;
    		for(int i=0; i<strDecl.length; i++) {
    			result[index++] = BRANCO + strDecl[i];
    		}
    		if (strPred != null) {
    			result[index++] = "\\where";
    			for(int i=0; i<strPred.length; i++) {
    				result[index++] = strPred[i];
    			}
    		}
    	}
    	else {
    		LinkedList<String> lista = new LinkedList<String>();
    		
    		for(Decl decl : decls) {
    			String[] newDecl = (String[])decl.accept(declPrint());
    			lista.add(newDecl[0] + ";   \\\\");
    			
    		}
    		strDecl = new String[lista.size()];
    		for (int i=0;i<lista.size();i++) {
    			strDecl[i] = lista.get(i);
    		}
    		
    		if (strPred != null) {
    			if (strDecl.length != 0) {
    				result = new String[strPred.length + strDecl.length];
    				result[0] = "[" + strDecl[0];
    				int index = 1;
    				for (int i=1;i<strDecl.length;i++) {
    					result[index++] = strDecl[i];
    				}
    				result[index++] = "| " + strPred[0];
    				for (int i=1;i<strPred.length;i++) {
    					if (!strPred[i].endsWith("\\\\")){
    						result[index++] = strPred[i] + " \\\\";
    					}
    					else{
    						result[index++] = strPred[i];
    					}
    				}
    				index--;
    				int aux = result[index].length();
    				String str = result[index];
    				if (result[index].endsWith("\\\\")) {
    					str = result[index].substring(0, aux-2);
    				}
    				result[index] = str + " ]  \\\\";
    			}
    			else {
    				result = new String[strPred.length + strDecl.length + 1 ];
    				result[0] = "[ ";
    				int index =1;
    				result[index++] = "| " + strPred[0];
    				//Possivelmente ele nem entra no lao j que a
    				//maioria das vezes que nao h declaracao, o
    				//predicado  somente \true
    				for (int i=1;i<strPred.length;i++) {
    					if (!strPred[i].endsWith("\\\\")){
    						result[index++] = strPred[i] + " \\\\";
    					}
    					else{
    						result[index++] = strPred[i];
    					}
    				}
    				index--;
    				result[index] = result[index] + " ]  \\\\";
    				
    			}
    		}
    		else {
    			result = strDecl;
    			result[0] = "[ " + result[0];
    			String str = result[result.length-1];
    			int aux = str.length();
    			str = str.substring(0,aux-2);
    			result[result.length-1] = str+ "]";
    		}
    	}
    	
    	return result;
    }
	
	
	public Object visitSchExpr(SchExpr schExpr)
	{	
		getPercurso().append("SchExpr\n");
		int linhaInicial = this.getCounterRow();
		String[] result = ((String[])schExpr.getSchText().accept(this));
		NoPrograma noProg = new NoPrograma(schExpr);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, schExpr, isToInsertingRelAnn());
		addRelacionamento(rel);
		
		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(schExpr, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		return result;	
	}
	
	/**
	 * AndExpr, OrExpr, IffExpr, and ImpliesExpr objects are visited as
	 * an instance of their superclass SchExpr2. Other SchExpr2 subclass
	 * instances have their own visit method, although ProjExprs use
	 * this visit method as well.
	 */
	public Object visitSchExpr2(SchExpr2 schExpr2)
	{
		getPercurso().append("SchExpr2\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		String str = "";
		String[] strL = (String[])schExpr2.getLeftExpr().accept(this);
		this.addCounterRow(1);
		String[] strR = (String[])schExpr2.getRightExpr().accept(this);
		result = new String[strL.length + strR.length + 1];

		int index = 0;
		for(int i=0; i< strL.length; i++) {
			result[index++] = BRANCO +  strL[i];
		}
		//LATEX
		if (!getUnicoded()) {
			if(schExpr2 instanceof IffExpr) {
				str ="\\iff";
			}
			else if(schExpr2 instanceof ImpliesExpr) {
				str = "\\implies";
			}
			else if(schExpr2 instanceof OrExpr) {
				str = "\\lor";
			}
			else if(schExpr2 instanceof AndExpr) {
				str = "\\land";
			}
		}
		//UNICODE
		else {
			if(schExpr2 instanceof IffExpr) {
				str =  ZString.IFF ;
			}
			else if(schExpr2 instanceof ImpliesExpr) {
				str =  ZString.IMP;
			}
			else if(schExpr2 instanceof OrExpr) {
				str = ZString.OR;
			}
			else if(schExpr2 instanceof AndExpr) {
				str = ZString.AND;
			}
		}

		result[index++] = str ;
		for(int i=0; i<strR.length; i++) {
			result[index++] = BRANCO + strR[i];
		}

		NoPrograma noProg = new NoPrograma(schExpr2);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, schExpr2, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);
		
		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(schExpr2, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		

		return result;
	}
	
	
}
