
package circusRefine.util.docgenerator;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.Spec;
import circusRefine.core.Pair;
import circusRefine.core.Relacionamento;
import circusRefine.core.print.Action2Print;
import circusRefine.core.print.ActionPrint;
import circusRefine.core.print.CommandPrint;
import circusRefine.core.print.CommunPrint;
import circusRefine.core.print.DeclPrint;
import circusRefine.core.print.ExprListPrint;
import circusRefine.core.print.ExprPrint;
import circusRefine.core.print.NamePrint;
import circusRefine.core.print.ParActionPrint;
import circusRefine.core.print.ParProcessPrint;
import circusRefine.core.print.ParaListPrint;
import circusRefine.core.print.ParaPrint;
import circusRefine.core.print.PredPrint;
import circusRefine.core.print.Print;
import circusRefine.core.print.Printer;
import circusRefine.core.print.Process2Print;
import circusRefine.core.print.ProcessPrint;
import circusRefine.core.print.ProgramPrint;
import circusRefine.core.util.Text;

/**
 * Vai conter todos os Print correspondentes do antigo pacote, alterando 
 * apenas alguns que terao como sufixos PrintLatex_ .
 * Importante : Devera ser passado uma copia para Esse Printer, pois caso 
 * seja passado a arvore original, seus relacionamentos sero alterados o que
 * nao  nada bom.
 * @author alessandro87
 *
 */
public class DocGenerator extends Printer {

	/* Visitor que nao serao alterados :
	 * ExprPrint
	 * ExprListPrint
	 * NamePrint
	 * ExprPrint
	 * Action2Print
	 * CommandPrint
	 * CommumPrint
	 * ExprList
	 * Process2
	 */
	
	
	 /*
     * Enumeration que guarda os tipos de impressao
     */
    
	
	/** Creates a new instance of Printer */
    public DocGenerator(Text mark) {
      this.actionPrint_ = new ActionPrintLatex(this);
      this.parActionPrint_ = new ParActionPrint(this);
      this.communPrint_ = new CommunPrint(this);
      this.commandPrint_ = new CommandPrint(this);
      this.predPrint_ = new PredPrintLatex(this);
      this.declPrint_ = new DeclPrintLatex(this);
      this.processPrint_ = new ProcessPrintLatex(this);
      this.parProcessPrint_ = new ParProcessPrint(this);
      this.paraPrint_ = new ParaPrintLatex(this);
      this.paraListPrint_	= new ParaListPrint(this);
      this.programPrint_ = new ProgramPrintLatex(this);
      this.exprPrint_ = new ExprPrintLatex(this);
      this.tipo = mark;
      this.markUp = Markup.LATEX;
      this.percurso = new StringBuilder();
      
      this.inserirRelsAnn = false;
    }

    public DocGenerator() {

    	this.actionPrint_ = new ActionPrintLatex(this);
    	this.parActionPrint_ = new ParActionPrint(this);
    	this.communPrint_ = new CommunPrint(this);
    	this.commandPrint_ = new CommandPrint(this);
    	this.predPrint_ = new PredPrintLatex(this);
    	this.declPrint_ = new DeclPrintLatex(this);
    	this.processPrint_ = new ProcessPrintLatex(this);
    	this.parProcessPrint_ = new ParProcessPrint(this);
    	this.paraPrint_ = new ParaPrint(this);
    	this.paraListPrint_	= new ParaListPrint(this);
    	this.programPrint_ = new ProgramPrint(this);
    	this.exprPrint_ = new ExprPrintLatex(this);
    	this.markUp = Markup.LATEX;
    	this.tipo = Text.DESENVOLVIMENTO;
    	this.percurso = new StringBuilder();
    }
    
}
