/*
 * Projeto: Circus Refine
 */
package circusRefine.util;

/**
 * Classe para os pra 
 * 
 * @author Cristiano Castro
 *
 * @param <A> o tipo do primeiro elemento do par
 * @param <B> o tipo do segundo elemento do par
 */
public class Pair<A, B> {
	
	/** Primeiro membro do par */
	private A first;
	
	/** Segundo membro do par */
	private B second;

	/**
	 * Inicia um par vazio
	 */
	public Pair() {
		this(null, null);
	}

	/**
	 * Inicia um par indicando seus elementos
	 * 
	 * @param first o primeiro elemento
	 * @param second o segundo elemento
	 */
	public Pair(A first, B second) {
		this.setFirst(first);
		this.setSecond(second);
	}

	/**
	 * @return the first
	 */
	public A getFirst() {
		return first;
	}

	/**
	 * @param first the first to set
	 */
	public void setFirst(A first) {
		this.first = first;
	}

	/**
	 * @return the second
	 */
	public B getSecond() {
		return second;
	}

	/**
	 * @param second the second to set
	 */
	public void setSecond(B second) {
		this.second = second;
	}
	
	/**
	 * Retorna uma String representando o par
	 * 
	 * @param uma string da forma ( X , Y ) representando o par
	 */
	public String toString() {
		return "( " + this.getFirst() + " , " + this.getSecond() + " )";
	}

}