/*
 * Cristiano Gurgel
 * 
 * Projeto: Circus Refine
 */
package circusRefine.storage;

import java.util.Stack;

/**
 * Armazena o status da tela principal do circus Refine
 * 
 * @author Cristiano Gurgel
 * @version 1.1 06/01/07
 */
public class StatusPrincipal {

    /** pilha das ultimas acoes */
    private Stack<Integer> lastAction;
    /** pilha das ultimas acoes desfeitas */
    private Stack<Integer> redoLastAction;
    /** pilha de strings com as ultimas acoes coletadas */
    private Stack<String> undoAcoesColetadas;
    /** pilha de strings com as ultimas coletas de acoes desfeitas */
    private Stack<String> redoAcoesColetadas;

    /**
     * Inicializa o status da tela principal com todos os valores
     * setados em <code>null</code>
     */
    public StatusPrincipal() {
        this(null, null, null, null);
    }

    /**
     * Inicializa o status da tela principal com todos os valores
     * definidos
     *
     * @param novoLastAction nova pilha das ultimas acoes
     * @param novoRedoLastAction nova pilha das ultimas acoes
     * 			desfeitas
     * @param novoUndoAcoesColetadas nova pilha de strings com as
     * 			ultimas acoes coletadas
     * @param novoRedoAcoesColetadas nova pilha de strings com as
     * 			ultimas acoes coletadas desfeitas
     */
    public StatusPrincipal(Stack<Integer> novoLastAction,
            Stack<Integer> novoRedoLastAction,
            Stack<String> novoUndoAcoesColetadas,
            Stack<String> novoRedoAcoesColetadas) {
        this.setLastAction(novoLastAction);
        this.setRedoLastAction(novoRedoLastAction);
        this.setUndoAcoesColetadas(novoUndoAcoesColetadas);
        this.setRedoAcoesColetadas(novoRedoAcoesColetadas);
    }

    /**
     * Acessa a pilha com as ultimas acoes do programa
     *
     * @return a pilha de ultimas acoes do programa
     */
    public Stack<Integer> getLastAction() {
        return lastAction;
    }

    /**
     * Seta a pilha com as ultimas acoes do programa
     *
     * @param lastAction a nova pilha vcom as ultimas acoes do
     * 			 programa
     */
    public void setLastAction(Stack<Integer> lastAction) {
        this.lastAction = lastAction;
    }

    /**
     * Acessa a pilha com os nomes das ultimas acoes coletadas que
     * foram desfeitas
     *
     * @return a pilha com os nomes das acoes
     */
    public Stack<String> getRedoAcoesColetadas() {
        return redoAcoesColetadas;
    }

    /**
     * Seta a pilha com os nomes das ultimas acoes coletadas que
     * foram desfeitas
     *
     * @param redoAcoesColetadas a nova pilha com as ultimas acoes
     * 	coletadas que foram desfeitas
     */
    public void setRedoAcoesColetadas(Stack<String> redoAcoesColetadas) {
        this.redoAcoesColetadas = redoAcoesColetadas;
    }

    /**
     * Acessa a pilha com as ultimas acoes desfeitas do programa
     *
     * @return a pilha com as ultimas acoes desfeitas do programa
     */
    public Stack<Integer> getRedoLastAction() {
        return redoLastAction;
    }

    /**
     * Seta a pilha com as ultimas acoes desfeitas do programa
     *
     * @param redoAcoesColetadas a nova pilha com as acoes desfeitas
     * 			do programa
     */
    public void setRedoLastAction(Stack<Integer> redoLastAction) {
        this.redoLastAction = redoLastAction;
    }

    /**
     * Acessa a pilha com as strings dos nomes das ultimas acoes
     * coletadas
     *
     * @return a pilha com os nomes das acoes
     */
    public Stack<String> getUndoAcoesColetadas() {
        return undoAcoesColetadas;
    }

    /**
     * Seta a pilha com os nomes (<code>String</code>s) das ultimas
     * acoes coletadas
     *
     * @param undoAcoesColetadas a nova pilha com os nomes das
     * 	ultimas acoes coletadas
     */
    public void setUndoAcoesColetadas(Stack<String> undoAcoesColetadas) {
        this.undoAcoesColetadas = undoAcoesColetadas;
    }
}
