/*
 * Cristiano Gurgel
 * 
 * Projeto: Circus Refine
 */
package circusRefine.storage;

import java.util.List;
import java.util.Stack;
import circusRefine.core.Relacionamento;
import circusRefine.core.RespostaLei;

/**
 * Armazena o status do gerenciador externo.
 * Utilizado no salvamento do programa
 * 
 * @author Cristiano Gurgel
 * @version 1.1 22/12/06
 */
public class StatusExterno {

	/** A lista com os relacionamentos */
	private List<Relacionamento> relacionamentos;
	
	/** A pilha com as respostas Leis utilizadas no programa */
	private Stack<RespostaLei> respostaLeisUtilizadas;
	
	/** A pilha com as respostas das leis desfeitas */
	private Stack<RespostaLei> respostaLeisDesfeitas;
	
	/**
	 * Inicializa o status do gerenciador externo com todos os
	 * atributos em <code>null</code>.
	 */
	public StatusExterno() {
		this(null, null, null);
	}
	
	/**
	 * Inicia o status do gerenciador externo com todos os atributos
	 * definidos
	 * 
	 * @param rel a lista de relacionamentos
	 * @param respUtilizadas as respostas leis utilizadas
	 * @param respDesfeitas as respostas das leis desfeitas
	 */
	public StatusExterno(List<Relacionamento> rel, 
						 Stack<RespostaLei> respUtilizadas, 
						 Stack<RespostaLei> respDesfeitas) {
		this.setRelacionamentos(rel);
		this.setRespostaLeisUtilizadas(respUtilizadas);
		this.setRespostaLeisDesfeitas(respDesfeitas);
	}
	
	/**
	 * Acessa a lista de relacionamentos
	 * 
	 * @return a lista com os relacionamentos da tela de
	 *  desenvolvimento com os programas
	 */
	public List<Relacionamento> getRelacionamentos() {
		return relacionamentos;
	}
	
	/**
	 * Seta a lista de relacionamentos
	 * 
	 * @param relacionamentos a nova lista de relaciomentos
	 */
	public void setRelacionamentos(List<Relacionamento> relacionamentos) {
		this.relacionamentos = relacionamentos;
	}
	
	/**
	 * Acessa a resposta das leis utilizadas no refinamento
	 * 
	 * @return a pilha das resposta das leis utilizadas no 
	 * 	refinamento
	 */
	public Stack<RespostaLei> getRespostaLeisUtilizadas() {
		return respostaLeisUtilizadas;
	}
	
	/**
	 * Seta as respostas das leis utilizadas no refinamento
	 * 
	 * @param respostaLeisUtilizadas a nova pilha com as respostas 
	 * 	das leis utilizadas no refinamento
	 */
	public void setRespostaLeisUtilizadas(
			Stack<RespostaLei> respostaLeisUtilizadas) {
		this.respostaLeisUtilizadas = respostaLeisUtilizadas;
	}
	
	/**
	 * Acessa as respostas das leis desfeitas no refinamento
	 * 
	 * @return a pilha com as respostas das leis desfeitas no 
	 * 	refinamento
	 */
	public Stack<RespostaLei> getRespostaLeisDesfeitas() {
		return respostaLeisDesfeitas;
	}
 	
	/**
	 * Seta o atributo das respostas leis desfeitas no refinamento
	 * 
	 * @param respostaLeisDesfeitas a nova pilha com as respostas 
	 * 	leis desfeitas no refinamento
	 */
	public void setRespostaLeisDesfeitas(
			Stack<RespostaLei> respostaLeisDesfeitas) {
		this.respostaLeisDesfeitas = respostaLeisDesfeitas;
	}
	
}
