package circusRefine.gui;

/**
 * Janela do tela Sobre
 */
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;


import circusRefine.core.ExternalManager;

public class TelaSobre extends JFrame {

    JLabel image;
    JButton oK;
    private String path = "images/";
    ExternalManager gerInterface;

    public TelaSobre(ExternalManager gerExterno) {
        gerInterface = gerExterno;
        jbInit();
    }

    /**
     * Metodo que inicializa os componentes de Interface
     */
    private void jbInit() {
        this.setTitle(this.retornarMensagen("COD0589"));
        this.setSize((this.gerInterface.getTamanhoHorizontal() * 32) / 100, (this.gerInterface.getTamanhoVertical() * 65) / 100);
        this.setLocation(this.gerInterface.retornarTelaCodigo().getX() - 150,
                this.gerInterface.retornarTelaCodigo().getY() + 30);
        this.setResizable(false);
        this.setLayout(null);

        ImageIcon crefine = new ImageIcon(path + "CRefineSobre.gif");
        Image a = crefine.getImage();
        Image b = a.getScaledInstance(this.getWidth(), (this.getHeight() * 85) / 100, Image.SCALE_DEFAULT);

        image = new JLabel(new ImageIcon(b));
        image.setBorder(BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        image.setLocation(0, 0);
        image.setSize(this.getWidth(), (this.getHeight() * 85) / 100);

        oK = new JButton("OK");
        oK.setSize(60, 20);
        oK.setLocation(this.getWidth() - 75, image.getHeight() + 15);
        oK.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                ok_Action(e);
            }
        });

        add(image);
        add(oK);
    }

    protected void ok_Action(ActionEvent e) {
        this.setVisible(false);
    }

    /**
     * Obter strings internacionalizadas a partir do codigo
     * @param str
     * @return
     */
    private String retornarMensagen(String str) {
        return this.gerInterface.getMessage(str);
    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        ExternalManager ext = new ExternalManager("pt", "BR");
        TelaSobre aju = new TelaSobre(ext);
        aju.setVisible(true);
    }
}
