package circusRefine.gui;

/*
* Projeto : Refine - Ferramenta Educacional para Refinamentos
*
* Tipo : TelaCodigo
*
*/

import circusRefine.core.ExternalManager;
import circusRefine.core.print.Printer;
//import circusRefine.core.printUni.PrinterUni;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.SystemColor;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import jcircus.JCircusControllerFrame;
import jcircus.gui.JCircusFrame;



import net.sourceforge.czt.base.ast.Term;


/**
* TelaCodigo � um tipo que representa a tela do c�digo gerado.
*/
public class TelaCodigo extends JInternalFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private ExternalManager gerInterface;
	public static final int Unicode = 1;
	public static final int Latex = 2;
	JTextArea TACodigo = new JTextArea();
	JScrollPane rolagem;

	JCircusControllerCodigo controllerCodigo = new JCircusControllerCodigo ();
	JPopupMenu menuTraducao = new JPopupMenu (); //By Samuel Barrocas
	JMenu jcircus = new JMenu ("JCircus"); //By Samuel Barrocas
	JMenuItem translate = new JMenuItem ("Translate 2 Java"); //By Samuel Barrocas
	private String filePath = "";//By Samuel Barrocas
	public void setFilePath (String p) { //By Samuel Barrocas
		this.filePath = p;
	}
	public String getFilePath () { //By Samuel Barrocas
		return this.filePath;
	}
	
   /**
	* Construtor da classe TelaCodigo.
	*
	* @param gerInterface       Gerenciador de todas as telas do sistema.
	*
	*/
	public TelaCodigo(ExternalManager gerInterface) {
		
		super (gerInterface.getMessage("COD0083"),true,false,true,true);
		
		//resizeble
  		//maximizable
  		//iconifiable
		
		try  {
			this.gerInterface = gerInterface;
			jbInit();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

   /**
	* M�todo que retorna uma String representando todo o conte�do da tela de
	* c�digo.
	*
	* @return        Uma String representando todo o conte�do da tela de
	*                c�digo.
	*
	*/
	public String getTextoCodigo() {
		String textoCodigo = TACodigo.getText();
		return textoCodigo;
	}
	public static String pathFromJFileChooser (JFileChooser jfc) {
		String path = "";
		jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		if(jfc.showOpenDialog(jfc) == JFileChooser.APPROVE_OPTION){   
            path = jfc.getSelectedFile().getPath();   
        }
		return path;
	}

	/**
	  * Atualiza os campos de InfoTelas referentes a janela de Codigo
	  */
	public void atualizarInfoTela () {
		this.gerInterface.getInfoTelas().AtualizarCod(this);
	}
	
   /**
	* Inicializa os atributos da tela de c�digo.
	*
	*/
  	private void jbInit() throws Exception {
		this.setBackground(SystemColor.scrollbar);

		this.setLocation(   ( (gerInterface.getTamanhoHorizontal()*545)/800 ) ,  ( (gerInterface.getTamanhoVertical()*6)/600));
		this.setSize(( (gerInterface.getTamanhoHorizontal()*240) /800) , ( (gerInterface.getTamanhoVertical()*477)/600) );

		this.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener () {
			public void ancestorMoved(java.awt.event.HierarchyEvent e) {
			}
			public void ancestorResized(java.awt.event.HierarchyEvent e) {
				atualizarInfoTela();
			}
		}
		);

		translate.addActionListener(
			new ActionListener () {
				public void actionPerformed (ActionEvent e) {
					/*JFrame frame = new JFrame ("Input values: ");
					frame.setLayout(new FlowLayout ());
					//JTextField field = new JTextField (20);
					frame.getContentPane().add(new JLabel ("Enter integer bounds: "));
					JTextField field1 = new JTextField (3);
					JTextField field2 = new JTextField (3);
					frame.getContentPane().add(new JTextField (3));
					frame.getContentPane().add(new JTextField (3));
					frame.setSize(300, 80);
					//frame.setCursor(cursorType)
					frame.setVisible(true);*/

					//String x = JOptionPane.showInputDialog ("Enter maximum value to be communicated: ");
					//String path = JOptionPane.showInputDialog ("Enter path for the output: ");
					String path = "";
					JFileChooser chooser = new JFileChooser ();
					path = pathFromJFileChooser (chooser);
					//int max = Integer.parseInt(x);
					//JCircusFrame jcircusframe = new JCircusFrame(JCircusControllerFrame.this);
					//JCircusControllerFrame controller = new JCircusControllerFrame ();

					try {
						controllerCodigo.translate(getFilePath(), path, "paper", getNameFromPath (path), true, true/*, 0, max*/);
					} catch (Exception e1) {
						// TODO Auto-generated catch block
						System.out.println (e1);
					}
				}
			}
		);

		jcircus.add(translate);
		menuTraducao.add(jcircus);

		TACodigo.addMouseListener (
			new MouseListener () {
				public void mouseClicked(MouseEvent arg0) {
					//System.out.println ("Mouse Clicked");
					if (arg0.getButton() == arg0.BUTTON1) {
						//System.out.println ("Esquerdo");
					}
					else if (arg0.getButton() == arg0.BUTTON3) { //Botão direito do mouse
						menuTraducao.show(arg0.getComponent(), arg0.getX(), arg0.getY());
					}
				}
				public void mouseEntered(MouseEvent arg0) {
					//System.out.println ("Mouse Entered");
				}
				public void mouseExited(MouseEvent arg0) {
					//System.out.println ("Mouse Exited");
				}
				public void mousePressed(MouseEvent arg0) {
					System.out.println ("Mouse Pressed");
				}
				public void mouseReleased(MouseEvent arg0) {
					System.out.println ("Mouse Released");
				}
			}
		);

		this.add(menuTraducao);
		//this.setTitle(this.retornarMensagem("COD0083"));
	    this.setLayout(new BorderLayout());
		TACodigo.setBackground(Color.white);
		TACodigo.setBounds(-3, 0, 334, 218);
		TACodigo.setFont(new Font("CZT", 4, 12));
		TACodigo.setEditable(false);
		rolagem = new JScrollPane(TACodigo);
		this.add(rolagem, BorderLayout.CENTER);
  	} 
  	
  	public String getNameFromPath (String path) {
  		String str = "";
  		int b2 = path.length() - 1;
  		int aux = b2;
  		for (int i = b2; i >= 0; i--) {
  			if (path.charAt(i) == '\\') {
  				aux = i;
  			}
  		}
  		return path.substring (aux + 1, b2);
  	}
  	
   /**
	* Limpa o conte�do de texto que est� na tela de c�digo.
	*
	*/
	public void limparTexto() {
		TACodigo.setText("");
	}
   /**
	* M�todo que funciona como uma esp�cie de reset da tela de c�digo.
	* Respons�vel por inicializar a maioria dos atributos desta tela.
	*
	* @param gerInterface       Gerenciador de todas as telas do sistema.
	*
	*/
	public void novaTela(ExternalManager gerInterface) {
		TACodigo.setText("");
		this.gerInterface = gerInterface;
	}

  /**
	* M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
	* de t�tulo quanto na forma de mensagem de erro.
	*
	* @param codigo     O c�digo da mensagem que ser� retornada.
	*
	* @return           Uma String que representa a mensagem de retorno.
	*
	*/
	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem;
	}
   /**
	* M�todo que limpa o texto anterior da tela e coloca o novo texto.
	*
	* @param programa               Programa � ser colocado na tela de c�digo.
	*
	*/
	public void setarTela(Term programa) {
		this.limparTexto();
		this.setarTelaTexto(programa);
	}
   /**
	* M�todo que pega uma String obtida a partir de um programa e seta na
	* tela no formato padr�o de c�lculo de programas.
	*
	* @param programa               Programa a ser colocado na tela.
	*
	*/
	private void setarTelaTexto(Term programa) {
		
		Printer printer = null;
		
		printer = new Printer(gerInterface.getMark(),false);

		String[] strProg = (String[])printer.visitTerm(programa);
		
		String strShow = "";
		int tamTexto = strProg.length;

		for(int i=0; i<tamTexto; i++) {
			strShow = strShow + strProg[i] + "\n";
		}

		TACodigo.setText(strShow);
	}
}
