package circusRefine.gui;


import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import net.sourceforge.czt.parser.util.ParseException;

import circusRefine.core.ExternalManager;
import circusRefine.core.crules.CRulesException;
import circusRefine.util.CRefineException;
import circusRefine.util.SchemaUtils;

/**
 * Classe de interface que exibi os erros revelados
 * @author Alessandro Gurgel
 *
 */
public class ErrorDialog extends JDialog {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String errorMessage = "";
	private String path;
	private String errorStackTrace = "";
	private String titleCod;
	private boolean withStackDetails = false;
	private JFrame traceFrame;

	ExternalManager gerInterface;

	JLabel arquivo;
	JLabel erros;

	JTextField  campoArquivo;
	JTextArea campoErros;
	JScrollPane errorField;

	JButton ok;
	JButton details;

	JLabel stackTrace;
	JTextArea detailsField;

	
	
	public ErrorDialog(ExternalManager gerExt,  Exception e) {
		super(gerExt.retornarTelaPrincipal());

		path = "";
		gerInterface = gerExt;
		errorMessage = e.getMessage();
		errorStackTrace = e.getLocalizedMessage();
		titleCod = "ErrOr";
		jbInit();
	}
	
	public ErrorDialog(ExternalManager gerExt, String arquivo, CRefineException e) {
		super(gerExt.retornarTelaPrincipal());

		path = arquivo;
		gerInterface = gerExt;
		errorMessage = getErrorMessage(e);
		errorStackTrace = getStackErrorMessage(e);
		titleCod = getTitle(e);
		jbInit();
	}

	public ErrorDialog(ExternalManager gerExt, String arquivo, CRulesException e) {
		super(gerExt.retornarTelaPrincipal());

		path = arquivo;
		gerInterface = gerExt;
		errorMessage = getErrorMessage(e);
		errorStackTrace = getStackErrorMessage(e);
		titleCod = getTitle(e);
		jbInit();
	}


	private String getTitle(CRulesException e) {
		return "CRules Error";
	}

	private String getErrorMessage(CRulesException e) {
		String result = "";
		result = e.getMessage();
		return result;
	}

	private String getTitle(CRefineException e) {
		if (e.getTitleCode() != null){
			return gerInterface.getMessage(e.getTitleCode());
		}
		return "Error";
	}

	private String getErrorMessage(CRefineException e) {
		String result = "";
		if (!(e.getCause() instanceof CRefineException)){
			result = e.getMessage();
		}
		else{
			result = gerInterface.getMessage(e.getCodeOfMessageToTheUser());
		}

		return result;
	}

	private String getStackErrorMessage(Exception e) {
		String strStackTrace = "";
		StackTraceElement[] errorsTrace = e.getStackTrace();
		for (int i = 0; i< errorsTrace.length; i++) {
			strStackTrace += errorsTrace[i].toString() + "\n";
		}
		return strStackTrace;
	}

	/**
	 * Mtodo que inicializa os diversos compenentes do Frame
	 */
	private void jbInit() {

		int tam = getMaxTam();
		if (tam > (0.7)*(gerInterface.getTamanhoHorizontal())) {
			tam = (7*(gerInterface.getTamanhoHorizontal()))/10;
		}

		tam = Math.max(tam, 3*(gerInterface.getTamanhoHorizontal())/10);
		this.setSize(tam + 30,  400);
		this.setTitle(titleCod);
		this.setLocation((this.gerInterface.getTamanhoHorizontal()*(5))/100, (this.gerInterface.getTamanhoVertical()*10)/100);
		
		this.setResizable(false);
		this.setLayout(null);

		arquivo = new JLabel(this.gerInterface.getMessage("COD0511"));
		arquivo.setSize(90, 20);
		arquivo.setLocation(10, 10);

		campoArquivo = new JTextField(this.path);
		campoArquivo.setEditable(false);
		campoArquivo.setSize(tam + 5, 25);
		campoArquivo.setLocation(10,35);
		campoArquivo.setBackground(SystemColor.WHITE);

		erros = new JLabel(this.gerInterface.getMessage("COD0517"));
		erros.setSize(130,20);
		erros.setLocation(10, 60);

		campoErros = new JTextArea(this.exibirErrors());
		campoErros.setEditable(false);
		campoErros.setBackground(SystemColor.WHITE);
		campoErros.setForeground(SystemColor.RED);

		errorField = new JScrollPane(campoErros);
		errorField.setLocation(10, 85);
		errorField.setSize(tam + 5, 210);

		JSeparator sep = new JSeparator(SwingConstants.HORIZONTAL);
		sep.setSize(tam + 5, 20);
		sep.setLocation(10, 310);
		sep.setForeground(Color.BLACK);

		ok = new JButton(this.gerInterface.getMessage("COD0072"));
		ok.setVisible(true);
		ok.setBackground(this.getBackground());
		ok.setFont(new Font("Dialog", 1, 12));
		ok.setSize(70,20);
		ok.setLocation(this.getWidth() - 210, sep.getY() + sep.getHeight() );
		ok.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ok_actionPerformed(e);
			}
		});

		details = new JButton(this.gerInterface.getMessage("COD0518"));
		details.setVisible(true);
		details.setSize(110, 20);
		details.setLocation(ok.getX() + 80, ok.getY());
		details.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				details_actionPerformed(e);
			}
		});

		
		this.add(arquivo);
		this.add(campoArquivo);
		this.add(erros);
		this.add(errorField);
		this.add(sep);
		this.add(ok);
		this.add(details);
	}

	/**
	 * Metodo que expande o dialog para conter informaes de implementao,
	 * o StackTrace
	 * @param e
	 */
	protected void details_actionPerformed(ActionEvent e) {
		if (!withStackDetails) {
			campoErros.setText(errorStackTrace);
			erros.setText(this.gerInterface.getMessage("COD0728"));
			withStackDetails = true;
			this.details.setText(this.gerInterface.getMessage("COD0519"));
		}
		else {
			campoErros.setText(errorMessage);
			erros.setText(this.gerInterface.getMessage("COD0517"));
			withStackDetails = false;
			this.details.setText(this.gerInterface.getMessage("COD0518"));
		}
	}

	/**
	 * Fecha a janela
	 * @param e
	 */
	protected void ok_actionPerformed(ActionEvent e) {
		this.setVisible(false);
	}

	/**
	 * Metodo que ira retorna o maior tamanho ocupados pelas string de path e de
	 * erros
	 * @return
	 */
	private int getMaxTam() {
		int max = 0;
		max = SchemaUtils.getWidthOfString(path, this.getFont());
		String errors = this.exibirErrors();
		String[] strs = errors.split("\n");
		for (int i=0; i< strs.length;i++) {
			if (SchemaUtils.getWidthOfString(strs[i], this.getFont()) > max){
				max = SchemaUtils.getWidthOfString(strs[i], this.getFont());
			}
		}
		return max;
	}

	/**
	 * Metodo que exibi os erros de forma a nao parecer o arquivo de entrada
	 */
	protected String exibirErrors() {
		String text = this.gerInterface.getMessage("COD0511");
		text += path + "\n";

		String completeText = "";
		if (errorMessage != null) {
			for (int i=0;i < errorMessage.length();i++) {
				if (errorMessage.charAt(i) == '\"') {

					String split = errorMessage.substring(i+1);

					if (split.startsWith(path)) {
						i += path.length() + 1;
					}
					else {
						completeText += errorMessage.charAt(i);
					}
				}
				else {
					completeText += errorMessage.charAt(i);
				}
			}
		}
		text += completeText;
		return completeText;

	}

}
