/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.List;

import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;

/**
 * Vistor utilizado para selecionar um termo de acordo com sua linha
 * final e inicial.
 * 
 * @author Cristiano Gurgel
 */
public class SelectionTermVisitor implements TermVisitor<Term> {

	/** Relacionamento a buscar na rvore */
	private RelationsAnn linhas;

	/** Log!! */
	private StringWriter log;

	/**
	 * Construtor Padro. Passa um novo relacionamento padro (0, 0).
	 */
	public SelectionTermVisitor() {
		this(new RelationsAnn());
	}

	/**
	 * Inicia um visitor com um relacionamento a pesquisar
	 * 
	 * @param rel as linhas inicial e final do Term a ser buscado
	 */
	public SelectionTermVisitor(RelationsAnn rel) {
		this.setLog(new StringWriter());
		//this.addMessage("Log da Seleo: " + this);
		this.setLinhas(rel);
	}

	public RelationsAnn getLinhas() {
		return linhas;
	}

	public void setLinhas(RelationsAnn linhas) {
		this.linhas = linhas;
//		this.addMessage("PRONTO PARA BUSCAR TERMO (" + this.getLinhaInicial() + 
//		", " + this.getLinhaFinal() + ")");
	}

	private int getLinhaInicial() {
		return this.getLinhas().getLinhaInicial();
	}

	private int getLinhaFinal() {
		return this.getLinhas().getLinhaFinal();
	}

	/**
	 * Acessa o log da classe
	 * 
	 * @return a informacao sobre unificacao
	 */
	public String getInfo() {
		return this.getLog().toString();
	}

	private StringWriter getLog() {
		return log;
	}

	private void setLog(StringWriter log) {
		this.log = log;
	}

	/**
	 * Adiciona uma mensagem ao log de unificacao
	 * 
	 * @param msg a mensagem a ser adicionada
	 */
//	private void addMessage(String msg) {
//	this.getLog().append(msg + "\n");
//	}

	/**
	 * Percorre a Arvore procurando o termo selecionado.
	 * 
	 * @param a AST a ser visitada
	 * @return o Term selecionado ou <code>null</code> se tal termo 
	 * 		no existe
	 */
	public Term visitTerm(Term termo) {
		RelationsAnn relTerm;

		try {
			relTerm = RelationsUtils.retornarTopo(termo);
		} catch (EmptyStackException e) {
			relTerm = null;
		}

		if (relTerm != null) { /* Tem relacionamento */


			/* Term se o Term visitado  o procurado */
			if (this.getLinhaInicial() == relTerm.getLinhaInicial() &&
					this.getLinhaFinal() == relTerm.getLinhaFinal()) {

				/* Achei!! */
				return termo;
			} else {

				/* 
				 * Percorre os Filhos que podem conter o Term 
				 * pesquisado 
				 */
				ChildrenTermExtractor extrator = 
					new ChildrenTermExtractor();
				List<Term> filhos = termo.accept(extrator);

				for (Term filho : filhos) {
					Term result = filho.accept(this);
					if (result != null) {
						return result;
					}
				}

				/* 
				 * No achou o termo com aquelas linhas iniciais 
				 * e final 
				 */
				return null;


			}
		} else { 
			
			/* No tem relacionamento */
			/* 
			 * Percorre os Filhos que podem conter o Term 
			 * pesquisado 
			 */
			ChildrenTermExtractor extrator = 
				new ChildrenTermExtractor();
			List<Term> filhos = termo.accept(extrator);

			for (Term filho : filhos) {
				Term result = filho.accept(this);
				if (result != null) {
					return result;
				}
			}

			/* 
			 * No achou o termo com as linhas inicial e final, 
			 * mas a busca continua
			 */
			return null;
		}

	}

}
