/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import java.io.StringWriter;

import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;

// TODO remover essa classe
public class PercolateASTVisitor implements TermVisitor<Void> {

	/**
	 * Clona um termo da AST
	 * 
	 * @param term o termo a ser clonado
	 * @return o clone do termo
	 * @see #visitTerm(Term)
	 */
	public static void percolateTerm(Term term) {
		PercolateASTVisitor cloner = new PercolateASTVisitor();
		term.accept(cloner);
		//System.out.println(cloner.getInfo());
	}
	
	/** Log para a documentao */
	private StringWriter log;
	
	/**
	 * Construtor vazio
	 */
	public PercolateASTVisitor() {
		this.setLog(new StringWriter());
		this.addMessage("Novo log da classe: " + this);
	}

	/**
	 * Acessa o log da classe
	 * 
	 * @return a informacao sobre unificacao
	 */
	public String getInfo() {
		return this.getLog().toString();
	}
	
	private StringWriter getLog() {
		return log;
	}
	
	private void setLog(StringWriter log) {
		this.log = log;
	}
	
	/**
	 * Adiciona uma mensagem ao log de unificacao
	 * 
	 * @param msg a mensagem a ser adicionada
	 */
	private void addMessage(String msg) {
		this.getLog().append(msg + "\n");
	}
	
	public Void visitTerm(Term termo) {
		String message = "Visitando uma " + termo.getClass().getName() + 
				" ";
		if (RelationsUtils.temRelacionamento(termo)) {
			RelationsAnn rel = RelationsUtils.retornarTopo(termo);
			message += "Linha Inicial(" + rel.getLinhaInicial() + ") Linha Final(" +
				rel.getLinhaFinal() + ")";
		}
		this.addMessage(message);
		this.addMessage(termo.toString());
		VisitorUtils.visitTerm(this, termo, false);
		return null;
	}
}
