/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import java.io.StringWriter;

import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.ListTermVisitor;

/**
 * Comparador utilizado na verificacao da unificacao. 
 * 
 * @author Cristiano Gurgel
 */
public class ListTermCompareVisitor implements ListTermVisitor<Boolean> {

	/** Log da classe */
	private StringWriter log;
	
	/**
	 * Construtor padro vazio. Inicializa o Log da Classe.
	 */
	public ListTermCompareVisitor() {
		this.setLog(new StringWriter());
		this.addMessage("Log da Comparao: " + this);
	}
	
	/**
	 * Acessa o log da classe
	 * 
	 * @return a informacao sobre unificacao
	 */
	public String getInfo() {
		return this.getLog().toString();
	}
	
	private StringWriter getLog() {
		return log;
	}
	
	private void setLog(StringWriter log) {
		this.log = log;
	}
	
	/**
	 * Adiciona uma mensagem ao log de unificacao
	 * 
	 * @param msg a mensagem a ser adicionada
	 */
	private void addMessage(String msg) {
		this.getLog().append(msg + "\n");
	}
	
	/**
	 * Percorre uma lista de termos e retorna <code>true</code> se,
	 * e somente se, todos os elementos da lista so instncias de
	 * {@link Term} e eles so iguais sintaticamentes.
	 * 
	 * @param arg0 a lista de termos a ser visitada.
	 * @return <code>Boolean.TRUE</code> se e somente se, todos os 
	 * 		elementos da lista so instncias de {@link Term} e eles
	 * 		so igusis sintaticamente. <code>Boolean.false</code>,
	 * 		caso contrrio.
	 * @throws NullPointerException se a lista  <code>null</code>.
	 */
	public Boolean visitListTerm(ListTerm arg0) {
		
		if (arg0.size() == 0) {

			/* No h nada a ser comparado */
			this.addMessage("Elementos iguais sintaticamente: Lista vazia");
			return Boolean.TRUE;
			
		} else {
			Object first = arg0.get(0);
			
			/* Primeiro elemento da lista  um Term */
			if (first instanceof Term) {
				Term firstTerm = (Term)first;

				for (Object elem : arg0) {
					if (elem instanceof Term) {
						Term elemTerm = (Term)elem;

//						ComparatorVisitor comparator = 
//								new ComparatorVisitor(firstTerm);
//						if (!elemTerm.accept(comparator)) {
						if (!elemTerm.equals(firstTerm)) {

							/* 
							 * Elementos da lista so diferentes 
							 * sintaticamente 
							 */
							this.addMessage("Comparao da lista diferentes" + 
											" sintaticamente");
							//this.addMessage(comparator.getInfo());
							return Boolean.FALSE;
						}
					} else {
						
						/* 
						 * H um elemento da lista que no  um 
						 * Term 
						 */
						this.addMessage("Elemento da lista no  instncia " + 
								"de Term: " + elem);
						return Boolean.FALSE;
					}
				}
				
				/* Testou com sucesso todos os elementos da lista */
				this.addMessage("COMPARAO BEM SUCEDIDA");
				return Boolean.TRUE;
			} else {
				
				/* 
				 * O primeiro elemento da lista no  instncia de 
				 * Term 
				 */
				this.addMessage("Elemento da lista no  instncia " + 
						"de Term: " + first);
				return Boolean.FALSE;
				
			}
		}
	}
}
