/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.visitor.JokerActionVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessVisitor;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerRenameList;
import net.sourceforge.czt.zpatt.ast.JokerStroke;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerPredVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerRenameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerStrokeVisitor;

/**
 * Visitor responsvel por capturar os Jokers de uma dada AST
 * 
 * @author Cristiano Gurgel
 */
public class JokersGetterVisitor implements TermVisitor<List<Term>>,
	JokerActionVisitor<List<Term>>, JokerChannelSetVisitor<List<Term>>, 
	JokerCommunicationVisitor<List<Term>>, JokerDeclListVisitor<List<Term>>,  
	JokerExprVisitor<List<Term>>, JokerExprListVisitor<List<Term>>, 
	JokerNameVisitor<List<Term>>, JokerNameListVisitor<List<Term>>, 
	JokerNameSetVisitor<List<Term>>, JokerParaVisitor<List<Term>>,
	JokerParaListVisitor<List<Term>>, JokerPredVisitor<List<Term>>, 
	JokerProcessVisitor<List<Term>>, JokerRenameListVisitor<List<Term>>, 
	JokerStrokeVisitor<List<Term>> {

	/**
	 * Mtodo auxiliar para retornar todas as instncias de Jokers
	 * em um Termo
	 * 
	 * @param termo o termo a ser visitado
	 * @return um conjunto com todos os Jokers em termo
	 */
	public static List<Term> getJokers(Term termo) {
		JokersGetterVisitor visitor = new JokersGetterVisitor();
		return termo.accept(visitor);
	}
	
	public JokersGetterVisitor() { }
	
	/**
	 * Percorre uma determinada AST retornando todos os Jokers 
	 * encontrados.
	 * 
	 * @param arg0 a AST visitada.
	 * @return um conjunto com todos os Jokers encontrados.
	 */
	public List<Term> visitTerm(Term arg0) {
		ChildrenTermExtractor extrator = new ChildrenTermExtractor();
		List<Term> filhos = arg0.accept(extrator);
		List<Term> result = new LinkedList<Term>();
		
		/* Adiciona todos os joker encontrados nos filhos */
		for (Term filho : filhos) {
			result.addAll(filho.accept(this));
		}
		
		return result;
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerAction(JokerAction arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0)); 
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerChannelSet(JokerChannelSet arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerCommunication(JokerCommunication arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerProcess(JokerProcess arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerDeclList(JokerDeclList arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}

	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerExpr(JokerExpr arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerExprList(JokerExprList arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerName(JokerName arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerNameSet(JokerNameSet arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerPred(JokerPred arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerNameList(JokerNameList arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerPara(JokerPara arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerParaList(JokerParaList arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerRenameList(JokerRenameList arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
	
	/**
	 * Retorna o Joker um conjunto unitrio contendo o Joker 
	 * capturado.
	 * 
	 * @param arg0 o joker a ser visitado.
	 * @return Um conjunto contendo o joker.
	 */
	public List<Term> visitJokerStroke(JokerStroke arg0) {
		return new LinkedList<Term>(Arrays.asList((Term)arg0));
	}
}
