/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSetBinding;
import net.sourceforge.czt.circuspatt.ast.JokerCommunicationBinding;
import net.sourceforge.czt.circuspatt.ast.JokerNameSetBinding;
import net.sourceforge.czt.circuspatt.ast.JokerParaBinding;
import net.sourceforge.czt.circuspatt.ast.JokerParaListBinding;
import net.sourceforge.czt.circuspatt.ast.JokerProcessBinding;
import net.sourceforge.czt.circuspatt.visitor.JokerActionBindingVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetBindingVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationBindingVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetBindingVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaBindingVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListBindingVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessBindingVisitor;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclListBinding;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import net.sourceforge.czt.zpatt.ast.JokerExprListBinding;
import net.sourceforge.czt.zpatt.ast.JokerNameBinding;
import net.sourceforge.czt.zpatt.ast.JokerNameListBinding;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import net.sourceforge.czt.zpatt.ast.JokerRenameListBinding;
import net.sourceforge.czt.zpatt.ast.JokerStrokeBinding;
import net.sourceforge.czt.zpatt.visitor.BindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListBindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprBindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprListBindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameBindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameListBindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerPredBindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerRenameListBindingVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerStrokeBindingVisitor;
import circusRefine.util.Pair;

/**
 * Visita um Binding, Retornando um mapeamento da String
 * representando o nome do Joker com o Term representado pelo Joker.
 * 
 * @author Cristiano Gurgel
 */
public class BindingGetterVisitor implements
		JokerActionBindingVisitor<Pair<String, Term>>,
		JokerChannelSetBindingVisitor<Pair<String, Term>>, 
		JokerCommunicationBindingVisitor<Pair<String, Term>>,
		JokerDeclListBindingVisitor<Pair<String, Term>>, 
		JokerExprBindingVisitor<Pair<String, Term>>,
		JokerExprListBindingVisitor<Pair<String, Term>>,
		JokerNameBindingVisitor<Pair<String, Term>>,
		JokerNameListBindingVisitor<Pair<String, Term>>, 
		JokerNameSetBindingVisitor<Pair<String, Term>>,
		JokerParaBindingVisitor<Pair<String, Term>>,
		JokerParaListBindingVisitor<Pair<String, Term>>,
		JokerPredBindingVisitor<Pair<String, Term>>, 
		JokerProcessBindingVisitor<Pair<String, Term>>,
		JokerRenameListBindingVisitor<Pair<String, Term>>,
		JokerStrokeBindingVisitor<Pair<String, Term>>,
		BindingVisitor<Pair<String, Term>> {

	public static Pair<String, Term> getMap(Binding bind) {
		BindingGetterVisitor visitor = new BindingGetterVisitor();
		return bind.accept(visitor);
	}
	
	public BindingGetterVisitor() {
	}
	
	public Pair<String, Term> visitBinding(Binding arg0) {
		throw new UnsupportedAstClassException();
	}
	
	// TODO comentar esta classe
	public Pair<String, Term> 
			visitJokerActionBinding(JokerActionBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerAction().getName(), 
				arg0.getCircusAction());
		return result;
	}

	public Pair<String, Term> 
			visitJokerChannelSetBinding(JokerChannelSetBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerChannelSet().getName(), 
				arg0.getChannelSet());
		return result;
	}

	
	public Pair<String, Term> 
			visitJokerCommunicationBinding(JokerCommunicationBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerCommunication().getName(), 
					arg0.getCommunication());
		return result;
	}

	public Pair<String, Term> 
			visitJokerDeclListBinding(JokerDeclListBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerDeclList().getName(), 
					arg0.getDeclList());
		return result;
	}

	public Pair<String, Term> visitJokerExprBinding(JokerExprBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerExpr().getName(), 
					arg0.getExpr());
		return result;
	}

	public Pair<String, Term> 
			visitJokerExprListBinding(JokerExprListBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerExprList().getName(), 
					arg0.getExprList());
		return result;
	}

	public Pair<String, Term> visitJokerNameBinding(JokerNameBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerName().getName(), 
					arg0.getName());
		return result;
	}

	public Pair<String, Term> 
			visitJokerNameListBinding(JokerNameListBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerNameList().getName(), 
					arg0.getNameList());
		return result;
	}

	public Pair<String, Term> 
			visitJokerNameSetBinding(JokerNameSetBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerNameSet().getName(), 
					arg0.getNameSet());
		return result;
	}

	public Pair<String, Term> visitJokerPredBinding(JokerPredBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerPred().getName(), 
					arg0.getPred());
		return result;
	}

	public Pair<String, Term> 
			visitJokerProcessBinding(JokerProcessBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerProcess().getName(), 
					arg0.getCircusProcess());
		return result;
	}
	
	public Pair<String, Term> 
			visitJokerParaListBinding(JokerParaListBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerParaList().getName(), 
					arg0.getParaList());
		return result;
	}
	
	public Pair<String, Term> visitJokerParaBinding(JokerParaBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerPara().getName(), 
					arg0.getPara());
		return result;
	}
	
	public Pair<String, Term> 
			visitJokerRenameListBinding(JokerRenameListBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerRenameList().getName(), 
					arg0.getRenameList());
		return result;
	}
	
	public Pair<String, Term> visitJokerStrokeBinding(JokerStrokeBinding arg0) {
		Pair<String, Term> result = 
			new Pair<String, Term>(arg0.getJokerStroke().getName(), 
					arg0.getStroke());
		return result;
	}

}
