/*
 * Projeto: Circus Refine
 */
package circusRefine.core.storage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

import circusRefine.core.CircusRefine;
import circusRefine.core.ExternalManager;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.Annotations;

/**
 * Classe com m�todos �teis para o salvamento e a abertura de 
 * programas
 * 
 * @author Cristiano Castro
 */
public class StorageUtils {

	/** O objeto utilizado para salvar o hist�rico */
	private XStream saver;

	/** Nome do atributo vers�o */
	private static String versionAtribute = "CRefine version ";

	/**
	 * Construtor padr�o. Configura alguns par�metros do XStream para
	 * o salvamento do programa
	 */
	public StorageUtils() {

		/* Cria o novo XStream para o salvamento do arquivo */
		this.setSaver(new XStream());

		/** 
		 * N�o h� preocupa��o com refer�ncias, utilizado para 
		 * economizar mem�ria no salvamento/abertura 
		 */
		this.getSaver().setMode(XStream.ID_REFERENCES);

		/* Configura as anota��es */
		Annotations.configureAliases(this.getSaver(), ToSave.class);
		Annotations.configureAliases(this.getSaver(), 
				CarregamentoEspecificacao.class);
		Annotations.configureAliases(this.getSaver(), Coleta.class);
		Annotations.configureAliases(this.getSaver(), LawApplication.class);
		Annotations.configureAliases(this.getSaver(), AdicaoComentario.class);
		Annotations.configureAliases(this.getSaver(), RemocaoComentario.class);

	}

	/**
	 * @return the saver
	 */
	private XStream getSaver() {
		return saver;
	}

	/**
	 * @param saver the saver to set
	 */
	private void setSaver(XStream saver) {
		this.saver = saver;
	}

	/**
	 * Salva um hist�rico de refinamento. Para posterior reabertura do 
	 * refinamento.
	 * 
	 * @param historico os passos de refinamento do CRefine
	 * @param arquivo no qual o hist�rico dever� ser salvo
	 */
	public void salvarPrograma(ToSave historico, File file) 
	throws IOException {


		/* Transforma o status em XML */
		String src = this.getSaver().toXML(historico);
		String toSave = StorageUtils.versionAtribute + historico.getVersion() + 
		"\n" + src;

		/* Salva o XML no arquivo usando a codifica��o padr�o */
		byte [] data = toSave.getBytes();

		/* OutputStreams */
		FileOutputStream out = new FileOutputStream(file);
		out.write(data);
	}

	public ToSave abrirPrograma(File arquivo) throws IOException {


		/* Primeiro inicia os objetos para a leitura do arquivo */
		FileInputStream fin = new FileInputStream(arquivo);
		ByteArrayOutputStream buffer = 
			new ByteArrayOutputStream(fin.available());

		/* L� do arquivo */

		int temp;
		while ((temp = fin.read()) != -1) {
			buffer.write(temp);
		}


		/* Pega a string a partir dos dados do arquivo */
		String xml = buffer.toString();

		/* Primeiro testa se o arquivo � XML do tipo CRefine*/
		if (xml.startsWith(StorageUtils.versionAtribute)) {

			/* Arquivo v�lido */
			int endIdx = xml.indexOf('\n');
			int beginIdx = StorageUtils.versionAtribute.length();
			String version = xml.substring(beginIdx, endIdx);
			if (!version.equals(CircusRefine.version)) {

				// TODO alertar quanto � mudan�a de vers�o
				System.err.println("Warning: the file was written by an old " +
				"version of the program");
			}

			xml = xml.substring(endIdx + 1);
			/* Retorno do hist�rico do desenvolvimento */
			ToSave historico = (ToSave)this.getSaver().fromXML(xml);
			return historico;

		} else {

			// TODO disparar uma excess�o
			return null;
		}


	}

	public ToSave abrirPrograma(File arquivo, ExternalManager gerInterface) 
	throws IOException{

		/* Primeiro inicia os objetos para a leitura do arquivo */
		FileInputStream fin = new FileInputStream(arquivo);
		ByteArrayOutputStream buffer = 
			new ByteArrayOutputStream(fin.available());

		/* L� do arquivo */
		int pacote = 200;
		gerInterface.retornarTelaPrincipal().setarMaximumProgressBar((int)arquivo.length()/pacote);

		int counter = 0;
		int temp;
		while ((temp = fin.read()) != -1) {
			buffer.write(temp);
			if (counter % pacote == 0){
				gerInterface.retornarTelaPrincipal().incrementProgress();
			}
			counter++;
		}
		gerInterface.retornarTelaPrincipal().finish();


		/* Pega a string a partir dos dados do arquivo */
		String xml = buffer.toString();

		/* Primeiro testa se o arquivo � XML do tipo CRefine*/
		if (xml.startsWith(StorageUtils.versionAtribute)) {

			/* Arquivo v�lido */
			int endIdx = xml.indexOf('\n');
			int beginIdx = StorageUtils.versionAtribute.length();
			String version = xml.substring(beginIdx, endIdx);
			if (!version.equals(CircusRefine.version)) {

				// TODO alertar quanto � mudan�a de vers�o
				System.err.println("Warning: the file was written by an old " +
				"version of the program");
			}

			xml = xml.substring(endIdx + 1);
			/* Retorno do hist�rico do desenvolvimento */
			ToSave historico = (ToSave)this.getSaver().fromXML(xml);
			return historico;

		} else {

			// TODO disparar uma excess�o
			return null;
		}
	}
}
