package circusRefine.core.storage;

import circusRefine.core.ExternalManager;
import circusRefine.core.ObrigacaoProva;
import circusRefine.core.crules.CRulesException;
import circusRefine.util.CRefineException;

/**
 * Carrega um subdesenvolvimento a partir da Obriga��o de Prova que o gerou
 * @author alessandro87
 *
 */
public class CarregamentoSubDesenvolvimento implements StepOfExecution{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 7432335158543706852L;
	
	private ObrigacaoProva op;
	private int indiceOP;
	private String nomePai;
	
	public CarregamentoSubDesenvolvimento ( int index) {
		indiceOP = index;
		nomePai = "";
		
	}
	public void setNomePai(String str){
		nomePai = str;
	}
	
	public void doStep(ExternalManager externo) throws CRefineException, CRulesException {
		externo.openSpecification(nomePai, indiceOP);
	}

	public void redoPrintLatexStep(ExternalManager externo) {
		
	}

	public void redoStep(ExternalManager externo) throws CRefineException, CRulesException {
		
	}

	public void undoPrintLatexStep(ExternalManager externo) {
		
	}

	public void undoStep(ExternalManager externo) throws CRefineException, CRulesException {
		
	}
	public String getNomePai() {
		return nomePai;
	}

}
