
/*
 * ParaPrint.java
 *
 * Created on 19 de Setembro de 2005, 19:31
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.util.CircusUtils;
import circusRefine.core.NoPrograma;
import java.util.List;
import circusRefine.core.Relacionamento;
import circusRefine.core.annotations.StatementSchExprAnn;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.util.SchemaString;
import circusRefine.util.SchemaUtils;
import net.sourceforge.czt.base.ast.*;
import net.sourceforge.czt.oz.visitor.ClassParaVisitor;
import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.z.visitor.*;
import net.sourceforge.czt.circus.ast.*;
import net.sourceforge.czt.circus.visitor.*;

/**
 *
 * @author Alessandro 
 */
public class ParaPrint 
extends Print
implements ChannelParaVisitor,
ChannelSetParaVisitor,
ProcessParaVisitor,
ActionParaVisitor,
NameSetParaVisitor,
GivenParaVisitor,
AxParaVisitor ,
FreeParaVisitor,
FreetypeVisitor,
ConjParaVisitor,
SchTextVisitor,
ParaVisitor ,
CircusConjParaVisitor ,
ClassParaVisitor ,
TransformerParaVisitor,
LatexMarkupParaVisitor, 
OptempParaVisitor
{

	/** Creates a new instance of ParaPrint */
	public ParaPrint(Printer printer) {
		super(printer);
	}



	public Object visitTerm(Term term)
	{
		return term.accept(this);
	}

	// CircusParagraph ::= channel CDeclaration
	// ok - verificado em 25/09/2005 �s 10:25
	public Object visitChannelPara(ChannelPara term) 
	{
		getPercurso().append("Channel PAra\n");
		String result[] = null;

		int adder = 1;

		if (!getUnicoded()) {
			result = new String[3];
		}
		else {
			result = new String[1];
		}
		//the list of CDeclaration
		ZDeclList chanDecls = (ZDeclList)term.getZDeclList();

		String strDecls = "";
		int size = chanDecls.size();
		int counter = 0;
		boolean isChannelFromDecl = false;
		for (Decl chanDecl : chanDecls) {

			if (chanDecls.size() == 1) {
				ChannelDecl chandecl = (ChannelDecl)chanDecl;
				if (chandecl.getZChannelNameList().size() == 0) {
					isChannelFromDecl = true;
				}

			}
			strDecls = strDecls + ((String[])chanDecl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + "; ";
			}
			counter++;
		}
		if (!getUnicoded()) {
			if (!isChannelFromDecl) {
				result[0] = "\\begin{circus}";
				result[1] = BRANCO + "\\circchannel " + strDecls;
				result[2] = "\\end{circus}";
			}
			else {
				result[0] = "\\begin{circus}";
				result[1] = BRANCO + "\\circchannelfrom " + strDecls;
				result[2] = "\\end{circus}";
			}
		}
		else {
			if (!isChannelFromDecl) {
				String str = CircusString.CIRCCHAN + Space;
				result[0] = BRANCO + str + strDecls;
			}
			else {
				String str = CircusString.CIRCCHANFROM + Space;
				result[0] = BRANCO + str + strDecls;
			}
		}
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(this.getCounterRow(), this.getCounterRow() + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(this.getCounterRow(), this.getCounterRow() + length)
		, term, isToInsertingRelAnn());
		// Mais um -> devido ao espa�amento entre paragrafos;
		this.addCounterRow(length + adder); 
		addRelacionamento(rel);

		return result;
	}

	// CircusParagraph ::= chanset N == CSExpression
	// ok - verificado em 25/09/2005 �s 10:25
	public Object visitChannelSetPara(ChannelSetPara term)
	{

		getPercurso().append("ChannelSetPara\n");

		int linhaInicial = this.getCounterRow();

		ZName name = (ZName)term.getName();
		ChannelSet chanSet = term.getChannelSet();
		String strName = name.getWord();

		String strChanSet = ((String[])chanSet.accept(exprPrint()))[0];

		ZNameList genericParams = (ZNameList)term.getGenFormals();

		String[] result = null;	  

		if (!getUnicoded()) {

			result = new String[3];
			result[0] = "\\begin{circus}";
			result[1] = BRANCO + "\\circchannelset ";
			result[2] = "\\end{circus}";
			if (genericParams.isEmpty()){
				result[1] = result[1] + strName + " == " + strChanSet;
			}
			else{
				boolean first = true;
				result[1] = result[1] + "[";
				for (Name nome : genericParams){
					ZName nombre = (ZName)nome;
					if (first) first = false;
					else result[1] = result[1] + Space + ZString.COMMA + Space;
					result[1] = result[1] + nombre.getWord();
				}
				result[1] = result[1] + "]";

				result[1] = result[1]+ Space + strName + " == " + strChanSet;
			}
		}
		else {
			result = new String[1];
			result[0] = BRANCO + CircusString.CIRCCHANSET + Space;
			if (genericParams.isEmpty()) {
				result[0] = result[0]  
				                   + strName + Space + ZString.DEFEQUAL + Space + strChanSet;

			}
			else{
				boolean first = true;
				result[0] = result[0] + "[";
				for (Name nome : genericParams){
					ZName nombre = (ZName)nome;
					if (first) first = false;
					else result[0] = result[0] + Space + ZString.COMMA + Space;
					result[0] = result[0] + nombre.getWord();
				}
				result[0] = result[0] + "]";
				result[0] = result[0] + Space 
				+ strName + Space + ZString.DEFEQUAL + Space + strChanSet;
			}
		}

		int length = result.length;

		NoPrograma noProg = new NoPrograma(term);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);
		this.setCounterRow(linhaInicial + length);


		return result;
	}

	// CircusParagraph ::= ProcessDeclaration
	// ProcessDeclaration ::= process N \defs ProcessDefinition
	// ProcessDeclaration ::= process N[N+] \defs ProcessDefinition
	// ok - verificado em 25/09/2005 �s 10:26
	public Object visitProcessPara(ProcessPara term)
	{
		String[] result = null;

		getPercurso().append("ProcessPar\n");

		// guarda a Liha Inicial para setar o Relacionamento
		int linhaInicial = this.getCounterRow();
		int adder = 1;

		if (!getUnicoded()) {
			this.addCounterRow(2);
		}
		else {
			this.addCounterRow(1);
		}

		ZName nameProc = (ZName)term.getName();
		List<Name> genParams = (ZNameList)term.getGenFormals();

		CircusProcess circProc = term.getCircusProcess();

		String strName = nameProc.getWord();

		if (!nameProc.getZStrokeList().isEmpty()) {
			Stroke stroke = (Stroke)nameProc.getZStrokeList().get(0);

			if(stroke instanceof InStroke) {
				strName = strName + ZString.INSTROKE;
			}
			else if(stroke instanceof OutStroke) {
				strName = strName + ZString.OUTSTROKE;
			}
			else if (stroke instanceof NumStroke) {

				NumStroke numstroke = (NumStroke)stroke;
				Digit digit = numstroke.getDigit();
				strName = strName + ZString.ARG_TOK + digit.getValue();
			}
			else if(stroke instanceof NextStroke) {
				strName = strName + "'";
			}

		}

		String[] strProc = (String[])circProc.accept(processPrint());
		String strGenParams = "";

		int size = genParams.size();

		int counter = 0;
		for(Name ndecl : genParams) {

			ZName decl = (ZName)ndecl;

			if(counter == 0) {
				strGenParams = "[";
			}
			strGenParams = strGenParams + decl.getWord();
			if(counter < size-1) {
				strGenParams = strGenParams + ",";
			} 
			else if(counter == size-1) {
				strGenParams = strGenParams + "]";
			}
			counter++;
		}

		//LATEX
		if(!getUnicoded()) {
			int index = 2;
			result = new String[strProc.length + 3];
			result[0] = "\\begin{circus}";
			result[1] = BRANCO + "\\circprocess\\" + Space + strGenParams + Space + strName + " \\circdef ";
			for(int i=0; i<strProc.length; i++) {
				result[index++] = BRANCO + BRANCO + strProc[i];
			}
			result[index] = "\\end{circus}";

		}
		//UNICODE
		else {
			int index = 1;
			result = new String[strProc.length + 1];
			result[0] = BRANCO + CircusString.CIRCPROC + Space + strName + strGenParams + Space + CircusString.CIRCDEF + Space;
			for(int i=0; i<strProc.length; i++) {
				result[index++] = BRANCO + BRANCO + strProc[i];
			}

		}

		int length = result.length;

		NoPrograma noProg = new NoPrograma(term);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);
		this.setCounterRow(linhaInicial + length + adder);

		return result;
	}

	// PParagraph ::= N \defs ActionDefinition
	// ok - verificado em 25/09/2005 �s 10:29
	public Object visitActionPara(ActionPara term)
	{
		getPercurso().append("ActionPara\n");

		String[] result = null;


		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1); // Incrimenta a Linha Inicial das Classes Filhas em 1;

		ZName actionName = (ZName)term.getName();
		CircusAction action = term.getCircusAction();

		String strName = actionName.getWord();
		if (strName.startsWith(CircusUtils.DEFAULT_MAIN_ACTION_NAME)) {
			strName = "Main Action";
		}
		else if (strName.startsWith(CircusUtils.DEFAULT_PROCESS_STATE_NAME)) {
			strName = Space;
		}
		if (strName.startsWith(CircusUtils.DEFAULT_IMPLICIT_PROCESS_NAME_PREFIX.substring(0, 2))){
			strName = "Implicit Action" + strName.charAt(strName.length()-1);
		}

		String[] strAct = (String[])action.accept(actionPrint());

		result = new String[strAct.length + 1];

		int index = 1;

		if (!getUnicoded()) {
			result[0] =  strName + " \\circdef ";
		}
		else {
			result[0] = strName + Space + CircusString.CIRCDEF + Space;
		}

		for(int i=0; i<strAct.length; i++) {
			result[index++] =  BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		addRelacionamento(rel);
		this.setCounterRow(linhaInicial + length);

		return result;
	}

	// PParagraph ::= nameset N == NSExpression
	//ok - verificado em 25/09/2005 �s 10:30
	public Object visitNameSetPara(NameSetPara term)
	{
		getPercurso().append("NameSet\n");

		String[] result = null;
		if (!getUnicoded()) {
			result = new String[3];
			this.addCounterRow(1);
		}
		else 
			result = new String[1];

		int linhaInicial = this.getCounterRow();
		ZName name = (ZName)term.getName();
		NameSet ns = term.getNameSet();

		String strName = name.getWord();

		String strNS = ((String[])ns.accept(exprPrint()))[0];
		if (!getUnicoded()) {
			result[0] = "\\begin{circus}";
			result[1] = BRANCO + "\\circnameset " + strName + " == " + strNS;
			result[2] = "\\end{circus}";
		}
		else{
			result[0] = BRANCO + CircusString.CIRCNAMESET + Space+  strName + " == " + strNS;
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		addRelacionamento(rel);
		this.setCounterRow(linhaInicial + length);

		return result;
	}

	/**
	 * Any "left-over" paragraphs.
	 */
	public Object visitPara(Para para)
	{
		return para.accept(this);
	}

	//13.2.4.1
	public Object visitGivenPara(GivenPara givenPara)
	{
		String[] result = null;
		if (!getUnicoded())
			result = new String[3];
		else
			result = new String[1];

		getPercurso().append("GivenPAra\n");

		List<Name> Names = givenPara.getZNameList();

		int counter = 0;
		int size = Names.size();
		String strDecl = "";
		int linhaInicial = this.getCounterRow();
		for (Name name : Names) {
			ZName nombre = (ZName)name;
			strDecl = strDecl + nombre.getWord();
			if(counter < size-1) {
				strDecl = strDecl + ",";
			}
			counter++;
		}
		if (!getUnicoded()) {
			result[0] = "\\begin{zed}";
			result[1] = BRANCO + "[" + strDecl + "]";
			result[2] = "\\end{zed}";
		}
		else {
			result[0] = BRANCO + "[" + strDecl + "]";
		}


		NoPrograma noProg = new NoPrograma(givenPara);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, givenPara, isToInsertingRelAnn());

		addRelacionamento(rel);
		this.setCounterRow(linhaInicial + length);

		return result;
	}

	//13.2.4.2 and 13.2.4.3
	public Object visitAxPara(AxPara axPara)
	{
		getPercurso().append("VisitAxPara\n");
		String[] result = new String[2];

		Box box = axPara.getBox();
		int linhaInicial = this.getCounterRow();

		List<Name> names = axPara.getName();
		SchText sch = axPara.getSchText();

		String strInicial = "";
		String strFinal = "";
		String strGP = "";


		int size = names.size();
		int counter = 0;
		for(Name name : names) {

			ZName zname = (ZName) name;

			if(counter == 0) {
				strGP = "[";
			}
			strGP = strGP + zname.getWord();
			if(counter < size-1) {
				strGP = strGP + ",";
			}
			else if(counter == size-1) {
				strGP = strGP + "]";
			}
			counter++;
		}

		/* indica se esta havendo impressao */
		boolean printingSpecStmtm = false;
		/* No caso se for impressão do specstmt deve-se imprimir horizontalmente */
		for (Decl decl : ((ZSchText)sch).getZDeclList()) {
			if (decl instanceof ConstDecl) {
				ConstDecl constdecl = (ConstDecl)decl;
				if (constdecl.getExpr().getAnn(StatementSchExprAnn.class)!= null){
					printingSpecStmtm = true;
				}
			}
		}
		
		if(box.equals(Box.SchBox) && !printingSpecStmtm) {
			setIsSchema(true);
		}

		String[] strSch = (String[])sch.accept(this);

		if(box.equals(Box.AxBox)) {
			if (names.size() != 0 && names != null)  {
				strInicial = "\\begin{gendef}";
				strFinal = "\\end{gendef}";
			}
			else {
				strInicial = "\\begin{axdef}";
				strFinal = "\\end{axdef}";
			}
			//LATEX
			if (!getUnicoded()) {
				result = new String[strSch.length + 2];
				result[0] = strInicial;
				int index = 1;
				for(int i=0; i<strSch.length; i++) {
					result[index++] = BRANCO + strSch[i];
				}
				result[index] = strFinal;
			}
			//UNICODE
			else{
				result = new String[strSch.length];
				int index = 0;
				for(int i=0; i<strSch.length; i++) {
					result[index++] = BRANCO + strSch[i];
				}
			}
		}
		else if(box.equals(Box.SchBox) && !printingSpecStmtm) {

			if (size!= 0 && names != null)  {
				strSch[0] = strSch[0] + strGP;
			}
			result = strSch;
		}
		//Trata-se de um OmitBox
		else {
			if (size != 0) {
				String aux = strSch[0]; // Horizontal Definition, contem apenas 1 linha
				//Temos que inserir os parametros apos o name do ConstDecl
				int insertPosition = aux.indexOf( this.Space + "==");
				String antes = aux.substring(0, insertPosition);
				String depois = aux.substring(insertPosition, aux.length());
				strSch[0] = antes + strGP + depois;
			}

			result = strSch;
		}

		setIsSchema(false);

		NoPrograma noProg = new NoPrograma(axPara);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, axPara, isToInsertingRelAnn());
		addRelacionamento(rel);

		return result;

	}

	public Object visitFreePara(FreePara freePara)
	{
		String[] result = null;

		getPercurso().append("FreePara\n");
//		guarda a Liha Inicial para setar o Relacionamento
		int linhaInicial = this.getCounterRow();

		if (!getUnicoded()) {
			this.addCounterRow(1);
		}

		List<Freetype> freetypes = (ZFreetypeList)freePara.getFreetypeList();
		String strFT = "";

		int size = freetypes.size();
		int counter = 0;
		for (Freetype freetype : freetypes) {
			strFT = strFT + ((String[])freetype.accept(this))[0];
			if(counter < size-1) {
				strFT = strFT + Space + ZString.AMP+ Space;
			}
			counter++;
		}
		if (!getUnicoded()) {
			result = new String[3];
			result[0] = "\\begin{zed}";
			result[1] = BRANCO + strFT;
			result[2] = "\\end{zed}";
		}
		else {
			result = new String[1];
			result[0] = BRANCO + strFT;
		}

		int length = result.length;

		NoPrograma noProg = new NoPrograma(freePara);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, freePara, isToInsertingRelAnn());
		addRelacionamento(rel);

		this.setCounterRow(length +  linhaInicial + 1);

		return result;
	}

	public Object visitFreetype(Freetype freetype)
	{
		String[] result = new String[1];

		getPercurso().append("FreTypePAra\n");
		int linhaInicial = this.getCounterRow();
		ZName declName = freetype.getZName();
		List<Branch> branches = (ZBranchList)freetype.getBranchList();

		String strName = declName.getWord();
		String strBranch = "";

		int size = branches.size();
		int counter = 0;    
		for (Branch branch : branches) {
			strBranch = strBranch + localVisitBranch(branch);
			if(counter < size-1) {
				strBranch = strBranch + " | ";
			}
			counter++;
		}

		result[0] = strName + Space + ZString.DEFEQUAL + Space
		+ strBranch;
		int length = result.length;

		NoPrograma noProg = new NoPrograma(freetype);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, freetype, isToInsertingRelAnn());
		addRelacionamento(rel);

		this.setCounterRow(length +  linhaInicial + 1);


		return result;
	}

	protected String localVisitBranch(Branch branch)
	{
		String result = "";

		getPercurso().append("localVisitBranch\n");

		ZName declName = branch.getZName();
		Expr expr = branch.getExpr();

		String strName = declName.getWord();
		String strExpr = "";

		if (expr != null) {
			if (!getUnicoded()) {
				strExpr = " \\ldat " + ((String[])expr.accept(exprPrint()))[0] + " \\rdat";
			}
			else {
				strExpr = Space + ZString.LDATA + ((String[])expr.accept(exprPrint()))[0] 
				                                                                       + Space + ZString.RDATA;
			}
		}

		result = strName + strExpr;

		return result;
	}

	public Object visitConjPara(ConjPara conjPara)
	{
		String[] result = new String[3];
		if (!getUnicoded())
			result = new String[3];
		else
			result = new String[1];

		getPercurso().append("ConjPara\n");
		int linhaInicial = this.getCounterRow();
		if (getUnicoded()) {
			addCounterRow(1);
		}

		Pred pred = conjPara.getPred();
		List<Name> genParams = conjPara.getZNameList();

		String strPred = ((String[])pred.accept(predPrint()))[0];
		String strGP = "";

		if(genParams != null && genParams.size() != 0) {
			int size = genParams.size();
			int counter = 0;
			for(Name name : genParams) {
				ZName nombre = (ZName) name;
				if(counter == 0) {
					strGP = "[";
				}
				strGP = strGP + nombre.getWord();
				if(counter < size-1) {
					strGP = strGP + ",";
				}
				else if(counter == size-1) {
					strGP = strGP + "]";
				}
			}
		}
		if (!getUnicoded()) {
			result[0] = "\\begin{zed}";
			// duvida - \\conjecture ou \\vdash
			result[1] = BRANCO + strGP + Space + "\\conjecture" + Space + strPred;
			result[2] = "\\end{zed}";
		}
		else {
			result[0] = BRANCO + strGP + Space + ZString.CONJECTURE + Space + strPred;
		}

		int length = result.length;

		NoPrograma noProg = new NoPrograma(conjPara);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, conjPara, isToInsertingRelAnn());
		addRelacionamento(rel);

		this.setCounterRow(length +  linhaInicial + 1);

		return result;
	}

	public Object visitCircusConjPara (CircusConjPara circusConjPara) {
		getPercurso().append("CircusConjPara\n");
		TransformerPara trans = (TransformerPara)circusConjPara;
		String result[] = (String[])trans.accept(paraPrint());
		return result;
	}
	public Object visitTransformerPara (TransformerPara trans) {

		getPercurso().append("TransformerPara\n");
		String aux[] = null;
		int linhaInicial = this.getCounterRow();
		if (!getUnicoded())
			this.addCounterRow(1);//devido ao \\begin{circus}
		aux = (String[])trans.getTransformerPred().accept(predPrint());

		String[] result = null;
		if (!getUnicoded()) {
			result = new String[aux.length + 2];
			int index=0;
			result[index++] = "\\begin{circus}";
			for (int i=0; i<aux.length;i++) {
				result[index++] = BRANCO + aux[i];
			}
			result[index++] = "\\end{circus}";

		}
		else {
			result = new String[aux.length];
			for (int i=0;i<aux.length;i++) {
				result[i] = aux[i];
			}
		}

		this.setCounterRow(linhaInicial + result.length);

		return result;
	}

	public Object visitClassPara (net.sourceforge.czt.oz.ast.ClassPara classPara) {
		String [] result = null;
		getPercurso().append("ClassPara\n");
		//TODO CLASSPARA ?

		return result;
	}


	public Object visitSchText(SchText schText)
	{
		String[] result = null;
		String[] resTemp = null;

		ZSchText ZschText = (ZSchText)schText;
		getPercurso().append("SchTExt do Para\n");
		ZDeclList decls = ZschText.getZDeclList();
		Pred pred = ZschText.getPred();

		String[] strPred = null;

		if(pred != null) {
			strPred = (String[])pred.accept(predPrint());
			
		}
		int index = 0;
		for (Decl decl : decls) {

			if(decl instanceof ConstDecl && isSchema()) {
				
				ConstDecl cDecl = (ConstDecl)decl;
				ZName declName = cDecl.getZName();
				Expr expr = cDecl.getExpr();
				this.addCounterRow(1); //adiciona 1 por causa do \\begin{schema}{
				String[] strExpr = (String[])expr.accept(exprPrint());
				result = new String[strExpr.length + 2];

				if (!getUnicoded()) {

					result[0] = "\\begin{schema}{" + declName.getWord() + "}";
					int idx = 1;
					for(int i=0; i<strExpr.length; i++) {
						result[idx++] = BRANCO + strExpr[i];
					}
					result[idx] = "\\end{schema}";
				}
				// IMPRESSAO EM UNICODE
				else {
					String strUP = SchemaUtils.StringSchemaUP(strExpr, declName.getWord());
					String strDOWN = SchemaUtils.StringSchemaDOWN(strExpr, declName.getWord());

					result[0] = strUP;
					int idx = 1;
					for(int i=0; i<strExpr.length; i++) {
						if (strExpr[i].startsWith("\\where")){
							result[idx++] = SchemaUtils.StringSchemaCENTER(strExpr, declName.getWord());
						}
						else {
							result[idx++] = SchemaString.LATERALBAR + BRANCO + strExpr[i];
						}
					}
					result[idx] = strDOWN;
				}

			}
			else {

				String[] strDecls = (String[])decl.accept(declPrint());
				if (resTemp == null) {
					resTemp = new String[strDecls.length];
					for (int i =0; i < strDecls.length; i++){
						resTemp[i] = strDecls[i];
					}
				}
				else{
					String[] strTemp = new String[resTemp.length + strDecls.length];
					int index2 = 0;
					for(int i=0; i<resTemp.length; i++) {
						strTemp[index2++] = resTemp[i];
					}
					for(int i=0; i<strDecls.length; i++) {
						strTemp[index2++] = strDecls[i];
					}
					resTemp = strTemp;
				}
			}	

		}

		if (resTemp != null && pred == null) {
			result = new String[resTemp.length];
			for (int i = 0;i < resTemp.length;i++) {
				result[i] = resTemp[i];
			}
		}
		else if (resTemp!= null && pred!= null) {
			result = new String[resTemp.length + strPred.length + 1];
			for (int i = 0;i < resTemp.length;i++) {
				result[index++] = resTemp[i];
			}
			if (!getUnicoded())
				result[index++] = "\\where";
			else
				result[index++] = CircusString.VDASH;
			for(int i=0; i<strPred.length; i++) {
				result[index++] = strPred[i];
			}
		}

		return result;
	}



	public Object visitLatexMarkupPara(LatexMarkupPara term) {
		String[] aux = new String[1];
		aux[0] = "";
		return aux;
	}


	/**
	 * Operator Template visitor
	 * Exemplo:
	 * \begin{zed}
	 * \relation (\_ \inseq \_)
	 * \end{zed}
	 * 
	 * C.4.13- ZStandard
	 */
	public Object visitOptempPara(OptempPara term) {

		String[] result = null;

		int linhaInicial = this.getCounterRow();

		/* CAT = function | generic | relation
		 * & PREC*/

		String cat = "";
		String prec = "";

		if (term.getCat().equals(Cat.Function))
		{
			cat = "\\fuction";
			prec = term.getPrec().toString();
			if(getUnicoded()){
				cat = ZString.FUNCTION;
			}
		}	
		else if (term.getCat().equals(Cat.Generic))
		{
			cat = "\\generic";
			prec = term.getPrec().toString();
			if(getUnicoded()){
				cat = ZString.GENERIC;
			}
		}
		else if (term.getCat().equals(Cat.Relation))
		{
			cat = "\\relation";
			if(getUnicoded()){
				cat = ZString.RELATION;
			}
		}


		/* ASSOCIATION */
		String assoc = "";
		if (term.getAssoc() != null) {
			if (term.getAssoc().equals(Assoc.Left)){
				assoc = ZString.LEFTASSOC;
			}
			else if(term.getAssoc().equals(Assoc.Right)){
				assoc = ZString.RIGHTASSOC;
			}
			if (getUnicoded() ){
				assoc = "\\" + assoc;
			}
		}
		String oper = "";
		/* OPERATORS */
		for (Oper op : term.getOper()){
				oper += ((String[])op.accept(OperPrint()))[0];
		}

		if (getUnicoded()){
			result = new String[1];
			result[0] = BRANCO + cat + Space + oper;
			if (!prec.equals("")){
				result[0] =  BRANCO + cat + Space + prec + Space + oper;
			}
		}
		else{
			result = new String[3];
			result[1] = cat + Space + oper;
			if (!prec.equals("")){
				result[1] = BRANCO + cat + Space + prec + Space + oper;
			}
			result[0] = "\\begin{zed}";
			result[2] = "\\end{zed}";
		}

		int length = result.length;

		NoPrograma noProg = new NoPrograma(term);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);

		this.setCounterRow(length +  linhaInicial + 1);


		return result;
	}




}
