package circusRefine.core.print;

import java.util.LinkedList;

import javax.swing.JOptionPane;

import circusRefine.core.astmodifiers.IASTModifierAnn;
import circusRefine.core.astmodifiers.ActionArgumentAnn;

import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.visitor.ZExprListVisitor;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.visitor.JokerExprListVisitor;

/**
 * Visitor que imprime as correspondentes JokerExprList e ZExprList
 * @author Alessandro
 *
 */
public class ExprListPrint extends
Print
implements ZExprListVisitor,
JokerExprListVisitor{

	public ExprListPrint(Printer printer) {
		super(printer);
	}

	public Object visitZExprList(ZExprList term) {

		String[] result = new String[1];
		result[0] = "( )";

		int size = term.size();
		int counter = 0;

		LinkedList<String> strExprList = new LinkedList<String>();


		for(Expr expr : term) {
			String[] newExpr = (String[])expr.accept(exprPrint());
			if (counter < size -1 ) {
				newExpr[newExpr.length-1] += ", ";
			}
			for (int j=0;j< newExpr.length;j++){
				strExprList.add(newExpr[j]);
			}
			counter++;
		}
		if (strExprList.size() > 0){
			result = new String[strExprList.size()];
			for (int k=0; k< strExprList.size();k++) {
				result[k] = strExprList.get(k);
			}
		}

		return result;


	}

	public Object visitJokerExprList(JokerExprList term) {
		String[] result = new String[1];
		result[0] = term.getName();
		return result;
	}

}
