/*
 * ActionPrint.java
 *
 * Created on 13 de Setembro de 2005, 17:13
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.List;


import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circus.visitor.Action1Visitor;
import net.sourceforge.czt.circus.visitor.Action2Visitor;
import net.sourceforge.czt.circus.visitor.ActionDVisitor;
import net.sourceforge.czt.circus.visitor.ActionIteVisitor;
import net.sourceforge.czt.circus.visitor.AlphabetisedParallelActionIteVisitor;
import net.sourceforge.czt.circus.visitor.BasicActionVisitor;
import net.sourceforge.czt.circus.visitor.CallActionVisitor;
import net.sourceforge.czt.circus.visitor.ChaosActionVisitor;
import net.sourceforge.czt.circus.visitor.CircusActionVisitor;
import net.sourceforge.czt.circus.visitor.CircusCommandVisitor;
import net.sourceforge.czt.circus.visitor.GuardedActionVisitor;
import net.sourceforge.czt.circus.visitor.HideActionVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveActionIteVisitor;
import net.sourceforge.czt.circus.visitor.MuActionVisitor;
import net.sourceforge.czt.circus.visitor.ParActionIteVisitor;
import net.sourceforge.czt.circus.visitor.ParallelActionIteVisitor;
import net.sourceforge.czt.circus.visitor.ParamActionVisitor;
import net.sourceforge.czt.circus.visitor.PrefixingActionVisitor;
import net.sourceforge.czt.circus.visitor.SchExprActionVisitor;
import net.sourceforge.czt.circus.visitor.SkipActionVisitor;
import net.sourceforge.czt.circus.visitor.StopActionVisitor;
import net.sourceforge.czt.circus.visitor.SubstitutionActionVisitor;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZRenameList;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.visitor.JokerActionVisitor;
import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;

/**
 *
 * @author alessandro
 */
public class ActionPrint 
extends Print
implements CircusActionVisitor,
Action1Visitor,
Action2Visitor,
SchExprActionVisitor,
BasicActionVisitor,
CallActionVisitor,
ChaosActionVisitor,
SkipActionVisitor,
StopActionVisitor,
ActionDVisitor,
MuActionVisitor,
PrefixingActionVisitor,
SubstitutionActionVisitor,
GuardedActionVisitor,
HideActionVisitor,
ActionIteVisitor,
ParamActionVisitor,
ParActionIteVisitor,
AlphabetisedParallelActionIteVisitor,
InterleaveActionIteVisitor,
ParallelActionIteVisitor,
CircusCommandVisitor,
JokerActionVisitor{

	/** Creates a new instance of ActionPrint */
	public ActionPrint(Printer printer) {
		super(printer);
	}

	public Object visitCircusAction(CircusAction term)
	{
		return term.accept(this);
	}

	//ok
	public Object visitAction1(Action1 term)
	{
		return term.getCircusAction().accept(this);
	}
	//ok
	public Object visitAction2(Action2 term)
	{
		getPercurso().append("Action2\n");
		String[] result = null;

		int index = 0;
		int linhaInicial = this.getCounterRow();

		String[] strActL = (String[])term.getLeftAction().accept(this);

		this.addCounterRow(1); 
		//Como o "\\extchoice" encontra-se ao meio dos outros termos o incremento
		// o incremento so podera ser realizado apos o visit da primeira parte

		String[] strActR = (String[])term.getRightAction().accept(this);

		
		
		result = new String[strActL.length + strActR.length + 1];

		for(int i=0; i<strActL.length; i++) {
			result[index++] = BRANCO + strActL[i];
		}
		result[index] = ((String[])term.accept(action2Print()))[0];
		getPercurso().append(result[index] + "\n")  ;
		index++;
		for(int i=0; i<strActR.length; i++) {
			result[index++] = BRANCO + strActR[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term, 
				this.isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);


		return result;
	}

	//ok
	public Object visitCallAction(CallAction term)
	{
		String[] result = new String[1];
		int linhaInicial = this.getCounterRow();
		
		int adder = 0;
		getPercurso().append("CallAction\n");
		getPercurso().append("linha inicial "  + linhaInicial + "\n");
		result[0] = ((String[])term.getName().accept(namePrint()))[0];
		String str = ((String[])term.getExprList().accept(exprListPrint()))[0];

		if (result[0].startsWith(CircusUtils.DEFAULT_IMPLICIT_PROCESS_NAME_PREFIX.substring(0, 2))){
			result[0] = "Implicit Action" + result[0].charAt(result[0].length()-1);
		}
		if(str != null && str!= "( )") {
			result[0] = result[0] + str;
		}
		getPercurso().append(result[0]+ "\n");
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial + adder);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				this.isToInsertingRelAnn());
		getPercurso().append("linha depois "  + this.getCounterRow() + "\n");
		addRelacionamento(rel);

		return result;
	}

	public Object visitSchExprAction(net.sourceforge.czt.circus.ast.SchExprAction term)
	{
		getPercurso().append("SchExprAction\n");
		int linhaInicial = this.getCounterRow();
		String[] result = (String[])term.getExpr().accept(exprPrint());

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);


		return result;
	}
	//ok
	public Object visitBasicAction(net.sourceforge.czt.circus.ast.BasicAction term)
	{ 
		getPercurso().append("BasicAction\n");
		return term.accept(this);
	}
	//ok
	public Object visitChaosAction(net.sourceforge.czt.circus.ast.ChaosAction term)
	{ 
		getPercurso().append("ChaosAction\n");
		String[] result = new String[1];
		result[0] = "\\Chaos";
		if(getUnicoded()) {
			result[0] = CircusString.CIRCCHAOS;
		}
		int linhaInicial = this.getCounterRow();

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial );

		addRelacionamento(rel);
		return result;
	}
	//ok
	public Object visitSkipAction(net.sourceforge.czt.circus.ast.SkipAction term)
	{
		String[] result = new String[1];
		getPercurso().append("SkipAction\n");
		result[0] = "\\Skip";
		if (getUnicoded()){
			result[0] = CircusString.CIRCSKIP;
		}
		int linhaInicial = this.getCounterRow();

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial );

		addRelacionamento(rel);

		return result;
	}
	//ok
	public Object visitStopAction(net.sourceforge.czt.circus.ast.StopAction term)
	{
		getPercurso().append("StopAction\n");
		String[] result = new String[1];
		result[0] = "\\Stop";
		if (getUnicoded()) {
			result[0] = CircusString.CIRCSTOP;
		}
		int linhaInicial = this.getCounterRow();

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial );

		addRelacionamento(rel);

		return result;
	}

	//ok
	public Object visitActionD(net.sourceforge.czt.circus.ast.ActionD term)
	{
		getPercurso().append("ActionD\n");
		return term.accept(this);
	}
	//ok
	public Object visitMuAction(net.sourceforge.czt.circus.ast.MuAction term)
	{
		getPercurso().append("MuAction\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];

		String name = ((String[])term.getName().accept(namePrint()))[0];

		if (!getUnicoded())
			result[0]  = "\\circmu " + name + " \\circspot ";
		else
			result[0]  = CircusString.CIRCMU + Space + name + 
			Space + ZString.SPOT + Space;

		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
			
		}
		
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial  );
		getPercurso().append(this.getCounterRow());
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());
		addRelacionamento(rel);

		return result;
	}
	//ok
	public Object visitPrefixingAction(net.sourceforge.czt.circus.ast.PrefixingAction term)
	{
		getPercurso().append("PrefixingAction\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1); // Incrimenta a Linha Inicial das Classes Filhas em 1;
		

		String[] strComm = (String[])term.getCommunication().accept(communPrint());
		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strComm.length + strAct.length];

		int index = 0;
		for(int i=0; i<strComm.length; i++) {
			result[index++] = strComm[i];
		}
		index--;
		if (!getUnicoded()) {
			result[index] = result[index] + Space + "\\then" + Space;
		}
		else {
			result[index] = result[index] + Space + CircusString.CIRCTHEN + Space;
		}

		index++;

		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		addRelacionamento(rel);
		this.addCounterRow(length - 1);

		this.setCounterRow(length +  linhaInicial);

		return result;
	}
	//ok
	public Object visitSubstitutionAction(net.sourceforge.czt.circus.ast.SubstitutionAction term)
	{
		getPercurso().append("SubstitutionAction\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();

		int index = 1;
		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];
		result[0] = "(" + strAct[0];
		for(int i=1; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		index--;
		result[index] = result[index] + ")";

		ZRenameList NewOldNames = term.getZRenameList().getNewOldPair();
		String strOld = "";
		String strRename = "";
		//TODO testar
		for(Term name : NewOldNames) {
			strRename = strRename + name.accept(exprPrint());
		}

		index++;
		//result[index] = "[" + strOld + ":=" + strNew + "]";
		result[index] = "[" + strRename + "]";

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		addRelacionamento(rel);
		this.addCounterRow(length - 1);


		return result;
	}
	//ok
	public Object visitGuardedAction(net.sourceforge.czt.circus.ast.GuardedAction term)
	{
		getPercurso().append("GuardedAction\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1); // Incrimenta a Linha Inicial das Classes Filhas em 1;

		int index = 0;
		String[] strPred = (String[])term.getPred().accept(predPrint());	  
		String[] strAct = (String[])term.getCircusAction().accept(this);

		result = new String[strPred.length + strAct.length];

		if (strPred.length > 1) {
			if (!getUnicoded())
				result[0] = "\\lcircguard"  + Space + strPred[0];
			else
				result[0] = CircusString.LCIRCGUARD  + Space + strPred[0];

			for(int i=1; i<strPred.length; i++) {
				result[index++] = strPred[i];
			}

			index--;
			if (!getUnicoded())
				result[index] = result[index] + Space + "\\rcircguard"  
				+Space + "\\circguard" + Space;
			else
				result[index] = result[index] + Space + CircusString.RCIRCGUARD  
				+Space + ZString.AMP + Space;

			index++;
		}
		else {
			if (!getUnicoded())
				result[0] = "\\lcircguard" + Space + strPred[0] 
				                                             + Space + "\\rcircguard" + Space + "\\circguard" + Space;
			else
				result[0] = CircusString.LCIRCGUARD + Space + strPred[0] 
				                                                      + Space + CircusString.RCIRCGUARD + Space + ZString.AMP + Space;
			index = 1;
		}

		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);
		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);;

		return result;
	}
	//ok
	public Object visitHideAction(net.sourceforge.czt.circus.ast.HideAction term)
	{	
		getPercurso().append("HideAction\n");
		String[] result = null;
		int index = 1;
		int linhaInicial = this.getCounterRow();    

		String[] strAct = (String[])term.getCircusAction().accept(this);
		ChannelSet aux = term.getChannelSet();
		String[] strCS = (String[])aux.accept(exprPrint());
		result = new String[strAct.length + strCS.length ];

		result[0] = "(" + strAct[0];

		for(int i=1; i<strAct.length; i++) {
			result[index++] = strAct[i];
		}
		if(!getUnicoded())
			result[index] = ")" + Space + "\\circhide" + Space + strCS[0];
		else{
			result[index] = ")" + Space + CircusString.ZHIDE + Space + strCS[0];
		}
		index++;

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}
	//ok
	public Object visitActionIte(net.sourceforge.czt.circus.ast.ActionIte term)
	{
		getPercurso().append("ActionIte\n");
		String[] result = null;
		String strDecls = "";
		int linhaInicial = this.getCounterRow();

		if (term.getDeclList() instanceof JokerDeclList) {
			JokerDeclList jokersDecl = (JokerDeclList) term.getDeclList();
			strDecls = jokersDecl.getName();
		}
		else if (term.getDeclList() instanceof ZDeclList) {
			List<Decl> decls = term.getZDeclList();

			int size = decls.size();
			int counter = 0;
			for(Decl decl : decls) {
				strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
				if(counter < size-1) {
					strDecls = strDecls + ";";
				}
				counter++;
			}
		}

		this.addCounterRow(1); //devido as visitas as declara��es
		String[] strAct = (String[])term.getCircusAction().accept(this);

		result = new String[strAct.length + 1];
		String symbol = ((String[])term.accept(actionItePrint()))[0];
		if (!getUnicoded())
			result[0] = symbol + Space + strDecls + Space + "\\circspot" + Space;
		else
			result[0] = symbol + Space + strDecls 
			+ Space + ZString.SPOT + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());
		this.setCounterRow(length +  linhaInicial);

		return result;
	}
	//ok
	public Object visitParamAction(net.sourceforge.czt.circus.ast.ParamAction term)
	{
		getPercurso().append("ParamAction\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();

		List<Decl> decsLaw = term.getZDeclList();
		String strDec = "";
		int size = decsLaw.size();
		int counter = 0;
		for(Decl vDec: decsLaw) {
			strDec = strDec + ((String[])vDec.accept(declPrint()))[0];
			if(counter < size-1) {
				strDec = strDec + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusAction().accept(this);

		result = new String[strAct.length + 2];
		if (!getUnicoded())
			result[0] = "(" + strDec + Space + "\\circspot" + Space;
		else
			result[0] = "(" + strDec + Space + ZString.SPOT + Space;;
			int index = 1;
			for(int i=0; i<strAct.length; i++) {
				result[index++] = BRANCO + strAct[i];
			}
			result[index] = ")";

			NoPrograma noProg = new NoPrograma(term);
			int length = result.length;
			Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
			addRelacionamento(rel);

			RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term
					,isToInsertingRelAnn());

			this.setCounterRow(length +  linhaInicial);

			return result;
	}
	//n�o existe!!
	public Object visitParActionIte(net.sourceforge.czt.circus.ast.ParActionIte term)
	{
		getPercurso().append("ParActionIte\n");
		String[] result = new String[1];
		result[0] = "TERMO NAO EXISTE";
		return result;
	}

	//ok
	public Object visitAlphabetisedParallelActionIte(net.sourceforge.czt.circus.ast.AlphabetisedParallelActionIte term)
	{
		getPercurso().append("AlphabetisedParallelActionIte\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}
		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];
		String strNS = ((String[])term.getNameSet().accept(exprPrint()))[0];
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];

		result[0] = "\\Parallel " + strDecls + " \\circspot " + "\\lpar " + strNS + " | " + strCS + " \\rpar";
		if (!getUnicoded())
			result[0] = "\\Parallel" + Space + strDecls + Space + "\\circspot" + Space + "\\lpar"+ Space + strNS
			+ Space + "|" + Space + strCS + Space + "\\rpar";
		else
			result[0] = CircusString.REPPARALLEL + Space + strDecls + Space + ZString.SPOT
			+ Space + CircusString.LPAR + Space + strNS + Space + "|" + Space + strCS + Space + CircusString.RPAR;

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());
		this.setCounterRow(length +  linhaInicial);



		return result;
	}
	//ok
	public Object visitInterleaveActionIte(net.sourceforge.czt.circus.ast.InterleaveActionIte term)
	{
		getPercurso().append("InterleaveAction\n");
		String[] result = null;
		int linhaInicial = this.getCounterRow();

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusAction().accept(this);
		String strNS = ((String[])term.getNameSet().accept(exprPrint()))[0];
		result = new String[strAct.length + 1];
		if (!getUnicoded())
			result[0] = "\\Interleave" + Space + strDecls + Space + "\\circspot"+ Space 
			+ "\\linter" + Space + strNS + Space + "\\rinter";
		else
			result[0] = CircusString.REPINTERLEAVE + Space + strDecls + Space + CircusString.SPOT + Space 
			+ CircusString.LINTER + Space + strNS + Space + CircusString.RINTER;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());
		this.setCounterRow(length +  linhaInicial);

		return result;
	}
	//ok
	public Object visitParallelActionIte(net.sourceforge.czt.circus.ast.ParallelActionIte term)
	{
		getPercurso().append("ParallelActionIte\n");
		String[] result = null;
		int linhaInicial = this.getCounterRow();

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusAction().accept(this);
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		String strNS = ((String[])term.getNameSet().accept(exprPrint()))[0];
		result = new String[strAct.length + 1];
		if (!getUnicoded())
			result[0] = "\\lpar" + Space + strCS + Space + "\\rpar" + Space + strDecls 
			+ Space + "\\circspot" + Space + "\\lpar" + Space + strNS + Space + "\\rpar";
		else
			result[0] = CircusString.LPAR + Space + strCS + Space + CircusString.RPAR + Space + strDecls 
			+ Space + ZString.SPOT +Space + CircusString.LPAR + Space + strNS + Space 
			+ CircusString.RPAR;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}


		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());
		this.setCounterRow(length +  linhaInicial);

		return result;
	}

	public Object visitCircusCommand(net.sourceforge.czt.circus.ast.CircusCommand term)
	{
		getPercurso().append("CircusCommand\n");
		return term.accept(commandPrint());
	}

	public Object visitJokerAction(JokerAction term) {

		getPercurso().append("JokerAction\n");
		String[] result = new String[1];
		result[0] = term.getName();


		return result;
	}

}
