/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.syntacticfunctions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.BasicChannelSetExpr;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.visitor.CallActionVisitor;
import net.sourceforge.czt.circus.visitor.CircusActionVisitor;
import net.sourceforge.czt.circus.visitor.HideActionVisitor;
import net.sourceforge.czt.circus.visitor.PrefixingActionVisitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ZName;
import circusRefine.core.util.ChildrenTermExtractor;

/**
 * Classe utilizada para aplicar a fun��o usedC (used channels of an 
 * action). Pode funcionar em dois modos de opera��o: Pegar apenas os
 * canais vis�veis, ou ent�o pegar todos os canais utilizados 
 * (vis�veis ou n�o) 
 * 
 * @author Cristiano Castro
 */
public class UsedChannelsApplier 
extends SyntacticFunctionApplier<CircusAction, Expr> {

	/**
	 * Estabelece o modo de opera��o:
	 * <code>true</code> --> Apenas os canais vis�veis
	 * <code>false</code> --> todos os canais utilizados 
	 */
	private boolean onlyVisible = true;

	/**
	 * @return o identificador do modo de opera��o do m�todo
	 */
	private boolean isOnlyVisible() {
		return onlyVisible;
	}

	/**
	 * 
	 */
	public Expr apply(CircusAction args) throws CannotEvaluateException {
		Set<ZName> conjunto = this.getUsedChannels(args);
		return this.transformarRepresentacaoConjuntoNomes(conjunto);
	}

	/**
	 * Captura os nomes das vari�veis utilizadas no canal de acordo 
	 * com o modo de opera��o da fun��o.
	 * 
	 * @param args a a��o a ser avaliada
	 * @return o conjunto de nomes (no estilo JAVA) com os canais
	 * @throws CannotEvaluateException
	 */
	public Set<ZName> getUsedChannels(CircusAction args) 
	throws CannotEvaluateException {
		try {
			UsedChannelsVisitor visitor = new UsedChannelsVisitor();
			return args.accept(visitor);
		} catch (RuntimeException e) {
			throw new CannotEvaluateException(e);
		}
	}

	protected class UsedChannelsVisitor 
	implements TermVisitor<HashSet<ZName>>, CircusActionVisitor<HashSet<ZName>>, 
	PrefixingActionVisitor<HashSet<ZName>>, HideActionVisitor<HashSet<ZName>>{
	//CallActionVisitor<HashSet<ZName>> {
	

		/**
		 * Percorre uma lista de termos procurando
		 * 
		 * @param arg0 a lista de termos a ser visitada
		 * @return o conjunto de nomes de canais
		 */
		public HashSet<ZName> visitTerm(Term arg0) {
			HashSet<ZName> result = new HashSet<ZName>();
			List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);
			
			for (Term filho : filhos) {
				result.addAll(filho.accept(this));
			}
			
			return result;
		}

		/**
		 * Percorre a a��o vendo quais canais foram utilizados
		 * 
		 * @param arg0 a a��o a ser percorrida
		 * @return o conjunto dos nomes dos canais utilizados
		 */
		public HashSet<ZName> visitCircusAction(CircusAction arg0) {
			HashSet<ZName> result = new HashSet<ZName>();

			List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);

			for (Term filho : filhos) {

				/* Visita se e somente se for uma a��o */
				result.addAll(filho.accept(this));
			}

			/* Retorna os canais utilizados na fun��o */
			return result;
		}

		/**
		 * Acha e monta o conjunto de canais utilizados pela a��o com
		 * prefixo
		 * 
		 * @param arg0 a a��o prefixada por um canal
		 * @return o conjunto unit�rio contendo o nome do canal 
		 *  utilizado na a��o prefixada
		 * @throws UnsupportedAstClassException se o nome do canal n�o
		 *  for uma inst�ncia de um {@link ZName}.
		 */
		public HashSet<ZName> visitPrefixingAction(PrefixingAction arg0) {

			/* Captura o nome do canal */
			ZName nomeCanal = getNameOfACommunication(arg0.getCommunication());

			/* Adiciona nome canal ao conjunto resultado */
			HashSet<ZName> result = new HashSet<ZName>();
			result.add(nomeCanal);
			
			/* Adicionando canais da a��o interna */
			result.addAll(arg0.getCircusAction().accept(this));
			
			return result;
		}

		/**
		 * Visita uma opera��o de Hide. A funcionalidade desse m�todo 
		 * ir� depender do modo de opera��o do algoritmo. Caso o modo
		 * de opera��o for de apenas vari�veis vis�veis, ent�o os 
		 * canais escondidos pelo {@link HideAction} n�o ser�o mais
		 * consideradas como canais utilizados
		 * 
		 * @param arg0 a {@link HideAction} a ser visitada
		 * @return o conjunto de nomes de canais utilizados, de acordo
		 *  com o modo de opera��o da fun��o
		 */
		public HashSet<ZName> visitHideAction(HideAction arg0) {
			HashSet<ZName> result;

			if (isOnlyVisible()) {

				/* 
				 * Retira do conjunto de canais utilizados, os canais
				 * escondidos pela HideAction
				 */
				result = arg0.getCircusAction().accept(this);
				CircusChannelSet cs = (CircusChannelSet) arg0.getChannelSet();
				BasicChannelSetExpr conjuntoCanais = 
					(BasicChannelSetExpr) cs.getExpr();
				Set<ZName> escondidos = capturarNomesCanais(conjuntoCanais);

				/* Efetua a subtra��o dos conjuntos */
				result.removeAll(escondidos);

			} else {

				/* 
				 * Se o modo de opera��o n�o for de apenas vari�veis 
				 * vis�veis, ent�o a a��o ao visita o HideAction
				 * nenhuma opera��o especial � realizada 
				 */
				result = this.visitCircusAction(arg0);
			}
			return result;
		}

		/**
		 * N�o tem como avaliar os canais utilizados de uma 
		 * {@link CallAction}
		 * 
		 * @param arg0 a a��o a ser visitada
		 * @throws CannotEvaluateRunTimeException porque uma 
		 *  refer�ncia a uma a��o n�o pode ser avaliada
		 */
	//	public HashSet<ZName> visitCallAction(CallAction arg0) {
	//		HashSet<ZName> result;
		//	System.out.println("Não pode aplicar" +  arg0);
		//	throw new CannotEvaluateRunTimeException("N�o pode aplicar usedC " +
		//			"a CallAction " + arg0);
			//result = arg0.g
			
	//	}
		
	}

}
