/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.setoperators;

import java.util.Set;

import net.sourceforge.czt.z.ast.Expr;
import circusRefine.core.opsdischarge.syntacticfunctions.CannotEvaluateException;

/**
 * Aplica o operador est contido ou  igual 
 * 
 * @author Cristiano Castro
 *
 */
public class SubseteqApplier extends OperadorBinarioConjuntos<Boolean> {

	/**
	 * Aplica o operador de est contido aos parmetros
	 * 
	 * @param c1 o primeiro parmetro da operao
	 * @param c2 o segundo parmetro da operao
	 * @return <code>true</code> se e somente se o conjunto c1 est 
	 *  contido em c2. 
	 */
	public Boolean apply(Expr c1, Expr c2) throws CannotEvaluateException {
		Set<Expr> conj1 = SubseteqApplier.transformarRepresentacao(c1);
		Set<Expr> conj2 = SubseteqApplier.transformarRepresentacao(c2);
		boolean resultado = conj2.containsAll(conj1);
		return resultado;
	}

}
