/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.setoperators;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circus.ast.BasicChannelSetExpr;
import net.sourceforge.czt.circus.ast.CircusCommunicationList;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.impl.SchExprImpl;
import circusRefine.core.opsdischarge.NormalASTForComparisonGenerator;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.core.opsdischarge.syntacticfunctions.CannotEvaluateException;
import circusRefine.core.print.Printer;

/**
 * Classe abstrata pai de todas os operadores bin�rios de conjuntos
 * 
 * @author Cristiano Castro
 */
public abstract class OperadorBinarioConjuntos<T> {

	/**
	 * M�todo para transforma a respresenta��o de um conjunto de 
	 * express�es de um formato da AST de circus para o formato
	 * JAVA
	 *  
	 * @param c o conjunto a ser analisado
	 * @return a express�o em JAVA q representa o conjunto
	 * @throws UnsupportedAstClassException se c for um 
	 *  {@link SetExpr} e n�o encapsular uma {@link ZExprList}
	 * @throws UnsupportedAstClassException caso c dor um
	 *  {@link BasicChannelSetExpr} e n�o encapsular uma 
	 *  {@link CircusCommunicationList}
	 */
	public static HashSet<Expr> transformarRepresentacao(Expr c) 
		throws CannotEvaluateException {
		HashSet<Expr> result = new HashSet<Expr>();
		if (c instanceof SetExpr) {
			result.addAll(((SetExpr) c).getZExprList());
		} else if (c instanceof BasicChannelSetExpr) {
			
			/* 
			 * Se for um conjunto de canais, pega todos os nomes 
			 * de canais 
			 */
			for (Communication comm : 
				((BasicChannelSetExpr) c).getCircusCommunicationList()) {
				result.add(comm.getChannelExpr());
			}
			
		} else if (c instanceof RefExpr) {
			
			/* V� se � uma inst�ncia de emptyset */
		} else {
			
			throw new CannotEvaluateException("Express�o " + c + " n�o " +
					"referencia um conjunto v�lido");
		}
		
		/* Gera a forma normal dos termos */
		HashSet<Expr> aRetornar = new HashSet<Expr>();
		for (Expr expressao : result) {
			aRetornar.add((Expr) 
					NormalASTForComparisonGenerator.gerarFormaNormal(expressao));
		}
		
		return aRetornar;
	}
	
	/**
	 * M�todo utilizado para transformar a representa��o de um 
	 * conjunto no formato JAVA para um formato de acordo com a AST de
	 * Circus
	 * 
	 * @param c o conjunto em formato JAVA para ser transformado
	 * @return o conjunto no formato AST de circus
	 */
	public static Expr tranformarRepresentacao(Set<Expr> c) {
		Expr result;
		if (!c.isEmpty()) {
			CircusPatternFactory factory = new CircusPatternFactoryImpl();
			ZExprList lista = factory.createZExprList();
			lista.addAll(c);
			result = factory.createSetExpr(lista);
		} else {
			result = OPsDischargeUtils.criarConjuntoVazio();
		}
		return result;
	}
	
	/**
	 * Aplica o operador bin�rio sobre uma tupla
	 * 
	 * @param tupla a tupla de elementos que � o argumento do 
	 *  operador bin�rio
	 * @return o resultado do operador bin�rio
	 * @throws CannotEvaluateException caso a lista encapsulada pela
	 *  tupla n�o seja uma inst�ncia de uma {@link ZExprList}
	 * @throws CannotEvaluateException caso os argumentos da tupla n�o
	 *  forem inst�ncia de {@link SetExpr}
	 * @throws CannotEvaluateException caso a tupla n�o tenha o n�mero
	 *  exato de elementos
	 */
	public T apply(TupleExpr tupla) throws CannotEvaluateException {
		try {
			ZExprList args = tupla.getZExprList();
			NameList n;
			Expr e;
			/*for (Expr expr : args) {
				Expr e = (Expr) expr;
			}*/
			if (args.get(0) instanceof ZSchText){
				ZSchText text = (ZSchText) args.get(0);
				ZDeclList listZD = text.getZDeclList();
				for (Decl decl : listZD) {
					VarDecl var = (VarDecl) decl;
					var.getExpr();
					e = (Expr) var.getNameList();
				}
			}
			
			if (args.get(0) instanceof SchExprImpl){
				System.out.println("teste");
			}
			//if (n!=null)
			return this.apply(args.get(0), args.get(1)); 
		} catch (UnsupportedAstClassException e) {
			throw new CannotEvaluateException(e);
		} catch (ClassCastException e) {
			throw new CannotEvaluateException(e);
		} catch (IndexOutOfBoundsException e) {
			throw new CannotEvaluateException(e);
		}
	}

	/**
	 * Aplica o operador bin�rio sobre uma tupla
	 * 
	 * @param tupla a tupla de elementos que � o argumento do 
	 *  operador bin�rio
	 * @return o resultado do operador bin�rio
	 * @throws CannotEvaluateException caso o argumento n�o seja 
	 *  uma tupla
	 * @see #apply(TupleExpr)
	 */
	public T apply(Expr tupla) throws CannotEvaluateException {
		try {
			return this.apply((TupleExpr) tupla);
		} catch (ClassCastException e) {
			throw new CannotEvaluateException(e);
		}
	}
	
	/**
	 * Aplica o operador bin�rio
	 * 
	 * @param c1 o primeiro par�metro
	 * @param c2 o segundo par�metro
	 * @return o resultado da opera��o
	 */
	public abstract T apply(Expr c1, Expr c2) throws CannotEvaluateException;
	
}
