/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc1@gmail.com>
 */
package circusRefine.core.opsdischarge;

import circusRefine.core.crules.utils.NormalASTGenerator;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.ZNameVisitor;

/**
 * Classe para gerar uma "forma normal" da AST, til quando for comparar 
 * termos
 * 
 * @author Cristiano Castro
 */
public class NormalASTForComparisonGenerator extends NormalASTGenerator 
implements ZNameVisitor<Term> {

	/**
	 * Gera uma forma normal da AST passada como parmetro. til para
	 * a resoluo de OPs
	 * 
	 * @param ast1 a AST a ter a forma normal gerada
	 */
	public static Term gerarFormaNormal(Term ast1) {
		NormalASTForComparisonGenerator visitor = 
			new NormalASTForComparisonGenerator();
		return ast1.accept(visitor);
	}
	
	/**
	 * Os IDs do ZName recebem a string vazia
	 * 
	 * @param o ZName a ser visitado
	 */
	public Term visitZName(ZName arg0) {
		arg0.setId("");
		return arg0;
	}

}
