package circusRefine.core.idt;

import circusRefine.util.Identificador;

/*
 * Classe utilizada para inserir os identificadores de comentario no
 * arquivo gerado, assim apresenta um contador que informa o numero de coletas
 * que o termo em que foi inserido esse comentario sofreu antes de ter seu
 * comentario inserido.
 */
public class IdtCommentAnn extends IdtAnn {
	
	private Integer contadorColetas;
	private Integer contadorColetasAux;
	private boolean jaVisitado = false;
	
	public IdtCommentAnn(int x, int cont) {
		super(x,Identificador.COMENTARIO);
		contadorColetas = cont;
		contadorColetasAux = cont;
	}
	public Integer getContadorColetas() {
		return contadorColetas;
	}
	public boolean foiVisitado() {
		return jaVisitado;
	}
	public void decrContador () {
		contadorColetas--;
	}
	public void setJaVisitado(boolean jaVisitado) {
		this.jaVisitado = jaVisitado;
	}
	public void reatualizar(){
		contadorColetas = contadorColetasAux;
	}

}
