/*
 * Projeto: Circus Refine
 */
package circusRefine.core.finder;

import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.impl.ListTermImpl;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.visitor.ProcessParaVisitor;

/**
 * Visitor para procurar {@link ProcessPara} em uma AST. 
 * 
 * @author Cristiano Gurgel
 */
// TODO comentar esta classe
public class ProcessParaFinder implements TermVisitor<ListTerm<ProcessPara>>, 
		ProcessParaVisitor<ListTerm<ProcessPara>> {

	public ProcessParaFinder() { }
	
	
	/**
	 * Retorna uma Lista com as {@link ActionPara} da AST
	 * 
	 * @param term a AST
	 * @return uma lista com as aes
	 */
	public static List<ProcessPara> getProcessPara(Term term) {
		ProcessParaFinder finder = new ProcessParaFinder();
		return term.accept(finder);
	}
	
	/**
	 * 
	 */
	public ListTerm<ProcessPara> visitTerm(Term termo) {
		ListTerm<ProcessPara> result = new ListTermImpl<ProcessPara>();
		ChildrenTermExtractor extrator = new ChildrenTermExtractor();
		
		/* Adiciona a lista dos filhos */
		for (Term filho : termo.accept(extrator)) {
			result.addAll(filho.accept(this));
		}
		
		return result;
	}

	/**
	 * 
	 */
	public ListTerm<ProcessPara> visitProcessPara(ProcessPara termo) {
		ListTerm<ProcessPara> lista = new ListTermImpl<ProcessPara>();
		lista.add(termo);
		return lista;
	}

}
