/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CircusNameSet;
import net.sourceforge.czt.circus.visitor.CallActionVisitor;
import net.sourceforge.czt.circus.visitor.CallProcessVisitor;
import net.sourceforge.czt.circus.visitor.CircusChannelSetVisitor;
import net.sourceforge.czt.circus.visitor.CircusNameSetVisitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.anotations.CopyRuleForNameAnn;
import circusRefine.core.util.ChildrenTermExtractor;
import circusRefine.util.Pair;

/**
 * Classe utilizada para recuperar o termo definido a partir de um 
 * nome
 * 
 * @author Cristiano Castro
 */
public class TermFromANameGetter implements CircusChannelSetVisitor<Term>, 
	CallActionVisitor<Term>, CircusNameSetVisitor<Term>, 
	CallProcessVisitor<Term>, RefExprVisitor<Term>, TermVisitor<Term> {

	/**
	 * Retorna o termo o qual o nome se refere
	 * 
	 * @param nome o nome a ser pesquisado
	 * @param ast a ast no qual o nome ser� pesquisado
	 * @return o termo 
	 */
	public static Term getTerm(ZName nome, Term ast) {
		TermFromANameGetter visitor = new TermFromANameGetter(nome);
		Term result = ast.accept(visitor);
		return result;
	}
	
	/** 
	 * V� se uma determina string proveniente de um RefExpr possui uma
	 * aplica��o de fun��o para ser tratada como \Delta ou \Xi
	 *  
	 * @param funcoes O conjunto de fun��es tratadas
	 * @param aTratar String a ser testada para ver se � uma aplica��o 
	 *  de fun��o
	 * @return o par com os nomes das fun��es na ordem em que aparecem 
	 *  no termo e a substring resultante da an�lise 
	 */
	public static Pair<List<String>, String> 
		capturarSubstringParaTestar(Set<String> funcoes, String aTratar) {

		/* Retira as aplica��es de fun��o do nome */
		aTratar = aTratar.trim();
		List<String> listaFuncoes = new ArrayList<String>();
		boolean foiModificado;
		
		/* Executa enquanto n�o houver mais modifica��o da string */
		do {
			foiModificado = false;
			
			for (String funcao : funcoes) {
				Pair<Boolean, String> result = 
					TermFromANameGetter.capturarSubstringParaTestar(funcao, 
							aTratar);

				/* Foi retirada uma fun��o da string */
				if (result.getFirst()) {
					foiModificado = true;
					listaFuncoes.add(funcao);
					aTratar = result.getSecond();
				}
			}
		} while (foiModificado);
		return new Pair<List<String>, String>(listaFuncoes, aTratar);
	}
	
	/**
	 * V� se uma determina string proveniente de um RefExpr possui uma
	 * aplica��o de fun��o para ser tratada como \Delta ou \Xi
	 *  
	 * @param funcao a fun��o a ser considerada
	 * @param aTratar String a ser testada para ver se � uma aplica��o de 
	 *  fun��o
	 * @return o par com um booleano em <code>true</code> caso a 
	 *  fun��o apare�a no nome ou <code>false</code> caso contr�rio e
	 *  a string resultante do tratamento
	 */
	private static Pair<Boolean, String> capturarSubstringParaTestar(String funcao, 
			String aTratar) {
		String result;
		boolean foiModificado;
		if (aTratar.startsWith(funcao)) {
			
			/* � uma aplica��o da fun��o */
			result = aTratar.substring(funcao.length()).trim();
			foiModificado = true;
		} else {
			result = aTratar;
			foiModificado = false;
		}
		return new Pair<Boolean, String>(foiModificado, result);
	}

	/** Nome a ser pesquisado */
	private ZName aPesquisar;

	/**
	 * Construtor padr�o. Recebe o nome a ser pesquisado
	 * 
	 * @param novoAPesquisar o nome a ser pesquisado
	 */
	public TermFromANameGetter(ZName novoAPesquisar) {
		this.setAPesquisar(novoAPesquisar);
	}

	/**
	 * @return the aPesquisar
	 */
	private ZName getAPesquisar() {
		return aPesquisar;
	}

	/**
	 * @param pesquisar the aPesquisar to set
	 */
	private void setAPesquisar(ZName pesquisar) {
		aPesquisar = pesquisar;
	}

	/**
	 * Visita um termo gen�rico, apenas procura pelo filho
	 * 
	 * @param arg0 o termo gen�rico a ser visitado
	 * @return o termo, caso o nome tenha sido achado na sub-�rvore 
	 *  definida pelo termo, ou <code>null</code> caso contr�rio
	 */
	public Term visitTerm(Term arg0) {
		List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);

		for (Term filho : filhos) {
			Term result = filho.accept(this);
			if (result != null) {
				return result; 
			}
		}

		/* N�o achou a defini��o */
		return null;
	}

	/**
	 * Testa se a express�o se refere ao nome pesquisado
	 * 
	 * @param arg0 a express�o a ser visitada
	 * @return a express�o, caso o nome seja compat�vel com o nome da 
	 *  express�o, ou <code>null</code> caso contr�rio 
	 */
	public Term visitRefExpr(RefExpr arg0) {
		Term result;
		try {
			ActionArgumentAnn ann = arg0.getAnn(ActionArgumentAnn.class);
			if (ann == null) {

				// TODO testar tamb�m aplica��es de fun��es do tipo \Delta NomeEsquema ou \Xi NomeEsquema
				
				/* A COMPARA��O N�O LEVA EM CONTA OS STROKES DOS NOMES */
								
				/* Nome pesquisado */
				ZName copiaAPesquisar = this.getAPesquisar();
				String strAPesquisar = copiaAPesquisar.getWord();

				/* Nome a ser visitado */
				ZName nomeATestar = arg0.getZName();
				String strATestar = nomeATestar.getWord();
				strATestar = strATestar.trim();
				
				/* TESTA SE O REFEXPR TEM APLICA��ES DE FUN��O */
				Set<String> funcoes = CopyRuleForNameAnn.funcoesEsquemas();
				Pair<List<String>, String> par = 
					TermFromANameGetter.capturarSubstringParaTestar(funcoes, 
						strATestar);
				strATestar = par.getSecond();

				if (strATestar.equals(strAPesquisar)) {
					result = arg0;
				} else {
					result = null;
				}
			} else {

				/* A��o */
				result = ann.getTerm().accept(this);
			}

		} catch (UnsupportedAstClassException e) {
			result = null;
		}

		return result;
	}

	/**
	 * Visita uma chamada a a��o
	 * 
	 * @return a a��o, caso seja compat�vel com o nome apresentado, ou
	 *  <code>null</code> caso contr�rio
	 */
	public CallAction visitCallAction(CallAction arg0) {

		if (arg0.getName().equals(this.getAPesquisar())) {
			return arg0;
		} else {
			return null;
		}
	}

	/**
	 * Testa se o nome de um Conjunto de nomes � compat�vel com o
	 * nome requerido pelo usu�rio
	 * 
	 * @param arg0 o conjunto de nomes a ser pesquisado
	 * @return o pr�prio conjunto de nomes se o nome do conjunto for
	 *  compat�vel com aquele passado pelo usu�rio ou 
	 *  <code>null</code> caso contr�rio
	 */
	public CircusNameSet visitCircusNameSet(CircusNameSet arg0) {

		CircusNameSet result = null;
		Expr cs = arg0.getExpr();

		if (cs instanceof RefExpr) {

			/* Conjunto de canais � definido pelo nome */
			if (((RefExpr)cs).getName().equals(this.getAPesquisar())) {
				result = arg0;
			}
		}

		return result;
	}

	/**
	 * Visita uma chamada a um processo
	 * 
	 * @param arg0 a chamada de processo a ser pesquisada
	 * @return a pr�pria chamada de processo caso o nome seja 
	 *  compat�vel com o nome do processo ou <code>null</code> caso
	 *  contr�rio
	 */
	public CallProcess visitCallProcess(CallProcess arg0) {
		CallProcess result = null;

		if (arg0.getCallExpr().getName().equals(this.getAPesquisar())) {
			result = arg0;
		}

		return result;
	}

	/**
	 * Visita um conjunto de canais
	 * 
	 * @param arg0 o conjunto de canais a ser visitado
	 * @return o pr�prio conjunto de canais caso o nome seja 
	 *  compat�vel com o nome do conjunto ou <code>null</code> caso
	 *  contr�rio
	 */
	public CircusChannelSet visitCircusChannelSet(CircusChannelSet arg0) {
		CircusChannelSet result = null;
		Expr cs = arg0.getExpr();

		if (cs instanceof RefExpr) {

			/* Conjunto de canais � definido pelo nome */
			if (((RefExpr)cs).getName().equals(this.getAPesquisar())) {
				result = arg0;
			}
		}

		return result;
	}

}
