/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel
 */
package circusRefine.core.crules.utils;

import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.visitor.CircusProcessVisitor;

/**
 * Classe til para retornar um processo a qual um termo pertence.
 * 
 * @author Cristiano Gurgel
 */
public class ProcessOfATermGetter implements TermVisitor<CircusProcess>,
	CircusProcessVisitor<CircusProcess> {
	
	/**
	 * Retorna o processo ancestral de um termo
	 * 
	 * @param termo o termo que est em um processo
	 * @param ast a rvore na qual o processo ser pesquisado
	 * @return o processo ancestral de termo na ast
	 */
	public static CircusProcess getProcess(Term termo, Term ast) {
		ProcessOfATermGetter visitor = new ProcessOfATermGetter(termo);
		return ast.accept(visitor);
	}
	
	public boolean containsTermAux(Term termo, Term ast) {
		ContainsTermTester visitor = new ContainsTermTester(termo);
		return ast.accept(visitor);
	}
	
	/** Termo cujo processo deve ser procurado */
	private Term filhoDeUmProcesso;
	
	public ProcessOfATermGetter(Term filhoProcesso) {
		this.setFilhoDeUmProcesso(filhoProcesso);
	}
	
	public Term getFilhoDeUmProcesso() {
		return filhoDeUmProcesso;
	}
	
	public void setFilhoDeUmProcesso(Term filhoDeUmProcesso) {
		this.filhoDeUmProcesso = filhoDeUmProcesso;
	}
	
	/**
	 * 
	 */
	public CircusProcess visitTerm(Term arg0) {
		
		/* Extrai os filhos */
		List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);
		
		/* Procura os processos nos filhos */
		for (Term filho : filhos) {
			CircusProcess processo = filho.accept(this);
			if (processo != null) { /* Achou o processo */
				return processo;
			}
		}
		
		return null;
	}
	
	/**
	 * 
	 * @param arg0
	 * @return
	 */
	public CircusProcess visitCircusProcess(CircusProcess arg0) {
		if (this.containsTermAux(this.getFilhoDeUmProcesso(), arg0)) {
			return arg0; /* Achou!!!*/
		} else {
			return null;
		}
	}
	

}
