/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.utils;

import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.messages.CRulesMissingMessageException;
import circusRefine.core.crules.messages.MessagesManager;

/**
 * Excesso disparada quando h algum erro na aplicao da 
 * normalizao
 * 
 * @author Cristiano Castro
 */
public class NormalizationApplicationException extends CRulesException {

	/** Nmero para serializao */
	private static final long serialVersionUID = 6455396332746600082L;
	
	/**
	 * @throws CRulesMissingMessageException 
	 * @see Exception#Exception()
	 */
	public NormalizationApplicationException() throws CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage("COD0629"));
	}

	/**
	 * @throws CRulesMissingMessageException 
	 * @see Exception#Exception(String, Throwable) 
	 */
	public NormalizationApplicationException(String message, Throwable cause) 
	throws CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage(message), cause);
	}

	/**
	 * @throws CRulesMissingMessageException 
	 * @see Exception#Exception(String)
	 */
	public NormalizationApplicationException(String message) 
	throws CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage(message));
	}

	/**
	 * @see Exception#Exception(Throwable)
	 */
	public NormalizationApplicationException(Throwable cause) {
		super(cause);
	}
	
}
