package circusRefine.core.crules.utils;

/**
 * Nodo da Arvore de Tipos de leis, utilizada na montagem da arvore
 * hierarquica de leis xD
 */
import java.util.LinkedList;

import circusRefine.core.crules.factories.LawType;

public class NodeTypeLaws {
	
	private LawType tipo;
	private LinkedList<NodeTypeLaws> filhos;
	
	public NodeTypeLaws(LawType tipo) {
		super();
		this.tipo = tipo;
		filhos = new LinkedList<NodeTypeLaws>();
	}
	
	public void adicionandoFilho (NodeTypeLaws filho) {
		filhos.add(filho);
	}

	public LinkedList<NodeTypeLaws> getFilhos() {
		return filhos;
	}
	
	public LawType getTipo() {
		return tipo;
	}

	public boolean isLeaf() {
		if (filhos != null){
			return true;
		}
		return false;
	}
	
}
