package circusRefine.core.crules.utils;

import java.util.LinkedList;

/**
 * Classe node de uma arvore que contara a classificacao das leis
 * quanto ao tipo : assumption, guard, schemas etc
 * @author alessandro87
 *
 */
public class NodeHierarchyLaws {
	
	private String name;
	private LinkedList<NodeHierarchyLaws> filhos;
	
	public NodeHierarchyLaws(String name) {
		this.name = name;
		filhos = null;
	}
	public void habilitandoFilhos(){
		filhos = new LinkedList<NodeHierarchyLaws>();
	}
	public void adicionandoFilho (NodeHierarchyLaws filho) {
		if (filhos == null) {
			filhos = new LinkedList<NodeHierarchyLaws>();
		}
		filhos.add(filho);
	}
	public LinkedList<NodeHierarchyLaws> getFilhos() {
		return filhos;
	}
	public String getName() {
		return name;
	}
	
	public boolean isLaw () {
		if (filhos == null) {
			return true;
		}
		return false;
	}
	public boolean isTypeLaw(){
		if (filhos != null){
			return true;
		}
		return false;
	}
	
}
