/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.utils;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.NameSetPara;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.visitor.NameSetParaVisitor;
import net.sourceforge.czt.circus.visitor.ProcessParaVisitor;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.ParaVisitor;

/**
 * Classe para recuperar uma definio de um conjunto de nomes a 
 * partir do nome do conjunto
 * 
 * @author Cristiano Castro
 */
public class NameSetFromATermGetter extends DefinitionFromATermGetter 
implements ParaVisitor<Void>, ProcessParaVisitor<Void>, 
NameSetParaVisitor<Void> {

	/**
	 * Inicia a classe com o nome a ser pesquisado
	 * 
	 * @param nome o nome cuja definio deve ser pesquisada
	 */
	public NameSetFromATermGetter(ZName nome, Term tipoNome) {
		super(nome, tipoNome);
	}

	/**
	 * Os pragrafos que no tm influncia na busca pelo nome so 
	 * descartados
	 * 
	 * @param arg0 o pargrafo a ser visitado
	 */
	public Void visitPara(Para arg0) {
		return null;
	}

	/**
	 * O processo, se contiver o termo procurado,  includo na busca
	 * 
	 * @param arg0 o processo a ser pesquisado
	 */
	public Void visitProcessPara(ProcessPara arg0) {
		if (ContainsTermTester.containsTerm(this.getTipoNome(), 
				arg0.getCircusProcess())) {
			
			/* Termo est definido dentro do processo */
			arg0.getCircusProcess().accept(this);
		}
		
		return null;
	}

	/**
	 * Visita um pargrafo de nomes. Esse mtodo s  chamado quando
	 * se est visitando o processo no qual o termo se encontra.
	 * 
	 * @param arg0 o pargrafo do processo
	 */
	public Void visitNameSetPara(NameSetPara arg0) {
		if (arg0.getName().equals(this.getNomeAPesquisar())) {
			
			/* Achou a definio */
			this.setDefinition(arg0.getNameSet());
		}
		return null;
	}

}
