/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel
 */
package circusRefine.core.crules.utils;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.visitor.ActionParaVisitor;
import net.sourceforge.czt.circus.visitor.BasicProcessVisitor;
import net.sourceforge.czt.circus.visitor.MuActionVisitor;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.visitor.AxParaVisitor;
import net.sourceforge.czt.z.visitor.ConstDeclVisitor;
import net.sourceforge.czt.z.visitor.ZDeclListVisitor;
import net.sourceforge.czt.z.visitor.ZParaListVisitor;
import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.core.util.ClonerVisitor;

/**
 * Classe �til para retornar uma a��o a partir de um nome espec�fico.
 * A a��o � definida nos par�grafos de um processo
 * 
 * @author Cristiano Gurgel	
 */
public class ActionFromANameGetter extends DefinitionFromATermGetter
implements BasicProcessVisitor<Void>, ActionParaVisitor<Void>, 
AxParaVisitor<Void>, ZDeclListVisitor<Void>, ZParaListVisitor<Void>, 
ConstDeclVisitor<Void>, MuActionVisitor<Void> {

	private CircusPatternFactory factory = new CircusPatternFactoryImpl();
	
	/** 
	 * Boolean utilizado para indicar quem um processo no qual o termo
	 * foi definido est� sendo visitado 
	 */
	private boolean entreiNoProcesso;
	private boolean first = false;
	private boolean processo = false;
	private String nomeProcesso = "";
	
	/**
	 * Cria uma inst�ncia da classe com o nome da a��o da ser buscada.
	 * 
	 * @param nomeAcao o {@link ZName} correspondendo ao nome da a��o.
	 */
	public ActionFromANameGetter(ZName nomeAcao, Term tipoNome) {
		super(nomeAcao, tipoNome);
		this.setEntreiNoProcesso(false);
	}

	/**
	 * @return the entreiNoProcesso
	 */
	private boolean jaEntreiNoProcesso() {
		return entreiNoProcesso;
	}

	/**
	 * @param entreiNoProcesso the entreiNoProcesso to set
	 */
	private void setEntreiNoProcesso(boolean entreiNoProcesso) {
		this.entreiNoProcesso = entreiNoProcesso;
	}

	/**
	 * Procura a defini��o da a��o nos par�grafos de um 
	 * {@link BasicProcess}
	 * 
	 * @param arg0 o {@link BasicProcess} a ser pesquisado
	 * @return a a��o correspondente ao nome
	 */
	public Void visitBasicProcess(BasicProcess arg0) {
		
		/*
		 * Se o termo est� dentro do processo, ent�o experimenta as 
		 * defini��es do processo tamb�m. 
		 */
		//TODO verificar com  crisitano se a retirada desse condicional comentado implicita
		// num erro
		
		//if (ContainsTermTester.containsTerm(this.getTipoNome(), arg0)) {
			this.setEntreiNoProcesso(true);
			
			/**Verificar se o ultimo processo visitado
			 */
			if(GerenciadorTaticas.process.equals(nomeProcesso)
					|| GerenciadorTaticas.process.equals("")){
				processo = true;
				arg0.getParaList().accept(this);
							
			}
				
			else processo=false;
			
	
			
			/* 
			 * Ao fim de visitar o processo, pode disparar a excess�o 
			 * de que achou ou n�o o termo pesquisado 
			 */
			/*if (this.getDefinition() == null) {
				throw new NotFoundException();
			}*/
	//	}
		
		
		
		return null;
	}
		
	/**
	 * Achou a defini��o da a��o em um {@link ActionPara}
	 * 
	 * @param arg0 o {@link ActionPara} a ser visitado
	 * @return a a��o correspondente ao {@link ActionPara}
	 */
	public Void visitActionPara(ActionPara arg0) {
		/* Achou o nome da a��o */
		if (arg0.getName().equals(this.getNomeAPesquisar())) {
			
			/* Encontrei!! */
			if (!first && processo){
			this.setDefinition(arg0.getCircusAction());
			first=true;
			}
		}
		return null;
	}
	
	/**
	 * Visita um {@link AxPara} na busca pelo nome da a��o.
	 * 
	 * @param arg0 o {@link AxPara} a ser visitado
	 * @return uma a��o caso o nome seja encontrado nesse 
	 *  {@link AxPara} ou <code>null</code> caso contr�rio. 
	 */
	public Void visitAxPara(AxPara arg0) {
		/* 
		 * Defini��o axiom�tica pode ser levada em considera��o porque
		 * j� estamos no contexto do processo 
		 */
		if (this.jaEntreiNoProcesso()) {
			DeclList lista = arg0.getZSchText().getZDeclList();
			lista.accept(this);
		}
		
		return null;
	}

	/**
	 * Visita a lista de declara��es de um SchText em um AxPara para
	 * verificar se o nome procurado � definido nesse AxPara.
	 * 
	 * @param arg0 a DeclList a ser pesquisada;
	 * @return a CircusAction representada pelo nome, ou 
	 * 	<code>null</code>, caso n�o for encontrada.
	 */
	public Void visitZDeclList(ZDeclList arg0) {
		/* Busca pela defini��o da a��o */
		for (Decl decl : arg0) {
			decl.accept(this);
		}
		
		/* N�o achou, retorne null */
		return null;
	}
	
	/**
	 * Visita a lista de par�grafos do processo
	 * 
	 * @param arg0 a lista de par�grafo
	 */
	public Void visitZParaList(ZParaList arg0) {
		for (Para para : arg0) {
			if(para instanceof ProcessPara){
				ProcessPara pp = (ProcessPara) para;
				nomeProcesso = pp.getZName()+"";
				
			}
			para.accept(this);
		}
		return null;
	}
	
	/**
	 * Visita uma declara��o constante, para verificar se um 
	 * {@link SchExpr} pode ser a defini��o procurada da a��o.
	 *
	 * @param arg0 a declara��o constante a ser pesquisada
	 */
	public Void visitConstDecl(ConstDecl arg0) {
		/* Pega o nome da declara��o */
		Name nome;
		
		try {
			
			/* Retira os Strokes de um poss�vel (ZName para a decla��o) */
			nome = (Name)
				ClonerVisitor.cloneTermRemovingRelationsStack(arg0.getName());
			((ZName)nome).getZStrokeList().clear();
		} catch (UnsupportedAstClassException e) {
			
			/* A lista de strokes n�o � uma ZStrokeList */
		} catch (ClassCastException e) {
			
			/* nome n�o � um ZName */
		} finally {
			nome = arg0.getName();
		}
		
		if (this.getNomeAPesquisar().equals(nome)) {
			
			/* Achou a defini��o */	
			/* cria a a��o a partir do esquema encontrado */
			CircusAction acao = 
				this.factory.createSchExprAction(arg0.getExpr());
			this.setDefinition(acao);
		}
		
		/* n�o encontrei */
		return null;
	}

	/**
	 * Visita a um {@link MuAction}. Pode ter a busca cancelada se o 
	 * nome a que se refere a {@link MuAction} "enconbrir" o nome
	 * pesquisado
	 * 
	 * @param arg0 a MuAction a ser pesquisada
	 * @return <code>null</code>
	 */
	public Void visitMuAction(MuAction arg0) {
		if (ContainsTermTester.containsTerm(this.getTipoNome(), 
				arg0.getCircusAction())) {
			
			/* 
			 * A��o pesquisada est� dentro da MuAction. Deve se testar
			 * o nome da MuAction
			 */
			if (arg0.getName().equals(this.getNomeAPesquisar())) {
				
				/* Nome � o mesmo da MuAction. Busca cancelada */
				throw new NotFoundException();
			} else {
				
				/* Busca continua */
				arg0.getCircusAction().accept(this);
			}
		}
		return null;
	}

}
