/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.parseArgument;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnmarshalException;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.ChannelPara;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.NameSet;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.parser.circus.ParseUtils;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.session.Source;
import net.sourceforge.czt.session.StringSource;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.Sect;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.impl.AndPredImpl;
import net.sourceforge.czt.z.impl.ZParaListImpl;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.print.Action2Print;
import circusRefine.util.CodigoParametro;

/**
 * Classe respons�vel por disponibilizar m�todos para o On-the-fly 
 * parsing dos argumentos de uma lei Circus.
 * 
 * @author Cristiano Gurgel
 */
public class ParseArgumentUtils {

	// TODO parseRenameList
	// TODO parseStroke

	/** Construtor Padr�o */
	public ParseArgumentUtils() {
		super();
	}

	/**
	 * M�todo �til para retirar o conte�do de um Source e apendar a
	 *  um {@link StringBuffer}.
	 *  
	 * @param str o {@link StringBuffer} a ter seu conte�do acrescido
	 * 	do source.
	 * @param src o {@link Source} a ter seu conte�do extraido.
	 * @throws CRulesException 
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra.
	 */
	public static void appendContentFromSource(StringBuffer str, Source src) 
	throws CRulesException {
		Reader reader;
		try {
			reader = src.getReader();
			int ch = reader.read();
			while (ch != -1) {
				str.appendCodePoint(ch);
				ch = reader.read();
			}
		} catch (IOException e) {
			throw new ParseArgumentException("IOErrorCRulesMsg", e);
		}

	}

	/**
	 * 
	 * @param str
	 * @param cod
	 * @return
	 * @throws IOException
	 * @throws UnmarshalException
	 * @throws CommandException
	 * @throws ParseException
	 */
	public static Term parseArguments(String str, CodigoParametro cod) 
	throws CRulesException {
		StringSource source = new StringSource(str);
		Term result;

		/* Teste para saber qual o argumento a ser parseado */
		if (cod.equals(CodigoParametro.PREDICATE)) {
			result = ParseArgumentUtils.parsePred(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.EXPRESSION)) {
			result = ParseArgumentUtils.parseExpr(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.PROCESS)) {
			result = ParseArgumentUtils.parseCircusProcess(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.PROCESSPARA)) {
			result = ParseArgumentUtils.parseCircusProcessPara(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.NAME)) {
			result = ParseArgumentUtils.parseName(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.NAMELIST)) {
			result = ParseArgumentUtils.parseNameList(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.DECLLIST)) {
			result = ParseArgumentUtils.parseDeclList(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.ACTION)) {
			result = ParseArgumentUtils.parseCircusAction(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.CHANSET)) {
			result = ParseArgumentUtils.parseChannelSet(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.NAMESET)) {
			result = ParseArgumentUtils.parseNameSet(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.COMMUN)) {
			result = ParseArgumentUtils.parseCommunication(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.EXPRLIST)) {
			result = ParseArgumentUtils.parseExprList(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.PARA)) {
			result = ParseArgumentUtils.parsePara(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.PARALIST)) {
			result = ParseArgumentUtils.parseParaList(source, 
					InternalManager.getManager());
		} 
		else {
			result = null;
		}

		return result;



	}

	public static Term parseArgumentsTactic(String str, CodigoParametro cod) 
	throws CRulesException {
		StringSource source = new StringSource(str);
		Term result;

		/* Teste para saber qual o argumento a ser parseado */
		if (cod.equals(CodigoParametro.PREDICATE)) {
			result = ParseArgumentUtils.parsePred(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.EXPRESSION)) {
			result = ParseArgumentUtils.parseExpr(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.PROCESS)) {
			result = ParseArgumentUtils.parseCircusProcess(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.NAME)) {
			result = ParseArgumentUtils.parseName(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.NAMELIST)) {
			result = ParseArgumentUtils.parseNameList(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.DECLLIST)) {
			result = ParseArgumentUtils.parseDeclList(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.ACTION)) {
			result = ParseArgumentUtils.parseCircusActionTactic(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.CHANSET)) {
			result = ParseArgumentUtils.parseChannelSet(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.NAMESET)) {
			result = ParseArgumentUtils.parseNameSet(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.COMMUN)) {
			result = ParseArgumentUtils.parseCommunication(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.EXPRLIST)) {
			result = ParseArgumentUtils.parseExprList(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.PARA)) {
			result = ParseArgumentUtils.parsePara(source, 
					InternalManager.getManager());
		} else if (cod.equals(CodigoParametro.PARALIST)) {
			result = ParseArgumentUtils.parseParaList(source, 
					InternalManager.getManager());
		} 
		else {
			result = null;
		}

		return result;



	}

	/*public static Term parseArgumentsTatic(String str,String str2, CodigoParametro cod) 
	throws CRulesException {
		StringSource source1 = new StringSource(str);
		StringSource source2 = new StringSource(str2);
		Term result;

		 Teste para saber qual o argumento a ser parseado 
        if (cod.equals(CodigoParametro.PREFIXING)) {
			result = ParseArgumentUtils.parsePrefixing(source1,source2, 
					InternalManager.getManager());
		} else {
			result = null;
		}


		return result;



	}
	 */
	/**
	 * Executa um parser em um predicado
	 * 
	 * @param src a fonte de onde ir� se extrair o predicado
	 * @param manager
	 * @return o predicado parseado
	 * @throws CRulesException 
	 * @throws ParseArgumentException dispara quando n�o for poss�vel 
	 *  parsear o predicado
	 */
	public static Pred parsePred( Source src , SectionManager manager ) 
	throws CRulesException {
		try {
			return ParseUtils.parsePred(src, null, manager);
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParsePredErrorCRulesMsg", e);
		}
	}


	/**
	 * Executa o parser em uma express�o
	 * 
	 * @param src a fonte de onde ir� se extrair o predicado
	 * @param manager
	 * @return a express�o parseada a partir do predicado
	 */
	public static Expr parseExpr( Source src , SectionManager manager ) 
	throws CRulesException {
		try {
			return ParseUtils.parseExpr(src, null, manager);
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */

			throw new ParseArgumentException("ParseExprErrorCRulesMsg", e);
		}
	}

	/**
	 * Executa um parse On-the-fly em um {@link CircusProcess}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link CircusProcess} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static CircusProcess parseCircusProcess(Source src, 
			SectionManager sec) throws CRulesException {

		/* Encapsula o process em um par�grafo */
		StringBuffer str = new StringBuffer();
		str.append("\\begin{circus}\n\t");
		str.append("\\circprocess\\ P ~~\\circdef~~ ");

		ParseArgumentUtils.appendContentFromSource(str, src);

		str.append("\n\\end{circus}");

		StringSource source = new StringSource(str.toString());
		CircusProcess processo2 = null;

		/* Executa o parser no term */
		Term result;
		try { 
			result = ParseUtils.parse(source, (SectionManager)sec.clone());

			/*processo2 = 
				ParseArgumentUtils.parseCircusProcess(source,(SectionManager)sec.clone());*/

		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseProcessErrorCRulesMsg", e);
		}
		Spec specification = (Spec)result;
		ListTerm<Sect> lista = specification.getSect();
		ZSect secao = (ZSect)lista.get(0);
		ZParaList listaPara = secao.getZParaList();

		for (Para p : listaPara) {
			if (p instanceof ProcessPara) {

				ProcessPara pp = (ProcessPara)p;	
				pp.getZName();
				return pp.getCircusProcess();
				
			}

		}


		/* N�o encontrei nenhum par�grafo de Processo */
		throw new ParseArgumentException("ParseProcessParagraphErrorCRulesMsg");

	}
	
	public static ProcessPara parseCircusProcessPara(Source src, 
			SectionManager sec) throws CRulesException {

		/* Encapsula o process em um par�grafo */
		StringBuffer str = new StringBuffer();
		str.append("\\begin{circus}\n\t");
		str.append("\\circprocess\\ P ~~\\circdef~~ ");

		ParseArgumentUtils.appendContentFromSource(str, src);

		str.append("\n\\end{circus}");

		StringSource source = new StringSource(str.toString());
		CircusProcess processo2 = null;

		/* Executa o parser no term */
		Term result;
		try { 
			result = ParseUtils.parse(source, (SectionManager)sec.clone());

			/*processo2 = 
				ParseArgumentUtils.parseCircusProcess(source,(SectionManager)sec.clone());*/

		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseProcessErrorCRulesMsg", e);
		}
		Spec specification = (Spec)result;
		ListTerm<Sect> lista = specification.getSect();
		ZSect secao = (ZSect)lista.get(0);
		ZParaList listaPara = secao.getZParaList();

		for (Para p : listaPara) {
			if (p instanceof ProcessPara) {

				ProcessPara pp = (ProcessPara)p;	
				pp.getZName();
				return pp;
			}

		}


		/* N�o encontrei nenhum par�grafo de Processo */
		throw new ParseArgumentException("ParseProcessParagraphErrorCRulesMsg");

	}

	/**
	 * Executa um parse On-the-fly em um {@link Name}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link Name} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static Name parseName(Source src, SectionManager manager) 
	throws CRulesException {

		/* Criando o par�grafo para encapsular a comunica��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{axdef}\n");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append(" : \\nat\n");
		sbuf.append("\\end{axdef}\n");

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			Name nl = NameGetter.getAName(ast);
			return nl;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseNameErrorCRulesMsg", e);
		}
	}


	/**
	 * Executa um parse On-the-fly em um {@link NameList}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link NameList} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static NameList parseNameList(Source src, SectionManager manager) 
	throws CRulesException {

		/* Criando o par�grafo para encapsular a comunica��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{axdef}\n");

		ParseArgumentUtils.appendContentFromSource(sbuf, src);

		sbuf.append(" : \\nat\n");
		sbuf.append("\\end{axdef}\n");

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			NameList nl = NameListGetter.getANameList(ast);
			return nl;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseNameListErrorCRulesMsg", e);
		}
	}


	/**
	 * Executa um parse On-the-fly em um {@link NameSet}. Usado para
	 *  aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link NameSet} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static NameSet parseNameSet(Source src, SectionManager manager) 
	throws CRulesException {

		/* Criando o par�grafo para encapsular a declara��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circprocess\\ JustMainActionBasicProcess " + 
		"~~\\circdef~~ \\circbegin \\\\");
		sbuf.append("@ a1 \\linter ");

		ParseArgumentUtils.appendContentFromSource(sbuf, src);

		sbuf.append(" | ns2 \\rinter a2 \\\\\n");
		sbuf.append("\\circend\n \\end{circus}");

		//		\begin{circus}
		//		\circprocess\ JustMainActionBasicProcess ~~\circdef~~ \circbegin \\
		//		@ a1 \linter ns1 | ns2 \rinter a2 \\
		//		\circend
		//		\end{circus}

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			NameSet nl = NameSetGetter.getANameSet(ast);
			return nl;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */

			throw new ParseArgumentException("ParseNameSetErrorCRulesMsg", e);
		}
	}


	/**
	 * Executa um parse On-the-fly em um {@link DeclList}. Usado para
	 *  aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link DeclList} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static DeclList parseDeclList(Source src, SectionManager manager) 
	throws CRulesException {

		/* Criando o par�grafo para encapsular a declara��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{axdef}\n");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append("\\end{axdef}\n");

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			DeclList nl = DeclListGetter.getADeclList(ast);
			return nl;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseDeclListErrorCRulesMsg", e);
		}
	}

	/**
	 * Executa um parse On-the-fly em um {@link CircusProcess}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link CircusProcess} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static CircusAction parseCircusAction(Source src, 
			SectionManager manager) throws CRulesException {

		/* Cria o par�grafo para encapsular a a��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circprocess\\ JustMainActionBasicProcess ~~\\circdef~~ "
				+ "\\circbegin \\\\\n \\circspot ");
		//		+ "\\circbegin \\\\\n ");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append(" \n \\circend\n \\end{circus}\n");



		/* Executa o parser no arquivo e recupera o circChannel */
		try {

			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);

			CircusAction result = CircusActionGetter.getACircusAction(ast);
			return result;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseCircusActionErrorCRulesMsg", 
					e);
		}

	}

	public static Term parseCircusActionTactic(Source src, 
			SectionManager manager) throws CRulesException {

		/* Cria o par�grafo para encapsular a a��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circprocess\\ JustMainActionBasicProcess ~~\\circdef~~ "
				//	+ "\\circbegin \\\\\n \\circspot ");
				+ "\\circbegin \\\\\n ");
		sbuf.append(" Acao \\circdef ");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append(" \n \\circspot ");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append(" \n \\circend\n \\end{circus}\n");



		/* Executa o parser no arquivo e recupera o circChannel */
		try {

			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);

			//CircusAction result = CircusActionGetter.getACircusAction(ast);
			return ast;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseCircusActionErrorCRulesMsg", 
					e);
		}

	}

	/**
	 * Executa um parse On-the-fly em um {@link ParaList}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link ParaList} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static Para parsePara(Source src, SectionManager manager) 
	throws CRulesException {

		ParaList pl = ParseArgumentUtils.parseParaList(src, manager);
		return ((ZParaList)pl).get(0);
	}

	/**
	 * Executa um parse On-the-fly em um {@link ParaList}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link ParaList} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static ParaList parseParaList(Source src, SectionManager manager) 
	throws CRulesException {

		/* Cria o par�grafo para encapsular a a��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\circbegin \n");

		ParseArgumentUtils.appendContentFromSource(sbuf, src);

		sbuf.append("\\circspot \\Skip \\\\");
		sbuf.append("\\circend\n");

		/* Executa o parser no arquivo e recupera o circChannel */
		try {

			Source source = new StringSource(sbuf.toString());
			CircusProcess processo = 
				ParseArgumentUtils.parseCircusProcess(source, manager);

			return ((BasicProcess)processo).getZParaList();
		} catch (Exception e) {
			throw new ParseArgumentException("ParseParagraphListErrorCRulesMsg", 
					e);
		}

	}

	/**
	 * Executa um parse On-the-fly em um {@link ChannelSet}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link ChannelSet} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static ChannelSet parseChannelSet(Source src, 
			SectionManager manager) throws CRulesException {
		/* Cria o par�grafo para encapsular a a��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circprocess\\ JustMainActionBasicProcess ~~\\circdef~~ "
				+ "\\circbegin \\\\\n @ ");
		//sbuf.append("(Skip) \\circhide ");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append(" \\circend\n \\end{circus}\n");

		//		\begin{circus}
		//		\circprocess\ JustMainActionBasicProcess ~~\circdef~~ \circbegin \\
		//		@ (Skip) \circhide \lchanset write, read \rchanset \\
		//		\circend
		//		\end{circus}

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			ChannelSet result = ChannelSetGetter.getAChannelSet(ast);
			return result;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseChannelSetErrorCRulesMsg", 
					e);
		}

	}


	/**
	 * Executa um parse On-the-fly em um {@link Communication}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link Communication} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static Communication parseCommunication(Source src, 
			SectionManager manager) throws CRulesException {
		/* Cria o par�grafo para encapsular a a��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circprocess\\ JustMainActionBasicProcess ~~\\circdef~~ "
				+ "\\circbegin \\\\ \n @ ");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append(" \\then Skip \\\\ \\circend\n \\end{circus}\n");

		//		\begin{circus}
		//		\circprocess\ JustMainActionBasicProcess ~~\circdef~~ \circbegin \\
		//		@ c \then Skip \\
		//		\circend
		//		\end{circus}

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			CircusAction action = CircusActionGetter.getACircusAction(ast);
			Communication result = ((PrefixingAction)action).getCommunication();
			return result;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseCommunicationErrorCRulesMsg", 
					e);
		}

	}

	/**
	 * Executa um parse On-the-fly em um {@link Communication}. Usado
	 * para aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link Communication} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static CircusAction parsePrefixing(Source src1, Source src2, 
			SectionManager manager) throws CRulesException {


		StringBuffer sbuf = new StringBuffer();
		/* Criando o par�grafo para encapsular a comunica��o */
		/*
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circchannel\\ ");
		ParseArgumentUtils.appendContentFromSource(sbuf, src1);
		sbuf.append("\n\\end{circus}\n");
		 */

		/* Cria o par�grafo para encapsular a a��o */
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circprocess\\ JustMainActionBasicProcess ~~\\circdef~~ "
				+ "\\circbegin \\\\ \n @ ");
		ParseArgumentUtils.appendContentFromSource(sbuf, src2);
		sbuf.append("\n \\circend\n \\end{circus}\n");


		//		\begin{circus}
		//		\circprocess\ JustMainActionBasicProcess ~~\circdef~~ \circbegin \\
		//		@ c \then Skip \\
		//		\circend
		//		\end{circus}

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			CircusAction action = CircusActionGetter.getACircusAction(ast);
			//Communication result = ((PrefixingAction)action).getCommunication();
			return action;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseCommunicationErrorCRulesMsg", 
					e);
		}

	}

	/**
	 * Executa um parse On-the-fly em um {@link ExprList}. Usado para
	 *  aplicar leis com par�metros.
	 * 
	 * @param src a String a ser parseada
	 * @param sec o SectionManager a ser usado no parser
	 * @return o {@link ExprList} obtido a partir do Source
	 * @throws IOException caso algum erro de Entrada/Sa�da ocorra
	 * @throws CommandException caso algum erro de parser ocorra
	 */
	public static ExprList parseExprList(Source src, SectionManager manager) 
	throws CRulesException {

		/* Cria o par�grafo para encapsular a a��o */
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("\\begin{circus}\n");
		sbuf.append("\\circprocess\\ JustMainActionBasicProcess ~~\\circdef~~ "
				+ "\\circbegin \\\\ \n @ a(");
		ParseArgumentUtils.appendContentFromSource(sbuf, src);
		sbuf.append(") \\\\ \n \\circend\n \\end{circus}\n");

		//		\begin{circus}
		//		\circprocess\ JustMainActionBasicProcess ~~\circdef~~ \circbegin \\
		//		@ a(f(0), 0 + 1) \\
		//		\circend
		//		\end{circus}

		/* Executa o parser no arquivo e recupera o circChannel */
		try {
			Source source = new StringSource(sbuf.toString());
			Term ast = ParseUtils.parse(source, manager);
			CircusAction action = CircusActionGetter.getACircusAction(ast);
			ExprList result = ((CallAction)action).getExprList();
			return result;
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseExpressionListCRulesMsg", e);
		}

	}

	/**
	 * Executa um parse nem um par�grafo global do CRefine
	 * 
	 * @param src a fonte para parsear
	 * @param manager o manager para passar ao {@link ParseUtils}
	 * @return
	 */
	public static Para parseGlobalParagraph( Source src , 
			SectionManager manager ) throws CRulesException {

		Term ast;
		try {
			ast = ParseUtils.parse( src , manager );
		} catch (Exception e) {

			/* N�o p�de parsear o argumento */
			throw new ParseArgumentException("ParseGlobalParagraphCRulesMsg", 
					e);
		}

		Spec specification = (Spec) ast ;
		ListTerm<Sect> lista = specification.getSect();

		ZSect zSect = null;
		for ( Sect section : lista ) {
			if ( section instanceof ZSect ) {
				zSect = (ZSect) section;
			}
		}

		if ( zSect == null ) {

			/* N�o achou uma se��o Z */
			throw new ParseArgumentException("ParseGlobalParagraphCRulesMsg");
		}

		/* Captura o par�grafo inserido */
		Para insertedPara = null;
		ZSect secao = (ZSect)lista.get(0);
		ZParaList listaPara = secao.getZParaList();
		for (Para p : listaPara) {

			// TODO melhorar essa parte do programa
			if ( p instanceof ChannelPara || p instanceof ChannelSetPara 
					|| p instanceof ProcessPara ) {
				insertedPara = p;
				break;
			}
		}

		if ( insertedPara == null ) {

			/* Par�grafo n�o inserido corretamente */
			/* N�o encontrei nenhum par�grafo de Processo */
			throw new ParseArgumentException("ParseGlobalParagraphNoParagraph" +
			"FoundCRulesMsg");
		}

		/* O par�grafo foi parseado corretamente */
		return insertedPara;

	}

}
