/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.parseArgument;

import java.io.StringWriter;
import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.visitor.ChannelSetVisitor;

/**
 * Um Visitor para retornar um ChannelSet a partir da AST. Usado no
 * parse de Argumentos
 *  
 * @author Cristiano Gurgel
 */
public class ChannelSetGetter implements TermVisitor<ChannelSet>, 
		ChannelSetVisitor<ChannelSet> {

	/**
	 * Retorna um ChannelSet a partir de uma AST, usando, para isso,
	 * uma instncia de {@link ChannelSetGetter}.
	 * 
	 * @param ast a AST a ser visitada
	 * @return um ChannelSet contido na AST
	 */
	public static ChannelSet getAChannelSet(Term ast) {
		ChannelSetGetter getter = new ChannelSetGetter();
		ChannelSet result = ast.accept(getter);
		return result;
	}
	
	/** Log para a documentao */
	private StringWriter log;
	
	/**
	 * Construtor Padro. Somente cria um log para o objeto
	 */
	public ChannelSetGetter() { 
		this.setLog(new StringWriter());
		this.addMessage("Novo log do ChannelSetGetter: " + this);
	}
	
	/**
	 * Acessa o log da classe
	 * 
	 * @return a informacao da classe
	 */
	public String getInfo() {
		return this.getLog().toString();
	}
	
	private StringWriter getLog() {
		return log;
	}
	
	private void setLog(StringWriter log) {
		this.log = log;
	}
	
	
	/**
	 * Adiciona uma mensagem ao log de unificacao
	 * 
	 * @param msg a mensagem a ser adicionada
	 */
	private void addMessage(String msg) {
		this.getLog().append(msg + "\n");
	}	
	
	/**
	 * Percorre a rvore procurando uma instncia de 
	 * {@link ChannelSet}.
	 * 
	 * @param arg0 a AST a ser visitada.
	 * @return o {@link ChannelSet} encontrado na rvore ou 
	 * 	<code>null</code> caso esse no seja encontrado.
	 */
	public ChannelSet visitTerm(Term arg0) {
		this.addMessage("Visitando termo: " + arg0);
		List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);
		
		for (Term filho : filhos) {
			ChannelSet result = filho.accept(this);
			if (result != null) {
				return result;
			}
		}
		
		/* No encontrei a o ChannelSet na Ast*/
		return null;
	}

	/**
	 * Caso encontre uma instncia de ChannelSet, ento o mesmo  
	 * 	retornado
	 * 
	 * @param arg0 o ChannelSet a ser visitado.
	 * @return o ChannelSet encontrado
	 */
	public ChannelSet visitChannelSet(ChannelSet arg0) {
		this.addMessage("Visitando um ChannelSet: " + arg0);
		return arg0;
	}

}
