package circusRefine.core.crules.factories;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import circusRefine.core.InternalManager;
import circusRefine.core.annotations.StatementSchExprAnn;
import circusRefine.core.crules.anotations.BasicConversioAnn;
import circusRefine.core.crules.anotations.BasicConversionXiOperationAnn;
import circusRefine.core.crules.anotations.CompositionConversationAnn;
import circusRefine.core.crules.anotations.ConjuctionConversionAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CircusActionList;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.IfGuardedCommand;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.impl.ActionListImpl;
import net.sourceforge.czt.circus.jaxb.gen.ActionList;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.PreExpr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.impl.SchExpr2Impl;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerPred;

public class ZRCLawsFactory extends LawsFactory{

	public ZRCLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	public List<CircusLaw> createAll() {
		
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		
		/*Lei basic conversion*/
		result.add(this.createBasicConversion());
		
		/*Lei basic conversion que não altera estado*/
		result.add(this.createBasicConversionThatNoChangeState());
		
		/*Lei Schema disjunction Conversion*/
		result.add(this.createSchemaDisjunctionConversion());
		
		/*Lei Schema Conjuction Conversion */
		result.add(this.createSchemaConjuctionConversion());
		
		/*Lei Schema Composition Conversion */
		result.add(this.createSchemaCompositionConversion());
		
		return result;
	}
	
	/**
	 * Lei Schema Composition Conversion
	 * @return
	 */
	private CircusLaw createSchemaCompositionConversion() {
		
		/* LHS */
    	JokerExpr expr = this.getFactory().createJokerExpr("Op1", null);
    	JokerExpr expr2 = this.getFactory().createJokerExpr("Op2", null);
    	
    	SchExprAction left = this.getFactory().createSchExprAction(
    			factory.createCompExpr(Arrays.asList(expr,expr2)));
		
    	/* RHS */
    	
    	SchExprAction act1 = factory.createSchExprAction(expr);
    	SchExprAction act2 = factory.createSchExprAction(expr2);
    	
    	
    	JokerPred pred1 = factory.createJokerPred("pred1", null);
    	JokerPred pred2 = factory.createJokerPred("The operations must act over the same state", null);
    	
    	JokerPred pred3 = factory.createJokerPred("The operations have no commom output variables", null);
    	
    	JokerAction right = factory.createJokerAction("Op1 \\circseq Op2", null);
    	right.getAnns().add(new CompositionConversationAnn(expr, expr2, right,pred1));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Refinement,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	
    	LinkedList<Pred> ops = new LinkedList<Pred>();
    	ops.add(pred1);
    	ops.add(pred2);
    	ops.add(pred3);
    	
    	/* Criando a Lei */
    	String nome = this.createName("SchemaCompositionConversion");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("ZRC-scompC", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ZED_REFINEMENT_CALCULUS);
    	
    	
    	
    	return result;
	}

	/**
	 * 
	 * @return A lei Schema Conjuction do livro de Ana
	 */
	private CircusLaw createSchemaConjuctionConversion() {
		
		/* LHS */
    	JokerExpr expr = this.getFactory().createJokerExpr("Op1", null);
    	JokerExpr expr2 = this.getFactory().createJokerExpr("Op2", null);
    	
    	SchExprAction left = this.getFactory().createSchExprAction(
    			factory.createAndExpr(Arrays.asList(expr,expr2)));
    	
    	/* RHS */
    	
    	SchExprAction act1 = factory.createSchExprAction(expr);
    	SchExprAction act2 = factory.createSchExprAction(expr2);
    	
    	JokerAction right = factory.createJokerAction("Op1 \\circseq Op2", null);
    	right.getAnns().add(new ConjuctionConversionAnn(expr, expr2, right));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Refinement,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
   	
    	LinkedList<Pred> ops = new LinkedList<Pred>();
    	
    	
    	/* Montando a refer�ncia � função "DFV_Expr" */
    	ZName nomeFV = this.getFactory().createZName(OPsDischargeUtils.FV_Expr, 
    			this.getFactory().createZStrokeList(), null);
    	RefExpr funFV = this.getFactory().createRefExpr(nomeFV, 
    			this.getFactory().createZExprList(), false, false);
    	
    	/* Monta a aplicação � função "DFV_Expr(CS_1)" */
    	ApplExpr appl1 = 
    		this.getFactory().createApplExpr(Arrays.asList(funFV, expr), 
    				false);
    	
    	/* Monta a aplicação � função "DFV_Expr(CS_1)" */
    	ApplExpr appl2 = 
    		this.getFactory().createApplExpr(Arrays.asList(funFV, expr2), 
    				false);
    	
    	/* Monta a referencia a função interseção */
    	ZName nomeIntersecao = this.getFactory().createZName(
    			OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
    			null);
    	RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
    			this.getFactory().createZExprList(), false, false);
    	
    	
    	ZExprList listaArgs = 
    		this.getFactory().createZExprList(Arrays.asList(appl1, 
    				appl2));
    	TupleExpr args = 
    		this.getFactory().createTupleExpr(listaArgs);
    	
    	ApplExpr applIntersecao = 
    		this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
    				args), true);
    	
    	/* Monta a refer�ncia ao conjunto vazio */
    	SetExpr conjuntoUnitarioDoConjuntoVazio = 
    		SchemaLawsFactory.montarConjuntoUnitarioDoConjuntoVazio();
    	
    	MemPred op1 = this.getFactory().createMemPred(
    			Arrays.asList(applIntersecao, 
    					conjuntoUnitarioDoConjuntoVazio), true);
    	
    	ops.add(op1);
    	
    	/* Criando a Lei */
    	String nome = this.createName("SchemaConjuctionConversion");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("ZRC-sconC", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ZED_REFINEMENT_CALCULUS);
    	
    	
    	
    	return result;
	}

	/**
	 * 
	 * @return a lei que pega uma disjunção de schema e 
	 * obtém um specification statement
	 */
	private CircusLaw createSchemaDisjunctionConversion() {
		
		/* LHS */
    	JokerDeclList d = this.getFactory().createJokerDeclList("\\Delta S; di?;do!", null);
    	JokerPred p = this.getFactory().createJokerPred("p1", null);
    	ZSchText text = this.getFactory().createZSchText(d, p);
    	SchExpr expr = this.getFactory().createSchExpr(text);
    	
    	SchExprAction act1 = factory.createSchExprAction(expr);
    	
    	JokerDeclList d2 = this.getFactory().createJokerDeclList("\\Delta S; di?;do!", null);
    	JokerPred p2 = this.getFactory().createJokerPred("p2", null);
    	ZSchText text2 = this.getFactory().createZSchText(d2, p2);
    	SchExpr expr2 = this.getFactory().createSchExpr(text2);
    	SchExprAction act2 = factory.createSchExprAction(expr2);
    	
    	SchExprAction left = this.getFactory().createSchExprAction(
    			factory.createOrExpr(Arrays.asList(expr,expr2)));
    	
    	/* RHS */
    	
    	PreExpr pre1 = factory.createPreExpr(expr);
    	PreExpr pre2 = factory.createPreExpr(expr2);
    	
    	GuardedAction gact1 = factory.createGuardedAction(act1, factory.createExprPred(pre1));
    	GuardedAction gact2 = factory.createGuardedAction(act2,factory.createExprPred(pre2));
    	
    	CircusActionList list = factory.createCircusActionList(Arrays.asList(gact1,gact2));
    	IfGuardedCommand acaofinal = factory.createIfGuardedCommand(list);
    	
    	/* Não é aceito a aplicação de lei sobre um statement, pois quebra o ConstDecl == Expr
		 * Então será utilizado esse termo para guardar o real termo(anotação)*/
		SchExprAction right = factory.createSchExprAction(factory.createSchExpr());
		right.getExpr().getAnns().add(new StatementSchExprAnn(acaofinal));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Refinement,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
   	
    	LinkedList<Pred> ops = new LinkedList<Pred>();
    	ops.add(factory.createJokerPred("The operations must act over the same state and variables", null));
    	
    	/* Criando a Lei */
    	String nome = this.createName("SchemaDisjunctionConversion");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("ZRC-sdisjC", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ZED_REFINEMENT_CALCULUS);
    	
    	
    	
    	return result;
	}

	/**
	 * 
	 * @return a lei bc que é aplicável a esquemas que não alteram 
	 * estado.
	 */
	private CircusLaw createBasicConversionThatNoChangeState() {
		/* LHS */
    	JokerDeclList d = this.getFactory().createJokerDeclList("\\Xi S; di?;do!", null);
    	JokerPred p = this.getFactory().createJokerPred("p", null);
    	ZSchText text = this.getFactory().createZSchText(d, p);
    	SchExpr expr = this.getFactory().createSchExpr(text);
    	SchExprAction left = this.getFactory().createSchExprAction(expr);
    	
    	/* RHS */
    	
    	JokerAction right = this.getFactory().createJokerAction("do!:[inv \\land \\exists do! @ p[d/d'],p ]", null);
    	
    	/* Anotação para a aplicação da lei */
    	right.getAnns().add(new BasicConversionXiOperationAnn(d,p,left,right));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
   	
    	LinkedList<Pred> ops = new LinkedList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = this.createName("BasicConversionNoChangeState");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("ZRC-bCXi", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ZED_REFINEMENT_CALCULUS);
    	
    	return result;
	}

	/**
     * Transforma uma operação de schema num specification statement
     * do tipo w: [pre,post] ler no ZRC
     * 
     * @return a nova lei de Z
     */
    public CircusLaw createBasicConversion() {
    	
    	/* LHS */
    	JokerDeclList d = this.getFactory().createJokerDeclList("\\Delta S; di?;do!", null);
    	JokerPred p = this.getFactory().createJokerPred("p", null);
    	ZSchText text = this.getFactory().createZSchText(d, p);
    	SchExpr expr = this.getFactory().createSchExpr(text);
    	SchExprAction left = this.getFactory().createSchExprAction(expr);
    	
    	/* RHS */
    	
    	JokerAction right = this.getFactory().createJokerAction("d,do!:[inv \\land \\exists d';do! @ inv' \\land p,inv' \\land p ]", null);
    	
    	/* Anotação para a aplicação da lei */
    	right.getAnns().add(new BasicConversioAnn(d,p,left,right));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
   	
    	LinkedList<Pred> ops = new LinkedList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = this.createName("BasicConversion");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("ZRC-bC", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ZED_REFINEMENT_CALCULUS);
    	
    	return result;
    	
    }
    
    /**
	 * Retorna o nome composto para a lei circus
	 * 
	 * @param cod o codigo para o nome da lei
	 * @return uma String com o nome constru�do da lei
	 */
	protected String createName(String cod) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_SCHEMA, cod);
	}

}
