/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import circusRefine.core.InternalManager;
import circusRefine.core.crules.LawDefinitionAnn;
import circusRefine.core.crules.anotations.DataRefinementProcessLawAnn;
import circusRefine.core.crules.anotations.ParaAddAnn;
import circusRefine.core.crules.anotations.ProcessMainVarState;
import circusRefine.core.crules.anotations.ProcessSplittingApplAnn;
import circusRefine.core.crules.anotations.RemoveParaAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.util.Internacional;

import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.ProcessTransformerPred;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.ast.JokerProcessBinding;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;

/**
 * Classe respons�vel pela defini��o das leis de processos
 * 
 * @author Cristiano Castro
 */
public class ProcessLawsFactory extends LawsFactory {

	public ProcessLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter,gerInt);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();

		/* C-146 */
		result.add(this.createLawProcessSplitting());

		/* N�o t�m IDs */
		result.add(this.criarLeiInserirActionPara());
		result.add(this.criarLeiInserirPara());
		result.add(this.criarLeiRemoverPara());
		result.add(this.createLawChangeProcessState());
		
		result.add(this.createLawMainVarState());
		result.add(this.createLawMainVarState2());

		return result;
	}

	/**
	 * Cria um nome para lei de acordo com o c�digo. O tipo �
	 * PROCESS_REFINEMENT
	 * 
	 * @param cod
	 * @return
	 */
	private String retornarMsg(String cod) {
		return this.retornarMsg(LawType.PROCESS_REFINEMENT, cod);
	}

	/**
	 * Cria a lei C-146 Process splitting
	 * 
	 * @return a nova lei circus
	 */
	public CircusLaw createLawProcessSplitting() {

		/* LHS */
		JokerParaList corpoProcesso = 
			this.getFactory().createJokerParaList("Pbody", null);
		BasicProcess left = 
			this.getFactory().createBasicProcess(corpoProcesso);


		/* RHS */
		JokerProcess right = 
			this.getFactory().createJokerProcess("P", null);

		/* Obriga��o de prova do process Splitting */
		JokerPred op1 = factory.createJokerPred("op", null);
		right.getAnns().add(new ProcessSplittingApplAnn(corpoProcesso, 
				this.getInter(), right, op1, gerInterno));

		/* Criando o Transformer */
		ProcessTransformerPred trans = factory.createProcessTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		list.add(op1);


		String nome = this.retornarMsg("COD0560");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.146", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);

		/* Law DEFINITION*/
		String[] description = new String[1];
		description[0] = "Let qd and rd stand for declarations of the processes" +
		"Q and R, determined by\n Q.State , Q.PPar, and Q.Act, and R.State," +
		" R.PPar, and R.Act, respectively, and pd \n stand for the process " +
		"declaration.";

		String detailsOp = "Q.PPar and R.PPar are disjoint with respect to R.State";
		ArrayList<String> detailsListOps = new ArrayList<String>();
		detailsListOps.add(detailsOp);

		String Space = "     ";

		String[] antes = new String[5];
		antes[0] = CircusString.CIRCPROC + " P " + CircusString.CIRCDEF + " " +
		CircusString.CIRCBEGIN + " " + CircusString.CIRCSTATE + " State " +
		CircusString.CIRCDEF + " Q.State " + CircusString.AND + " R.State";

		antes[1] = Space + Space + Space + "Q.PPar " + CircusString.AND + " R.State";

		antes[2] = Space + Space + Space + "R.PPar " + CircusString.AND + "Q.State";
		antes[3] = Space + Space + Space + ZString.SPOT + "F(Q.Act,R.Act)";
		antes[4] = Space + Space + CircusString.CIRCEND;

		String[] depois = new String[1];
		depois[0] = "pd (qd rd " + CircusString.CIRCPROC + " P " + CircusString.CIRCDEF+
		" F(Q,R)";
		LawDefinitionAnn defAnn = new LawDefinitionAnn(description,detailsListOps
				,antes,depois);

		result.getAnns().add(defAnn);

		return result;
	}


	public CircusLaw createLawMainVarState() {

		// LHS 
		JokerParaList corpoProcesso = 
			this.getFactory().createJokerParaList("Processbody", null);
		BasicProcess left = 
			this.getFactory().createBasicProcess(corpoProcesso);


		// RHS 
	/*	JokerProcess right = 
			this.getFactory().createJokerProcess("P", null);

		// Obriga��o de prova do process Splitting 
		JokerPred op1 = factory.createJokerPred("op", null);
		right.getAnns().add(new ProcessMainVarState(this.getInter(), right, gerInterno));*/
		
		
		JokerParaList listaNova = factory.createJokerParaList("pl2", null);
		ProcessMainVarState ann = new ProcessMainVarState(this.getInter(),corpoProcesso,gerInterno);
		listaNova.getAnns().add(ann);
		BasicProcess right = factory.createBasicProcess(listaNova);

		// Criando o Transformer 
		ProcessTransformerPred trans = factory.createProcessTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		// Criando Obriga��es de Prova 
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.retornarMsg("MainVarState");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.1020", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);

		// Law DEFINITION
		
		String Space = "  ";

		String[] antes = new String[3];
		antes[0] = CircusString.CIRCPROC + " P " + CircusString.CIRCDEF + " " +
		CircusString.CIRCBEGIN + " " + CircusString.CIRCSTATE + " State ";

		antes[1] = Space + Space + Space + ZString.SPOT + CircusString.CIRCVAR 
		+ Space +  "x : T " + Space + ZString.SPOT  + "MA";
		antes[2] = Space + Space + CircusString.CIRCEND;

		String[] depois = new String[3];
		depois[0] = CircusString.CIRCPROC + " P " + CircusString.CIRCDEF + " " +
		CircusString.CIRCBEGIN + " " + CircusString.CIRCSTATE + " State x : T";

		depois[1] = Space + ZString.SPOT + "MA";
		depois[2] = Space + Space + CircusString.CIRCEND;
		LawDefinitionAnn defAnn = new LawDefinitionAnn(null,null
				,antes,depois);

		result.getAnns().add(defAnn);
		
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);

		return result;
	}

	public CircusLaw createLawMainVarState2() {

		// LHS 
		JokerParaList corpoProcesso = 
			this.getFactory().createJokerParaList("Processbody", null);
		BasicProcess left = 
			this.getFactory().createBasicProcess(corpoProcesso);


	//	 RHS 
	//	JokerProcess right = 
	//		this.getFactory().createJokerProcess("P", null);

	//	 Obriga��o de prova do process Splitting 
	//	JokerPred op1 = factory.createJokerPred("op", null);
	//	right.getAnns().add(new ProcessMainVarState(this.getInter(), right, gerInterno));
		
		
		JokerParaList listaNova = factory.createJokerParaList("pl2", null);
		ProcessMainVarState ann = new ProcessMainVarState(this.getInter(),corpoProcesso,gerInterno);
		listaNova.getAnns().add(ann);
		BasicProcess right = factory.createBasicProcess(listaNova);

		// Criando o Transformer 
		ProcessTransformerPred trans = factory.createProcessTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		// Criando Obriga��es de Prova 
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.retornarMsg("MainVarState2");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.1021", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);

		// Law DEFINITION
		
		String Space = "  ";

		String[] antes = new String[3];
		antes[0] = CircusString.CIRCPROC + " P " + CircusString.CIRCDEF + " " +
		CircusString.CIRCBEGIN + " " + CircusString.CIRCSTATE + " State ";

		antes[1] = Space + Space + Space + ZString.SPOT + CircusString.CIRCVAR 
		+ Space +  "x : T " + Space + ZString.SPOT  + "MA";
		antes[2] = Space + Space + CircusString.CIRCEND;

		String[] depois = new String[3];
		depois[0] = CircusString.CIRCPROC + " P " + CircusString.CIRCDEF + " " +
		CircusString.CIRCBEGIN + " " + CircusString.CIRCSTATE + " State x : T";

		depois[1] = Space + ZString.SPOT + "MA";
		depois[2] = Space + Space + CircusString.CIRCEND;
		LawDefinitionAnn defAnn = new LawDefinitionAnn(null,null
				,antes,depois);

		result.getAnns().add(defAnn);
		
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);

		return result;
	}
	/**
	 * Cria a Lei par inserir par�grafos novos no Processo.
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiInserirActionPara() {

		/* Criando o LHS da lei */
		JokerParaList leftAux = factory.createJokerParaList("pl1", null);
		BasicProcess left = factory.createBasicProcess(leftAux);

		/* Criando o RHS da lei */  	
		JokerName n = factory.createJokerName("name", null);
		JokerAction action = factory.createJokerAction("A", null);
		ActionPara pr = factory.createActionPara(n, action);
		JokerParaList listaNova = factory.createJokerParaList("pl2", null);
		JokerPred op1 = factory.createJokerPred("op1", null);
		ParaAddAnn ann = new ParaAddAnn(pr, leftAux, op1);
		listaNova.getAnns().add(ann);
		BasicProcess right = factory.createBasicProcess(listaNova);

		/* Criando o transformer */
		ProcessTransformerPred trans = factory.createProcessTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();
		ops.add(op1);

		/* Criando a Lei */
		String nome = this.retornarMsg("COD0533");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("InserirActionPara", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);


		/* Inserindo detalhes da lei*/
		String[] obs = new String[1];
		obs[0] = "pl2 contains the new inserted action paragraph";

		ArrayList<String> opsDetails = new ArrayList<String>();
		String opDetail = "The Name of the new action paragraph does not " +
		"belong to the set of the free variables of the process";
		opsDetails.add(opDetail);

		LawDefinitionAnn lawAnn = new LawDefinitionAnn(obs,opsDetails,null,null);
		result.getAnns().add(lawAnn);

		return result;
	}

	/**
	 * Cria a Lei par inserir par�grafos novos no Processo.
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiInserirPara() {

		/* Criando o LHS da lei */
		JokerParaList leftAux = factory.createJokerParaList("pl1", null);
		BasicProcess left = factory.createBasicProcess(leftAux);

		/* Criando o RHS da lei */  	
		JokerPara pr = factory.createJokerPara("pr", null);
		JokerParaList listaNova = factory.createJokerParaList("pl2", null);
		JokerPred op1 = factory.createJokerPred("op1", null);
		ParaAddAnn ann = new ParaAddAnn(pr, leftAux, op1);
		listaNova.getAnns().add(ann);
		BasicProcess right = factory.createBasicProcess(listaNova);

		/* Criando o transformer */
		ProcessTransformerPred trans = factory.createProcessTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();
		ops.add(op1);

		/* Criando a Lei */
		String nome = this.retornarMsg("COD0534");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("InserirPara", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);



		/* Inserindo detalhes da lei*/
		String[] obs = new String[1];
		obs[0] = "pl2 contains the new inserted paragraph";

		ArrayList<String> opsDetails = new ArrayList<String>();
		String opDetail = "The Name of the new paragraph does not " +
		"belong to the set of the free variables of the process";
		opsDetails.add(opDetail);

		LawDefinitionAnn lawAnn = new LawDefinitionAnn(obs,opsDetails,null,null);
		result.getAnns().add(lawAnn);

		return result;
	}


	/**
	 * Cria a Lei para altera o estado do processo;
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawChangeProcessState() {

		/* Criando o LHS da lei */
		JokerProcess left = factory.createJokerProcess("process P1\n state AState",null);


		/* Criando o RHS da lei */  	
		JokerProcess right = factory.createJokerProcess("process P2\n state CState", null);


		JokerAction act1 = factory.createJokerAction("main Action of P1", null);
		JokerAction act2 = factory.createJokerAction("main Action of P2", null);

		ActionTransformerPred op1 = factory.createActionTransformerPred(null, Transformation.Simulation,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, Arrays.asList(act1,act2));


		DataRefinementProcessLawAnn ann = new DataRefinementProcessLawAnn(left, right, act1, act2);
		right.getAnns().add(ann);

		/* Criando o transformer */
		ProcessTransformerPred trans = factory.createProcessTransformerPred(null, 
				Transformation.Simulation,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();
		ops.add(op1);

		/* Criando a Lei */
		String nome = this.retornarMsg("DataRefinement");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("ChangeProcessState", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);



		return result;
	}


	/**
	 * Cria a Lei par inserir par�grafos novos no Processo.
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw criarLeiRemoverPara() {

		/* Criando o LHS da lei */
		JokerParaList paraList = this.getFactory().createJokerParaList("pl1", 
				null);
		BasicProcess left = factory.createBasicProcess(paraList);

		/* Criando o RHS da lei */  	
		JokerName nomeARemover = 
			this.getFactory().createJokerName("name", null);
		JokerParaList listaNova = 
			this.getFactory().createJokerParaList("pl2", null);
		listaNova.getAnns().add(new RemoveParaAnn(nomeARemover, paraList));
		BasicProcess right = factory.createBasicProcess(listaNova);

		/* Criando o transformer */
		ProcessTransformerPred trans = 
			factory.createProcessTransformerPred(null, 
					Transformation.Equivalence,
					CircusUtils.DEFAULT_REFINEMENT_MODEL, 
					Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.retornarMsg("COD0536");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("RemoverPara", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.PROCESS_REFINEMENT);

		/* Inserindo detalhes da lei*/
		String[] obs = new String[1];
		obs[0] = "pl2 does not contain the removed paragraph";

		LawDefinitionAnn lawAnn = new LawDefinitionAnn(obs,null,null,null);
		result.getAnns().add(lawAnn);

		return result;
	}


}
