/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.TreeSet;

import circusRefine.util.CRefineAnnotation;

/**
 * Identificador de lei. Utilizado no salvamento do programa
 * 
 * @author Cristiano Castro
 */
public class LawNumberAnn implements CRefineAnnotation{

	/** Lista com todos od identificadores utilizados at o momento  */
	private static TreeSet<String> usedIDs = new TreeSet<String>();
	
	/** Identificador dessa lei */
	private String id;
	
	/**
	 * Inicia o identificador com o nome da lei e o seu identificador
	 * 
	 * @param newId o identificador para lei
	 * @param nomeDaLei o nome da lei no qual eu quero setar o 
	 *  identificador
	 */
	public LawNumberAnn(String newId, String nomeDaLei) {
		this.setId(newId, nomeDaLei);
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	private void setId(String newId, String nomeDaLei) {
		
		/* Testa se pode inserir esse nmero */
		if (LawNumberAnn.usedIDs.contains(newId)) {
			
			/* J tem esse identificador */
			System.err.println("Warning: Law " + nomeDaLei + 
					" is trying to use an existing Id ( " + newId + ")" );
		}
		
		this.id = newId; 
	}

	
}
