/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.LetVarAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.ProcessTransformerPred;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.SubstitutionAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerRenameList;
import circusRefine.core.InternalManager;
import circusRefine.util.Internacional;

/**
 * Uma fabrica para Leis de Circus
 * 
 * @author Cristiano Gurgel
 */
public class FabricaLeisGeral extends LawsFactory {
	
	/**
	 * Cria uma nova inst�ncia da f�brica de Leis com a classe 
	 * de internacionalizacao
	 * 
	 * @param inter a classe de internacionalizacao
	 */
	public FabricaLeisGeral(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}
	
	public List<CircusLaw> createAll() {
		LinkedList<CircusLaw> result = new LinkedList<CircusLaw>();
		

    	/* Leis Para Testes */
//    	result.add(this.criarLeiTestParseProcessLaw());
//    	result.add(this.criarLeiTesteParsePred());
//    	result.add(this.criarLeiTesteParseExpr());
//    	result.add(this.criarLeiTesteParseCommunication());
//    	result.add(this.criarLeiTesteParseName());
//    	result.add(this.criarLeiTesteParseNameList());
//    	result.add(this.criarLeiTesteParseDeclList());
//    	result.add(this.criarLeiTesteParseCircusAction());
//    	result.add(this.criarLeiTesteParseChannelSet());
//    	result.add(this.criarLeiTesteParseNameSet());
//    	result.add(this.criarLeiTesteParseExprList());
//    	result.add(this.criarLeiTesteParseRenameList());
    	
    	/* Criar Leis Auxiliares */
    	//result.add(this.criarLeiAuxiliarSubstituicaooDeAcao());
    	return result;
	}


	/**
	 * Cria Uma lei <i>Schemas/Parallelism composition -- 
	 * 	distribution</i> (C-73) 
	 * 
	 * @return a nova CircusActionLaw
	 */
//    public static CircusLaw criarLeiChannelExtension2() {
//    	CircusPatternFactory factory = new CircusPatternFactoryImpl();
//    	
//    	/* criando o LHS */
//    	JokerName x = factory.createJokerName("x", null);
//    	JokerExpr e = factory.createJokerExpr("e", null);
//    	Field campo1 = factory.createInputField(x, factory.createTruePred());
//    	Field campo2 = factory.createOutputField(e);
//    	FieldList lista1;
//    	JokerAction a1 = factory.createJokerAction("A", null);
//    	JokerAction a2 = factory.createJokerAction("B", null);
//    	JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
//    	JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
//    	JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
//    	SchExprAction sExpAction = factory.createSchExprAction(sExp);
//    	ParallelAction par = factory.createParallelAction(Arrays.asList(a1, a2),
//    			Arrays.asList(ns1, ns2), cs);
//    	SeqAction left = factory.createSeqAction(Arrays.asList(sExpAction, 
//    			par));
//    	
//    	/* Criano do RHS */
//    	SeqAction seqAction = factory.createSeqAction(Arrays.asList(sExpAction, 
//    			a1));
//    	ParallelAction right = 
//    			factory.createParallelAction(Arrays.asList(seqAction, a2),
//    			Arrays.asList(ns1, ns2), cs);
//    	
//    	/* Criando o Transformer */
//    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
//    			Transformation.Equivalence, 
//    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
//    			Arrays.asList(left, right));
//    	
//    	/* Criando Obriga��es de Prova */
//    	List<Pred> list = new ArrayList<Pred>();
//    	
//    	String nome = this.getInter().retornarMensagem("COD0473");
//    	
//    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
//    			list);
//    	
//    	return result;
//    }

    /**
     * Criando um teste de lei de processos.
     * 
     * @return uma lei teste para processos
     */
    public CircusLaw criarLeiTestParseProcessLaw() {
    	
    	/* Criando o LHS da lei */
    	JokerProcess left = factory.createJokerProcess("p", null);
    	
    	/* Criando o RHS da lei */
    	JokerProcess p1 = factory.createJokerProcess("p1", null);
    	CircusProcess right = 
    		factory.createExtChoiceProcess(Arrays.asList(left, p1));
    	
    	/* Criando o transformer */
    	ProcessTransformerPred trans = 
    			factory.createProcessTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste de lei de processos";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }
    
    /**
     * Cria uma lei simples para testar o parse de argumento de Pred.
     * 
     * @return a nova lei Circus
     */
    public CircusLaw criarLeiTesteParsePred() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerPred g2 = factory.createJokerPred("g2", null);
    	GuardedAction right = factory.createGuardedAction(left, g2);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse Pred";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }
    
    /**
     * Cria uma lei simples para exibir um parse de argumento de 
     * 	{@link Expr}
     * 
     * @return a nova lei Circus
     */
    public CircusLaw criarLeiTesteParseExpr() {
    	
    	/* Criando o LHS da lei */
    	JokerPred g1 = factory.createJokerPred("g1", null);
    	JokerAction a1 = factory.createJokerAction("A1", null);
    	GuardedAction left = factory.createGuardedAction(a1, g1);
    	    	
    	/* Criando o RHS da lei */
    	JokerAction right = factory.createJokerAction("A2", null);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse Expr";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }
    
    public CircusLaw criarLeiTesteParseCommunication() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerCommunication c = factory.createJokerCommunication(null, null, 
    			null, CommPattern.Synch, null, null, "c", null);
    	PrefixingAction right = factory.createPrefixingAction(left, c);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse Communication";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseName() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerName n = factory.createJokerName("n", null);
    	CallAction right = factory.createCallAction(n);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse Name";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseNameList() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerNameList nl = factory.createJokerNameList("nl", null);
    	JokerExpr exp = factory.createJokerExpr("exp", null);
    	VarDecl vd = factory.createVarDecl(nl, exp);
    	DeclList dl = factory.createZDeclList(Arrays.asList(vd));
    	LetVarAction right = factory.createLetVarAction(left, dl, 
    			factory.createZExprList());
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse Name List";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseDeclList() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerDeclList dl = factory.createJokerDeclList("dl", null);
    	VarDeclCommand right = factory.createVarDeclCommand(dl, left);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse Decl List";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseCircusAction() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerAction right = factory.createJokerAction("A2", null);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse CircusAction";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseChannelSet() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
    	HideAction right = factory.createHideAction(left, cs);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse ChannelSet";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseNameSet() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	SkipAction s1 = factory.createSkipAction();
    	JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
    	JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
    	InterleaveAction right = 
    		factory.createInterleaveAction(Arrays.asList(s1, s1), 
    				Arrays.asList(ns1, ns2));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse NameSet";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseExprList() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerExprList list = factory.createJokerExprList("el", null);
    	ZName name = factory.createZName("a", null, null);
    	CallAction right = factory.createCallAction(name, list);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse ExprList";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }

    public CircusLaw criarLeiTesteParseRenameList() {
    	
    	/* Criando o LHS da lei */
    	JokerAction left = factory.createJokerAction("A1", null);
    	    	
    	/* Criando o RHS da lei */
    	JokerRenameList rlist = factory.createJokerRenameList("list", null);
    	SubstitutionAction right = 
    			factory.createSubstitutionAction(factory.createSkipAction(), 
    					rlist);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = "Teste lei parse RenameList";
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	return result;
    }
    

}
