/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre External Choice
 * 
 * @author Cristiano Castro
 */
public class ExternalChoiceLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public ExternalChoiceLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_EXTERNAL_CHOICE, codName);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		
		/* C-110 */
    	result.add(this.criarLeiExternalChoiceCommutativity()); 
    	
		/* C.111 */
		result.add(this.criarLeiExternalChoiceElimination());

		/* C.112 */
		result.add(this.criarLeiExternalChoiceSequenceDistribution());
		
		/* C.113 */
		result.add(this.criarLeiExternalChoiceSequenceDistribution2());
		
		/* C.114 */
		result.add(this.criarLeiExternalChoiceUnit());
		
		return result;
	}

	/**
	 * Cria Uma lei <i>External Choice Sequence distribution  </i> 
	 * (C-112) 
	 * 
	 * Essa lei foi gerada apenas para  atuar sobre uma escolhe externa de duas 
	 * op��es.
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiExternalChoiceSequenceDistribution() {
		/* LHS */
    	JokerAction A1 = factory.createJokerAction("A1", null);
    	JokerAction A2 = factory.createJokerAction("A2", null);
    	JokerPred g1 = factory.createJokerPred("g1", null);
    	JokerPred g2 = factory.createJokerPred("g2", null);
    	JokerAction B = factory.createJokerAction("B", null);
    	
    	JokerCommunication c1 = factory.createJokerCommunication(null, null, 
    			null, null, null, null, "c1", null);
    	JokerCommunication c2 = factory.createJokerCommunication(null, null, 
    			null, null, null, null, "c2", null);
    	
    	PrefixingAction prefa1 = factory.createPrefixingAction(A1, c1);
    	PrefixingAction prefa2 = factory.createPrefixingAction(A2, c2);
    	
    	
    	GuardedAction aux1 = factory.createGuardedAction(prefa1, g1);
    	GuardedAction aux2 = factory.createGuardedAction(prefa2, g2);
    	
    	ExtChoiceAction aux3 = 
    		factory.createExtChoiceAction(Arrays.asList(aux1, aux2));
    	
    	SeqAction left = factory.createSeqAction(Arrays.asList(aux3, B));
    	
    	/* RHS */
    	
    	SeqAction laux1 = factory.createSeqAction(Arrays.asList(A1, B));
    	SeqAction laux2 = factory.createSeqAction(Arrays.asList(A2, B));
    	
    	PrefixingAction rhsPrefA1 = factory.createPrefixingAction(laux1, c1);
    	PrefixingAction rhsPrefA2 = factory.createPrefixingAction(laux2, c2);
    	
    	GuardedAction rhsGuardedA1 = factory.createGuardedAction(rhsPrefA1, g1);
    	GuardedAction rhsGuardedA2 = factory.createGuardedAction(rhsPrefA2, g2);
    	
    	CircusAction right = factory.createExtChoiceAction(Arrays.asList(rhsGuardedA1, 
    			rhsGuardedA2));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0744");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.112", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_EXTERNAL_CHOICE);
    	
    	return result;
	}

	/**
	 * Cria Uma lei <i>External Choice Commutativity</i> (C-110) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiExternalChoiceCommutativity() {
    	JokerAction A1 = factory.createJokerAction("A", null);
    	JokerAction A2 = factory.createJokerAction("B", null);
    	CircusAction left = factory.createExtChoiceAction(Arrays.asList(A1, 
    			A2));
    	CircusAction right = factory.createExtChoiceAction(Arrays.asList(A2, 
    			A1));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0473");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.110", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_EXTERNAL_CHOICE);
    	
    	return result;
    }
    
    /**
	 * Cria Uma lei <i>External Choice Elimination</i> (C-111) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiExternalChoiceElimination() {
    	JokerAction A1 = factory.createJokerAction("A", null);
    	CircusAction left = factory.createExtChoiceAction(Arrays.asList(A1, 
    			A1));
    	
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, A1));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0703");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.111", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_EXTERNAL_CHOICE);
    	
    	return result;
    }
    
    
	/**
	 * Cria Uma lei <i>External Choice Sequence distribution 2 </i> 
	 * (C-113) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiExternalChoiceSequenceDistribution2() {
    	
    	/* LHS */
    	JokerAction A1 = factory.createJokerAction("A1", null);
    	JokerAction A2 = factory.createJokerAction("A2", null);
    	JokerPred g1 = factory.createJokerPred("g1", null);
    	JokerPred g2 = factory.createJokerPred("g2", null);
    	JokerAction B = factory.createJokerAction("A3", null);
    	
    	GuardedAction aux1 = factory.createGuardedAction(A1, g1);
    	GuardedAction aux2 = factory.createGuardedAction(A2, g2);
    	ExtChoiceAction aux3 = 
    		factory.createExtChoiceAction(Arrays.asList(aux1, aux2));
    	SeqAction left = factory.createSeqAction(Arrays.asList(aux3, B));
    	
    	/* RHS */
    	SeqAction laux1 = factory.createSeqAction(Arrays.asList(aux1, B));
    	SeqAction laux2 = factory.createSeqAction(Arrays.asList(aux2, B));
    	CircusAction right = factory.createExtChoiceAction(Arrays.asList(laux1, 
    			laux2));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	ImpliesPred op1 = factory.createImpliesPred(Arrays.asList(g1, 
    			factory.createNegPred(g2)));
    	list.add(op1);
    	
    	String nome = this.createName("COD0541");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.113", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_EXTERNAL_CHOICE);
    	
    	return result;
    }
    
    /**
	 * Cria Uma lei <i>External Choice Unit</i> (C-114) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiExternalChoiceUnit() {
    	JokerAction A1 = factory.createJokerAction("A", null);
    	CircusAction left = factory.createExtChoiceAction(Arrays.asList(
    			factory.createStopAction(), A1));
    	
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, A1));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0704");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.114", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_EXTERNAL_CHOICE);
    	
    	return result;
    }
    
    

	
}
