/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circuspatt.util.CircusLaw;
import circusRefine.core.InternalManager;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre Alterna��o
 * 
 * @author Cristiano Castro
 */
public class AlternationLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public AlternationLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_ALTERNATION, codName);
	}
	
	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		return result;
	}

}
