/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.LawDefinitionAnn;
import circusRefine.core.crules.anotations.CopyRuleForADefinitionAnn;
import circusRefine.core.crules.anotations.CopyRuleForNameAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * Classe usada para criar as leis de refinamento de a��o.
 * 
 * @author crisgc
 */
public class ActionLawsFactory extends LawsFactory {
	
	
	public ActionLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	@Override
	public List<CircusLaw> createAll() {
		
		List<CircusLaw> result = new ArrayList<CircusLaw>();
    	
    	result.add(this.criarLeiDeCopiaParaNome());
    	result.add(this.criarLeiDeCopiaParaExpressao());
    	
    	return result;
	}

	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_, codName);
	}

   
    /**
     * Cria uma lei de c�pia que permite substituir o nome em uma
     * {@link CallAction} pela sua defini��o
     * 
     * @return a nova lei circus
     */
    public CircusLaw criarLeiDeCopiaParaNome() {
    	
    	/* LHS */
    	JokerAction left = 
    		this.getFactory().createJokerAction("name of action", null);
    	
    	/* RHS */
    	CopyRuleForNameAnn ann = new CopyRuleForNameAnn(left, gerInterno);
    	JokerAction right = this.getFactory().createJokerAction("its definition", 
    			null);
    	right.getAnns().add(ann);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0537");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	LawNumberAnn id = new LawNumberAnn("Cpy_Rule_Name", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_);
    	
    	/* Adicionando Detalhes*/
    	
    	String[] obs = new String[1];
    	obs[0] = "It takes the reference to a name of an action and transforms " +
    			"in the action's definition";
    	
    	LawDefinitionAnn annDetails = new LawDefinitionAnn(obs,null,null,null);
    	
    	result.getAnns().add(annDetails);
    	
    	return result;
    }

    /**
     * Cria uma lei de c�pia que permite substituir uma express�o
     * pelo seu nome
     * 
     * @return a nova lei circus
     */
    public CircusLaw criarLeiDeCopiaParaExpressao() {
    	
    	
    	/* LHS */
    	JokerAction left = 
    		this.getFactory().createJokerAction("the definition of an action", null);
    	
    	/* RHS */
    	JokerAction right = this.getFactory().createJokerAction( "its reference name" , 
    			null);
    	right.getAnns().add( new CopyRuleForADefinitionAnn( left , right, gerInterno ) );
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* Criando a Lei */
    	String nome = this.retornarMsg(LawType.ACTION_REFINEMENT_, "COD0555");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	LawNumberAnn id = new LawNumberAnn("Cpy_Rule_Expr", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_);
    	
    	String[] obs = new String[1];
    	obs[0] = "It takes the definition of an action and transforms to its reference name";
    	
    	LawDefinitionAnn annDetails = new LawDefinitionAnn(obs,null,null,null);
    	
    	result.getAnns().add(annDetails);
    	
    	return result;
    }
    
    public CircusLaw criarLeiTesteWrtV() {

    	/* LHS */
    	JokerExpr e1 = this.getFactory().createJokerExpr("e1", null);
    	SchExprAction left = this.getFactory().createSchExprAction(e1);

    	/* RHS */
    	SchExprAction right = left;
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/*
    	 * ************************
    	 * OP1: wrtV(e1) = emptyset
    	 * ************************
    	 */
    	
    	/* wrtV(e1) */
    	RefExpr wrtV = OPsDischargeUtils.refFuncao(OPsDischargeUtils.WRT_V);
    	ActionArgumentAnn ann = new ActionArgumentAnn(left);
    	RefExpr argWrtV = this.getFactory().createRefExpr();
    	argWrtV.getAnns().add(ann);
    	ApplExpr wrtVE1 = this.getFactory().createApplExpr(Arrays.asList(wrtV, 
    			argWrtV), true);
    	
    	
    	
    	/* wrtV(e1) = emptyset */
    	RefExpr emptyset = OPsDischargeUtils.criarConjuntoVazio();
    	List<? extends Expr> listaAux = Collections.singletonList(emptyset);
    	ZExprList lista = this.getFactory().createZExprList(listaAux);
    	SetExpr conjUnit = this.getFactory().createSetExpr(lista);
    	MemPred pred = this.getFactory().createMemPred(Arrays.asList(wrtVE1, 
    			conjUnit), true);
    	
    	ops.add(pred);
    	
    	/* Criando a Lei */
    	String nome = this.retornarMsg(LawType.ACTION_REFINEMENT_, "COD0617");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);
    	
    	LawNumberAnn id = new LawNumberAnn("TestWrtV", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_);
    	
    	return result;
    }
    
}
