/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerParaListBinding;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.GerenciadorInterno;
import circusRefine.core.util.BindingGetterVisitor;
import circusRefine.core.util.ParaNameGetter;
import circusRefine.core.util.ProcessOfATermGetter;

/**
 * Classe para substituir um nome em uma {@link DeclList}.
 * 
 * @author Cristiano Gurgel de Castro
 */
public class SubsWordAnn extends LawApplAnn {

	/** O joker da DeclList orginal */
	private JokerDeclList jokerListaOriginal;
	
	/** O joker do predicado original */
	private JokerPred jokerPredOriginal;
	
	/**
	 * Construtor. O joker da DeclList original, que ter um de seus 
	 * membros, substitudos  passado como parmetro, como tambm
	 * o predicado no qual ser inserido novas condies.
	 * 
	 * @param listaOriginal a lista original do Joker
	 * @param predOriginal o joker para o predicado original
	 */
	public SubsWordAnn(JokerDeclList listaOriginal, JokerPred predOriginal) {
		this.setJokerListaOriginal(listaOriginal);
		this.setJokerPredOriginal(predOriginal);
	}
	
	public JokerDeclList getJokerListaOriginal() {
		return jokerListaOriginal;
	}
	
	public void setJokerListaOriginal(JokerDeclList jokerListaOriginal) {
		this.jokerListaOriginal = jokerListaOriginal;
	}
	
	public JokerPred getJokerPredOriginal() {
		return jokerPredOriginal;
	}
	
	public void setJokerPredOriginal(JokerPred jokerPredOriginal) {
		this.jokerPredOriginal = jokerPredOriginal;
	}
	
	public void apply(GerenciadorInterno interno, Set<Binding> unificacao,
			Term parametro) {
		
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		
		for (Binding bind : unificacao) {
			Map<String, Term> mapeamento = BindingGetterVisitor.getMap(bind);
			Term result = mapeamento.get(this.getNomeAcao().getName());

			if ( result != null ) { /* Achou o nome */

				/* Busca o processo no qual est definido o AInit */
				CircusProcess proc = ProcessOfATermGetter.getProcess(result, 
						interno.retornarProgAtual());
				
				/*  */
				

				/* Captura os nomes do pargrafo */
				ZNameList lista = ParaNameGetter.getNameList(novoParagrafo);
				ZExprList listaExpr = factory.createZExprList();
				for (Name nome : lista) {
					if (nome instanceof ZName) {
						listaExpr.add(factory.createRefExpr(nome, 
								factory.createZExprList(), false, false));
					}
				}
				
				/* Montando a OP */
				RefExpr funcao = 
					factory.createRefExpr(factory.createZName("newNames _", 
							factory.createZStrokeList(), null), 
							factory.createZExprList(), false, false);
				TupleExpr expr2 = factory.createTupleExpr(listaExpr);
				ApplExpr expr = 
					factory.createApplExpr(Arrays.asList(funcao, expr2), true);
				realOp = factory.createExprPred(expr);
				
				/* Achou a ParaList Inicial */
				ZParaList lista1 = factory.createZParaList((ZParaList)result);
				lista1.add((Para)novoParagrafo);

				/* Cria o binding para o pl2 */
				JokerParaListBinding binding = 
					factory.createJokerParaListBinding((JokerParaList)parametro, 
							lista1);
				unificacao.add(binding);
				
			} 
		}
		
		/* Adiciona a OP na lista de unificao */
		unificacao.add(factory.createJokerPredBinding(this.getOp(), realOp));

	}
	
	private void aplicarEmDeclList(GerenciadorInterno interno, 
			Set<Binding> unificacao, JokerDeclList parametro) {
		Term result = 
			LawApplAnn.procurarOriginal(this.getJokerListaOriginal().getName(), 
					unificacao);
		
		/* Achou o a ListaOriginal */
		if (result != null) {
			JokerName nomeARemover = new JokerName()
			
		}
	}
	


}
