package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;


import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Exists1Pred;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.ForallPred;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.PreExpr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CircusLawApplicationException;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.crules.utils.DashedTerm;
import circusRefine.core.crules.utils.DefinitionFromATermGetter;
import circusRefine.core.finder.SchemaFinder;
import circusRefine.core.print.Printer;

public class SchemaExpressionsAnn extends LawApplAnn{
	
	JokerExpr ASExpr;
	JokerPred pred1;
	JokerPred pred2;
	JokerAction CSExpr;
	
	public SchemaExpressionsAnn(JokerExpr ASEXpr, JokerAction CSEpr,JokerPred pred1, JokerPred pred2) {
		this.ASExpr = ASEXpr;
		this.CSExpr = CSEpr;
		this.pred1 = pred1;
		this.pred2 = pred2;
		
	}
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		SchExpr absExpr = (SchExpr)this.findOriginal(ASExpr.getName(), unificacao);
		
		
		/*Perguntar qual o estado abstrato*/
		JokerName nameAS = factory.createJokerName("Name of AState", null);
		
		/*Perguntar qual o estado concreto*/
		JokerName nameCS = factory.createJokerName("Name of CState", null);
		
		/*Perguntar qual o retrieve Relation*/
		JokerName jokerRetr = factory.createJokerName("Name of the Retrieve Relation", null);
		
		LinkedList<Term> lista = new LinkedList<Term>();
		lista.add(nameAS);
		lista.add(jokerRetr);
		
		Set< Binding > retorno = crUtils.getParameters(lista, resposta);
		
		ZName znameAS = (ZName)this.findOriginal(nameAS.getName(), retorno);
		ZName retr = (ZName)this.findOriginal(jokerRetr.getName(), retorno);

		/*
		 * Verificar se há parágrafos definidos com os nomes.
		 */
		/*boolean itHas  = SchemaFinder.hasSchema(znameAS.getWord(), crUtils.getInterno().retornarProgAtual());
		if (!itHas) {
			String msg = MessagesManager.getInstance().getMessage("AbsStateNotFoundError2");
			throw  new CircusLawApplicationException(msg);
		}
		
		itHas = SchemaFinder.hasSchema(retr.getWord(), crUtils.getInterno().retornarProgAtual());
		if (!itHas) {
			String msg = MessagesManager.getInstance().getMessage("RetrStateNotFoundError2");
			throw  new CircusLawApplicationException(msg);
		}
		*/
		 boolean itHas = false;
		 
		 /*Obtendo as variáveis locais L da operação*/
		 ZDeclList Llist = factory.createZDeclList();
		 
		/* Verificando se a ação passada contém o estado abstrato*/
		for (Decl decl : absExpr.getZSchText().getZDeclList() ) {
			if (Printer.printLATTEX(decl).contains(znameAS.getWord())){
				itHas = true;
			}
			else {
				Llist.add(decl);
			}
		}
		
		ZDeclList LlistLinha = (ZDeclList) DashedTerm.getDashedTerm(Llist);
		
		if (!itHas) {
			String msg = MessagesManager.getInstance().getMessage("AbsStateNotFoundError");
			throw  new CircusLawApplicationException(msg); 
		}
		itHas = false;
		
		JokerExpr jokerCSExpr = factory.createJokerExpr("CSExpr", null);
		
		lista.clear();
		lista.add(nameCS);
		lista.add(jokerCSExpr);
		
		retorno = crUtils.getParameters(lista, resposta);
		
		ZName znameCS = (ZName)this.findOriginal(nameCS.getName(), retorno);
		
		/*itHas = SchemaFinder.hasSchema(znameCS.getWord(), crUtils.getInterno().retornarProgAtual());
		if (!itHas) {
			String msg = MessagesManager.getInstance().getMessage("CStateNotFoundError2");
			throw  new CircusLawApplicationException(msg);
		}*/
		
		SchExpr concExpr = (SchExpr)this.findOriginal(jokerCSExpr.getName(), retorno);
		/* Verificando se a ação passada contém o estado concreto*/
		for (Decl decl : concExpr.getZSchText().getZDeclList() ) {
			if (Printer.printLATTEX(decl).contains(znameCS.getWord())){
				itHas = true;
				break;
			}
		}
		
		if (!itHas) {
			String msg = MessagesManager.getInstance().getMessage("CStateNotFoundError");
			throw  new CircusLawApplicationException(msg); 
		}
		
		
		SchExprAction absSchExprAct = factory.createSchExprAction(absExpr);
		RefExpr ASExpr = factory.createRefExpr();
		ASExpr.getAnns().add(new ActionArgumentAnn(absSchExprAct));
		
		SchExprAction conSchExprAct = factory.createSchExprAction(concExpr);
		RefExpr CSExpr2 = factory.createRefExpr();
		CSExpr2.getAnns().add(new ActionArgumentAnn(conSchExprAct));
		
		/* Adicionando ação unificada*/
		
		JokerActionBinding binding = factory.createJokerActionBinding(CSExpr, conSchExprAct);
		unificacao.add(binding);
		
		/* OP111*/
		
		PreExpr preASExpr = factory.createPreExpr(ASExpr);
		PreExpr preCSExpr = factory.createPreExpr(CSExpr2);
		
		SchExpr expr = factory.createSchExpr();
		
		SchExpr retrExpr =  SchemaFinder.getSchema(retr.getWord(), crUtils.getInterno());
		
		
		SchExprAction retrExpSchExprAction = factory.createSchExprAction(retrExpr);
		RefExpr RExpr = factory.createRefExpr();
		RExpr.getAnns().add(new ActionArgumentAnn(retrExpSchExprAction));
		
		
		ExprPred preA = factory.createExprPred(preASExpr);
		ExprPred preC = factory.createExprPred(preCSExpr);
		Pred Rpred = retrExpr.getZSchText().getPred();
		
		ImpliesPred impliesPres = factory.createImpliesPred(Arrays.asList(preA, preC));
		AndPred primeiraOPPred = factory.createAndPred(Arrays.asList(Rpred, impliesPres), And.Wedge);
		
		
		VarDecl absState = factory.createVarDecl(factory.createZNameList(Arrays.asList(znameAS)), null);
		VarDecl conState = factory.createVarDecl(factory.createZNameList(Arrays.asList(znameCS)), null);
		ZDeclList lista1 = factory.createZDeclList(Arrays.asList(absState, conState));
		/*Adicionando variáveis locais */
		for (Decl decl: Llist){
			lista1.add(decl);
		}
		ZSchText schema1 = factory.createZSchText(lista1, factory.createTruePred());
		ForallPred op1 = factory.createForallPred(schema1, primeiraOPPred);
		
		JokerPredBinding binding2 = factory.createJokerPredBinding(pred1, op1);
		unificacao.add(binding2);
		
		/* Construindo o OP2 */
		
		SchExprAction dashedRetrSchExprAction = (SchExprAction) DashedTerm.getDashedTerm(retrExpSchExprAction);
		
		RefExpr RExprLinha = factory.createRefExpr();
		RExprLinha.getAnns().add(new ActionArgumentAnn(dashedRetrSchExprAction));
		Pred predRExprLinha = ((SchExpr)(DashedTerm.getDashedTerm(retrExpr))).getZSchText().getPred();
		
		Pred predA = absExpr.getZSchText().getPred();
		AndPred and2 = factory.createAndPred(Arrays.asList(predRExprLinha, predA),And.Wedge);
		
		VarDecl absStateLinha = (VarDecl) DashedTerm.getDashedTerm(absState);
		VarDecl conStateLinha = (VarDecl) DashedTerm.getDashedTerm(conState);
		
		ZDeclList existsDeclList = factory.createZDeclList(Arrays.asList(absStateLinha));
		for (Decl decl: LlistLinha){
			existsDeclList.add(decl);
		}
		
		Exists1Pred exists = factory.createExists1Pred(factory.createZSchText(existsDeclList,
				factory.createTruePred()), and2);
		
		Pred predC = concExpr.getZSchText().getPred();
		
		AndPred and1 = factory.createAndPred(Arrays.asList(Rpred, preA ), And.Wedge);
		AndPred andFinal = factory.createAndPred(Arrays.asList(predC, and1 ), And.Wedge);
		
		ImpliesPred predicadoOPPred = factory.createImpliesPred(Arrays.asList(andFinal, exists));
		ZDeclList declLista2 = factory.createZDeclList(Arrays.asList(absState,conState, conStateLinha));
		for (Decl decl: Llist){
			declLista2.add(decl);
		}
		
		ForallPred op2 = factory.createForallPred(factory.createZSchText(declLista2, factory.createTruePred()), predicadoOPPred);
		
		JokerPredBinding binding3 = factory.createJokerPredBinding(pred2, op2);
		unificacao.add(binding3);
		
		Set<Term> aRetornar = new HashSet<Term>();
		aRetornar.add(CSExpr);
		aRetornar.add(pred1);
		aRetornar.add(pred2);
		return aRetornar;
	}

}
