package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.UpdateVisitor;

public class RecursionUnfoldPart1Ann extends LawApplAnn{
	
	private JokerName x;
	private JokerAction fx;
	private JokerAction right;
	
	public RecursionUnfoldPart1Ann(JokerName x, JokerAction fx, JokerAction right) {
		super();
		this.x= x;
		this.fx = fx;
		this.right = right;
	}

	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao, Term parametro, LawAnswer resposta) throws Exception {
		
		/*pega o x*/
		ZName xNome = (ZName)this.findOriginal(x.getName(), unificacao);
		
		/* pega o fx*/
		CircusAction fxAction = (CircusAction) this.findOriginal(fx.getName(), unificacao);
		
		/* substitui em fx, x por uX*F(X)*/
		CallAction xCall = factory.createCallAction(xNome);
		MuAction left = this.factory.createMuAction(fxAction,xNome);
		
		CircusAction acao = (CircusAction)UpdateVisitor.update(xCall, left,fxAction,false);
		
		/* unifica uX*F(X)*/
		/* Construir Termo*/
		/* Unificando o x */
		JokerActionBinding  bind1= 
			this.factory.createJokerActionBinding(right, acao);
		/* Unificar a Acao*/
		
		unificacao.add(bind1);
		
		/* retorna os jokers que nao sao parametros*/
		Set<Term> aRetornar = new HashSet<Term>();
		aRetornar.add(right);
		aRetornar.add(x);
		aRetornar.add(fx);
		return aRetornar;
	}

}
