/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.ChannelPara;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.impl.ActionParaImpl;
import net.sourceforge.czt.circus.impl.VarDeclCommandImpl;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerParaListBinding;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.ast.JokerProcessBinding;
import net.sourceforge.czt.circuspatt.impl.JokerProcessImpl;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Sect;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.impl.AxParaImpl;
import net.sourceforge.czt.z.impl.ConstDeclImpl;
import net.sourceforge.czt.z.impl.VarDeclImpl;
import net.sourceforge.czt.z.impl.ZParaListImpl;
import net.sourceforge.czt.z.util.ZChar;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.core.InternalManager;
import circusRefine.core.LawAnswer;
import circusRefine.core.NoPrograma;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.UpdateVisitor;
import circusRefine.core.crules.utils.ParaListGetter;
import circusRefine.core.crules.utils.ProcessFromMainActionMounter;
import circusRefine.core.crules.utils.ProcessesMounter;
import circusRefine.core.finder.SchemaFinder;
import circusRefine.util.Internacional;
import circusRefine.util.Pair;

/**
 * 
 * 
 * @author Madiel Filho
 */
public class ProcessMainVarState extends LawApplAnn {

	/**
	 * O joker para a lista de processo no qual a lei deve ser 
	 * aplicada. 
	 */
	private JokerParaList jokerCorpo;
	
	/** Nova defini��o do processo original */
	private JokerProcess novoProcesso;
	
	/** Predicado a ser unificado com a obriga��o de prova da lei  */
	private JokerPred op;
	
	/**
	 * Atributo para a internacionaliza��o das mensagens dos par�metros
	 */
	private Internacional inter;
	
	private InternalManager gerInterno;
	
	/**
	 * O construtor do aplicador da lei
	 * 
	 * @param lista a lista com os par�grafos do BasicProcess que se
	 *  pretende quebrar segundo a lei C-146
	 */
	public ProcessMainVarState(Internacional inter, JokerParaList lista, 
			/*JokerProcess novaDefinicaoProcesso*/  InternalManager gerInt) {
		this.setJokerCorpo(lista);
		this.setInter(inter);
		//this.setNovoProcesso(novaDefinicaoProcesso);
		gerInterno = gerInt;
	}
	
	public ProcessMainVarState(Internacional inter2, JokerProcess right,
			InternalManager gerInterno2) {
		this.setInter(inter);
		this.setNovoProcesso(right);
		gerInterno = gerInterno2;
	}

	public ProcessMainVarState(Internacional inter2, InternalManager gerInterno2) {
		this.setInter(inter2);
		gerInterno = gerInterno2;
	}

	
	private JokerParaList getJokerCorpo() {
		return jokerCorpo;
	}
	
	private void setJokerCorpo(JokerParaList jokerCorpo) {
		this.jokerCorpo = jokerCorpo;
	}
	
	private Internacional getInter() {
		return inter;
	}
	
	private void setInter(Internacional inter) {
		this.inter = inter;
	}
	
	/**
	 * @return the novoProcesso
	 */
	private JokerProcess getNovoProcesso() {
		return novoProcesso;
	}

	/**
	 * @param novoProcesso the novoProcesso to set
	 */
	private void setNovoProcesso(JokerProcess novoProcesso) {
		this.novoProcesso = novoProcesso;
	}

	private JokerPred getOp() {
		return op;
	}

	private void setOp(JokerPred op) {
		this.op = op;
	}

	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception  {
		
		/**
		 * Pegar Processo
		 * neste caso o Diff
		 */
		
		ZDeclList listaZDecl = factory.createZDeclList();
		ZDeclList listaFinalSchema = factory.createZDeclList();
		CircusAction mainAction = null;
		String nameMain = "";
		ZName nomeEstado = null;
		ZDeclList newDeclaracoes = factory.createZDeclList();
		ZSchText newSch = factory.createZSchText();
		ZParaList newParaList = factory.createZParaList();
		AxPara newAxPara = factory.createAxPara();
		
		ZParaList processoNew = 
			(ZParaList)	LawApplAnn.findOriginal(this.getJokerCorpo().getName(), 
					unificacao);
		
		/* Pegar o schema com o nomeState*/
		String nomeState = ""; //guarda o nome do estado

		SchExpr estado = SchemaFinder.getSchema(nomeState, crUtils.getInterno().retornarProgAtual());

		
		BasicProcess bp = factory.createBasicProcess(processoNew);
		CircusAction mainAction2 = bp.getMainAction();
		
		ZParaList lista = bp.getZParaList();
		
		for (Para p : lista) {

			// Pegar a lista de Decl do Var
		if (p instanceof ActionParaImpl){
				ActionPara ap = (ActionPara) p;
				ap.getCircusAction();
				nameMain = ap.getName()+"";
				if (ap.getCircusAction() instanceof VarDeclCommandImpl){
					VarDeclCommand var = (VarDeclCommand) ap.getCircusAction();
					var.getZDeclList();
					
					ZDeclList listZD = var.getZDeclList();
					mainAction = var.getCircusAction();
					for (Decl decl : listZD) {
						listaZDecl.add(decl);
					}
					
					var.getDeclList();
				}
			}
		else if(p instanceof AxParaImpl){
			System.out.println("NAO FAC NADA!");
		}
		else 
		  newParaList.add(p);
		}
		
		
		for (Para p : lista) {

			// Setar a lista no Schema
			 if( p instanceof AxParaImpl){
				ZNameList name = ((AxParaImpl) p).getZNameList();
				name.getName();
				newAxPara = (AxPara) p;
				ZSchText text = ((AxParaImpl) p).getZSchText();
				ZDeclList decl = text.getZDeclList();
			
				for (Decl decl2 : decl) {
					if (decl2 instanceof ConstDeclImpl){
						ConstDeclImpl con = (ConstDeclImpl) decl2;
						/*
						 * Nome do Schema
						 */
						nomeState = con.getZName()+"";
						nomeEstado = factory.createZName(nomeState, factory.createZStrokeList(), null);
						estado = SchemaFinder.getSchema(nomeState, crUtils.getInterno().retornarProgAtual());
						ZDeclList declaracoes = estado.getZSchText().getZDeclList();
						declaracoes.getDecl();
						for (Decl decl3 : declaracoes.getDecl()) {
							if (decl3 instanceof VarDeclImpl){
								VarDeclImpl var3 = (VarDeclImpl) decl3;
								listaFinalSchema.add(decl3);
								
							}
						}
						listaZDecl.addAll(listaFinalSchema);
						estado.getZSchText().setDeclList(listaZDecl);
						newDeclaracoes = estado.getZSchText().getZDeclList();
						newSch.setDeclList(newDeclaracoes);
						
						/*Term ast = crUtils.getInterno().getProgramaAtual();
						Term novaAST = UpdateVisitor.update(applicableTemp, novoTemp, ast,true);
		*/			
					}
					
				}
              break;
			}
			
		
		}
		
		
		bp.getZParaList();
		
		processoNew = 
			(ZParaList)	LawApplAnn.findOriginal(this.getJokerCorpo().getName(), 
					unificacao);
		
		/**
		 * Montar o novo processo
		 */

		ZName nomeAcaoPricipal = this.factory.createZName(nameMain, 
				this.factory.createZStrokeList(), null);
		ActionPara acaoPrincipal = 
			this.factory.createActionPara(nomeAcaoPricipal, 
					mainAction);
		newParaList.add(acaoPrincipal);
		newAxPara.setSchText(newSch);
		newParaList.add(newAxPara);
        //Term select = gerInterno.getSelectedProg();

		/*BasicProcess newBasicProces = factory.createBasicProcess(newParaList);
		
		ProcessPara p1 = 
			this.factory.createProcessPara(nomeEstado,
					this.factory.createZNameList(), newBasicProces);
		
		ZName np = factory.createZName("JustMainActionBasicProcessMultiple", 
				factory.createZStrokeList(), null);
		
		
		
		CircusProcess novaDef = ProcessFromMainActionMounter.montarProcessoTactic
		(mainAction2, mainAction, np);
	
		JokerProcessBinding newProcess = factory.createJokerProcessBinding(this.getNovoProcesso(),
				novaDef);
		*/

		JokerParaListBinding binding = 
			factory.createJokerParaListBinding((JokerParaList)parametro, 
					newParaList);
		unificacao.add(binding);


		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add(newParaList);
		return toReturn;
	}
	
	
	/**
	 * Monta os novos processos resultantes da aplica��o da lei e a 
	 * nova defini��o do processo Original
	 * 
	 * @param original o processo original
	 * @param parametros as unifica��es
	 * @return o par com os novos par�grafos do processo e a nova 
	 *  defini��o do processo original
	 */
	private Pair<Pair<Pair<ProcessPara, ProcessPara>, Pred>, CircusProcess>
		montarProcessos(BasicProcess original, Set<Binding> parametros, 
				Spec ast) {

		/* Recupera os nomes dos processos */
		ZName nomePrimeiroProcesso = (ZName) 
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0561"),
					parametros);
		ZName nomeSegundoProcesso = (ZName)
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0562"), 
					parametros);
		
		/* A��es principais dos processos */
		CircusAction acaoPrincipalPrimeiroProcesso = (CircusAction)
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0564"),
					parametros);
		CircusAction acaoPrincipalSegundoProcesso = (CircusAction)
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0565"),
					parametros);
		
		/* 
		 * Monta os novos par�grafos do processo e a nova defini��o do
		 * processo orginal 
		 */
		Pair<Pair<ProcessPara, ProcessPara>, Pred> paras = 
			ProcessesMounter.montarProcessos(nomePrimeiroProcesso, 
				nomeSegundoProcesso, acaoPrincipalPrimeiroProcesso, 
				acaoPrincipalSegundoProcesso, original, ast, gerInterno);
		CircusAction mainAction = original.getMainAction();
		CircusProcess novaDef = 
			ProcessFromMainActionMounter.montarProcesso(mainAction, 
					acaoPrincipalPrimeiroProcesso, acaoPrincipalSegundoProcesso, 
					nomePrimeiroProcesso, nomeSegundoProcesso);		
		return new Pair<Pair<Pair<ProcessPara, ProcessPara>, Pred>, CircusProcess>(paras, novaDef);
	}
	
	
	
}
