/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerParaListBinding;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.LawAnswer;
import circusRefine.core.astmodifiers.ProcessArgumentAnn;
import circusRefine.core.crules.BuilderVisitor;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.utils.ProcessParaFromAParaListGetter;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.core.util.JokersGetterVisitor;
import circusRefine.core.util.ParaNameGetter;

/**
 * Classe usada para adicionar um Par�grafo a uma Lista de 
 * Par�grafos.
 * 
 * @author Cristiano Gurgel
 */
public class ParaAddAnn extends LawApplAnn {

	/** O par�grafo a ser adicionado */
	private Para paragrafo;

	private JokerParaList listaInicial;
	
	private JokerPred op;

	/**
	 * Construtor. Recebe o par�grafo a ser adicionado � lista.
	 * 
	 * @param novoPara o novo par�grafo a ser adicionado
	 * @param nome um Joker Representando o Nome do Par�grafo
	 * @param listaOriginal o joker a ser unificado com a lista original
	 */
	public ParaAddAnn(Para novoPara, JokerParaList listaOriginal, 
			JokerPred op1) {
		this.setParagrafo(novoPara);
		this.setListaInicial(listaOriginal);
		this.setOp(op1);
	}

	/**
	 * Acessa o Par�grafo a ser adicionado
	 *  
	 * @return o par�grafo a ser adicionado ao {@link ParaList}
	 */
	public Para getParagrafo() {
		return paragrafo;
	}

	private void setParagrafo(Para paragrafo) {
		this.paragrafo = paragrafo;
	}

	public JokerParaList getListaInicial() {
		return listaInicial;
	}

	public void setListaInicial(JokerParaList listaInicial) {
		this.listaInicial = listaInicial;
	}

	public JokerPred getOp() {
		return op;
	}

	public void setOp(JokerPred op) {
		this.op = op;
	}

	/**
	 * M�todo para complementar a aplica��o da Lei. Adiciona um 
	 * par�grafo a uma ParaList representada por um JokerParaList
	 * definido na cria��o da Lei.
	 * 
	 * @param gerInterno o gerenciador interno, usado para capturar 
	 *  par�metros definidos pelo usu�rio
	 * @param unificacao a lista com as unifica��es
	 * @param parametro o JokerParaList representado a lista depois 
	 *  da opera��o
	 */
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao, 
			Term parametro, LawAnswer resposta) throws Exception {

		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		Pred realOp = null;
		ParaList result = (ParaList) 
		ParaAddAnn.findOriginal(this.getListaInicial().getName(), unificacao);

		if ( result != null ) { /* Achou o mapeamento da lista principal */

			/* Monta o par�grafo a ser inserido na paralist */
			List<Term> jokers = 
				JokersGetterVisitor.getJokers(this.getParagrafo());
			Set<Binding> unify = crUtils.getParameters(jokers, resposta);
			Para novoParagrafo = (Para) 
			BuilderVisitor.build(this.getParagrafo(), unify);

			/* Captura os nomes do par�grafo */
			ZName nome = ParaNameGetter.getNameList(novoParagrafo);

			/* monta a express�o com o nome do par�grafo */
			RefExpr nomeNovoPara = factory.createRefExpr(nome, 
					factory.createZExprList(), false, false);

			/* ---------------- Montando a OP ---------------- */

			/* Nome do processo */
			ZName nomeProcesso = 
				ProcessParaFromAParaListGetter.getName((ZParaList)result, 
						crUtils.getInterno().retornarProgAtual()).getZName();
			
			CallProcess chamadaProcesso = 
				this.factory.createCallProcess(nomeProcesso);
			
			/* Cria a refer�ncia ao processo para argumento de fun��o */
			RefExpr argProcess = 
				ProcessArgumentAnn.montarReferenciaProcesso(chamadaProcesso);

			/* Criando aplica��o da fun��o FV_Expr */
			RefExpr fv = 
				OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Process); 

			ApplExpr fvFunAppl = 
				factory.createApplExpr(Arrays.asList(fv, argProcess), false);

			/* Montando � refer�ncia � fun��o "\notin" */
			realOp = factory.createMemPred(Arrays.asList(nomeNovoPara, 
					fvFunAppl), false);
			realOp = factory.createNegPred(realOp);

			/* Achou a ParaList Inicial */
			ZParaList lista1 = factory.createZParaList((ZParaList)result);
			lista1.add((Para)novoParagrafo);

			/* Cria o binding para o pl2 */
			JokerParaListBinding binding = 
				factory.createJokerParaListBinding((JokerParaList)parametro, 
						lista1);
			unificacao.add(binding);

		} 

		/* Adiciona a OP na lista de unifica��o */
		unificacao.add(factory.createJokerPredBinding(this.getOp(), realOp));

		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add(parametro);
		return toReturn;
	}

}

