/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel
 */
package circusRefine.core.crules.anotations;

import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.zpatt.ast.Binding;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.util.BindingGetterVisitor;
import circusRefine.util.Pair;

/**
 * Classe abstrata para as anotações que auxiliam a aplicação de
 * determinadas leis
 * 
 * @author Cristiano Gurgel
 */
public abstract class LawApplAnn {

	/** Fabrica */
	protected CircusPatternFactory factory = new CircusPatternFactoryImpl();
	
	/**
	 * Auxilia a aplicação de determinadas leis.
	 * 
	 * @param interno o gerenciador interno da ferramenta
	 * @param unificacao o conjunto com as unificações da leis feitas
	 *  até o momento da chamada
	 * @param parametro o termo que contem este tipo de anotação
	 * @return parametros a Remover da lista de unificação
	 */
	public abstract Set<Term> apply(CRulesUtils crUtils, 
			Set<Binding> unificacao, Term parametro, LawAnswer resposta) 
			throws Exception;
	
	/**
	 * Procura pela definição de um termo no conjunto de unificação
	 * 
	 * @param nome o nome a ser pesquisado
	 * @param unificacao o conjunto da unificação
	 * @return o termo procurado, caso o nome seja definido na unificação
	 *  ou <code>null</code> caso contrerio.
	 */
	public static Term findOriginal(String nome, Set<? extends Binding> unificacao) {
		for(Binding bind : unificacao) {
			Pair<String, Term> mapeamento = BindingGetterVisitor.getMap(bind);
			
			if (mapeamento.getFirst().equals(nome)) {/* Achou */
				return mapeamento.getSecond();
			}
		}
		return null; /* Procurou, mas nao achou */
	}
	
}
