/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel 
 */
package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.Binding;
import circusRefine.core.ExternalManager;
import circusRefine.core.InternalManager;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CircusLawApplicationException;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.crules.utils.NameFromAnActionGetter;
import circusRefine.core.print.Printer;

/**
 * Classe �til para substituir uma defini��o por uma a��o
 * 
 * @author Cristiano Gurgel
 */
public class CopyRuleForADefinitionAnn extends LawApplAnn {

	/** O joker da a��o original */
	private JokerAction jokerOriginal;
	
	/** O joker da a��o que vai se ligar com o nome */
	private JokerAction jokerNome;
	
	/**  Referencia para o Gerenciador Interno*/
	private InternalManager gerInterno;
	
	/**
	 * 
	 * 
	 * @param jokerAcao
	 */
	public CopyRuleForADefinitionAnn(JokerAction aSubstituir , 
			JokerAction nome , InternalManager gerInter) {
		this.setJokerActionOriginal( aSubstituir );
		this.setJokerNome( nome );
		this.gerInterno = gerInter;
	}
	
	private JokerAction getJokerActionOriginal() {
		return jokerOriginal;
	}
	
	private void setJokerActionOriginal(JokerAction jokerExprOriginal) {
		this.jokerOriginal = jokerExprOriginal;
	}

	private JokerAction getJokerNome() {
		return jokerNome;
	}

	private void setJokerNome(JokerAction jokerNome) {
		this.jokerNome = jokerNome;
	}

	@Override
	// TODO tirar o argumento de par�metro do m�todo apply geral
	/**
	 * Aplica uma lei inversa de c�pia, substituindo uma defini��o
	 *  (a��o) pelo nome que ela representa
	 */
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		/* Procura pelo A��o original */
		CircusAction result = (CircusAction)
			LawApplAnn.findOriginal(this.getJokerActionOriginal().getName(), 
				unificacao);
		
		ZName nomeALigar = 
			NameFromAnActionGetter.search(result, 
					crUtils.getInterno().retornarProgAtual(), gerInterno);
		CircusAction refAction;
		
		if (nomeALigar == null) {
			String msg = MessagesManager.getInstance().getMessage("CRefineLawApplErrorCpyRuleInverse");
			throw  new CircusLawApplicationException(msg);
		}
		
		/* Testa se � o result � um termo tempor�rio */
		if ( ExternalManager.isTemporaryTerm( result ) ) {
			
			RefExpr refAcao = this.factory.createRefExpr( nomeALigar , 
					this.factory.createZExprList() , false , false );
			refAction = this.factory.createSchExprAction( refAcao );
		} else {
			refAction = this.factory.createCallAction( nomeALigar );
		}
		/* Substitui o JokerName pela sua defini��o */
		JokerActionBinding novoBind = 
			this.factory.createJokerActionBinding( this.getJokerNome() , 
					refAction );
		unificacao.add( novoBind );
		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add( this.getJokerNome() );
		return toReturn;
		
	}

}
